/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.parser;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.engine.parser.AtlParser;

public final class AtlSourceManager {
    public static final String COMPILER_TAG = "atlcompiler";
    public static final String URI_TAG = "nsURI";
    public static final String PATH_TAG = "path";
    public static final String LIB_TAG = "lib";
    public static final int ATL_FILE_TYPE_UNDEFINED = 0;
    public static final int ATL_FILE_TYPE_MODULE = 1;
    public static final int ATL_FILE_TYPE_QUERY = 3;
    public static final int ATL_FILE_TYPE_LIBRARY = 4;
    public static final int FILTER_ALL_METAMODELS = 0;
    public static final int FILTER_INPUT_METAMODELS = 1;
    public static final int FILTER_OUTPUT_METAMODELS = 2;
    private ResourceSet resourceSet;
    private Map metamodelsPackages = new HashMap();
    private Map inputModels = new LinkedHashMap();
    private Map outputModels = new LinkedHashMap();
    private List librariesImports = new ArrayList();
    private int atlFileType;
    private String atlCompiler;
    private boolean initialized;
    private boolean isRefining;
    private EObject model;
    private Map metamodelLocations = new HashMap();
    private Map libraryLocations = new HashMap();

    public AtlSourceManager() {
        this.resourceSet = new ResourceSetImpl();
    }

    public int getATLFileType() {
        return this.atlFileType;
    }

    public Map getInputModels() {
        return this.inputModels;
    }

    public Map getOutputModels() {
        return this.outputModels;
    }

    public List getLibrariesImports() {
        return this.librariesImports;
    }

    public void updateDataSource(String content) {
        this.parseMetamodels(content);
    }

    public void updateDataSource(InputStream inputStream) throws IOException {
        String content = null;
        byte[] bytes = new byte[inputStream.available()];
        inputStream.read(bytes);
        content = new String(bytes);
        this.updateDataSource(content);
    }

    public boolean isRefining() {
        return this.isRefining;
    }

    public EObject getModel() {
        return this.model;
    }

    public Map getMetamodelPackages(int filter) {
        switch (filter) {
            case 1: {
                HashMap inputres = new HashMap();
                for (String id : this.inputModels.values()) {
                    inputres.put(id, this.metamodelsPackages.get(id));
                }
                return inputres;
            }
            case 2: {
                HashMap outputres = new HashMap();
                for (String id : this.outputModels.values()) {
                    outputres.put(id, this.metamodelsPackages.get(id));
                }
                return outputres;
            }
        }
        return this.metamodelsPackages;
    }

    public List getMetamodelPackages(String metamodelId) {
        return (List)this.metamodelsPackages.get(metamodelId);
    }

    private void parseMetamodels(String text) {
        List compilers = AtlSourceManager.getTaggedInformations(text.getBytes(), COMPILER_TAG);
        this.atlCompiler = AtlSourceManager.getCompilerName(compilers);
        List uris = AtlSourceManager.getTaggedInformations(text.getBytes(), URI_TAG);
        for (String line : uris) {
            EPackage regValue;
            if (line.split("=").length != 2) continue;
            String name = line.split("=")[0].trim();
            String uri = line.split("=")[1].trim();
            if (uri == null || uri.length() <= 0 || (regValue = EPackage.Registry.INSTANCE.getEPackage(uri = uri.trim())) == null) continue;
            this.metamodelLocations.put(name, "uri:" + uri);
            this.metamodelsPackages.put(name, AtlSourceManager.getAllPackages(regValue));
        }
        List paths = AtlSourceManager.getTaggedInformations(text.getBytes(), PATH_TAG);
        for (String line : paths) {
            if (line.split("=").length != 2) continue;
            String name = line.split("=")[0].trim();
            String path = line.split("=")[1].trim();
            if (path == null || path.length() <= 0) continue;
            path = path.trim();
            Resource resource = null;
            try {
                resource = path.startsWith("file:/") || path.startsWith("platform:/plugin") ? AtlSourceManager.load(URI.createURI((String)path, (boolean)true), this.resourceSet) : AtlSourceManager.load(URI.createPlatformResourceURI((String)path, (boolean)true), this.resourceSet);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (resource == null) continue;
            ArrayList list = new ArrayList();
            for (Object object : resource.getContents()) {
                if (!(object instanceof EPackage)) continue;
                list.addAll(AtlSourceManager.getAllPackages((EPackage)object));
            }
            this.metamodelLocations.put(name, path);
            this.metamodelsPackages.put(name, list);
        }
        List libraries = AtlSourceManager.getTaggedInformations(text.getBytes(), LIB_TAG);
        for (String line : libraries) {
            if (line.split("=").length != 2) continue;
            String name = line.split("=")[0].trim();
            String library = line.split("=")[1].trim();
            if (library == null || library.length() <= 0) continue;
            library = library.trim();
            this.libraryLocations.put(name, library);
        }
        try {
            this.model = AtlParser.getDefault().parse(new ByteArrayInputStream(text.getBytes()));
        }
        catch (ATLCoreException iterator) {
            // empty catch block
        }
        if (this.model != null) {
            EList librariesList;
            if (this.model.eClass().getName().equals("Module")) {
                EList outModelsList;
                this.atlFileType = 1;
                this.isRefining = (Boolean)AtlSourceManager.eGet(this.model, "isRefining");
                EList inModelsList = (EList)AtlSourceManager.eGet(this.model, "inModels");
                if (inModelsList != null) {
                    for (EObject me : inModelsList) {
                        EObject mm = (EObject)AtlSourceManager.eGet(me, "metamodel");
                        this.inputModels.put(AtlSourceManager.eGet(me, "name"), AtlSourceManager.eGet(mm, "name"));
                    }
                }
                if ((outModelsList = (EList)AtlSourceManager.eGet(this.model, "outModels")) != null) {
                    for (EObject me : outModelsList) {
                        EObject mm = (EObject)AtlSourceManager.eGet(me, "metamodel");
                        this.outputModels.put(AtlSourceManager.eGet(me, "name"), AtlSourceManager.eGet(mm, "name"));
                    }
                }
            } else if (this.model.eClass().getName().equals("Query")) {
                this.atlFileType = 3;
                TreeIterator iterator = this.model.eResource().getAllContents();
                while (iterator.hasNext()) {
                    EObject eo = (EObject)iterator.next();
                    if (!eo.eClass().getName().equals("OclModel")) continue;
                    String metamodelName = (String)AtlSourceManager.eGet(eo, "name");
                    this.inputModels.put("IN", metamodelName);
                    break;
                }
            } else if (this.model.eClass().getName().equals("Library")) {
                this.atlFileType = 4;
            }
            if ((librariesList = (EList)AtlSourceManager.eGet(this.model, "libraries")) != null) {
                for (EObject lib : librariesList) {
                    this.librariesImports.add(AtlSourceManager.eGet(lib, "name"));
                }
            }
        }
        this.initialized = true;
    }

    private static List getAllPackages(EPackage pack) {
        ArrayList<EPackage> res = new ArrayList<EPackage>();
        res.add(pack);
        for (EPackage subPackage : pack.getESubpackages()) {
            res.addAll(AtlSourceManager.getAllPackages(subPackage));
        }
        return res;
    }

    public String getAtlCompiler() {
        return this.atlCompiler;
    }

    public Map getMetamodelLocations() {
        return this.metamodelLocations;
    }

    public Map getLibraryLocations() {
        return this.libraryLocations;
    }

    public boolean initialized() {
        return this.initialized;
    }

    public static List getTaggedInformations(byte[] buffer, String tag) {
        List res = new ArrayList();
        try {
            int length = buffer.length;
            BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(buffer, 0, length)));
            res = AtlSourceManager.getTaggedInformations(reader, tag);
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res;
    }

    public static List getTaggedInformations(BufferedReader reader, String tag) throws IOException {
        ArrayList<String> res = new ArrayList<String>();
        while (reader.ready()) {
            String line = reader.readLine();
            if (line == null || line.startsWith("library") || line.startsWith("module") || line.startsWith("query")) break;
            if (!line.trim().startsWith("-- @" + tag)) continue;
            line = line.replaceFirst("^\\p{Space}*--\\p{Space}*@" + tag + "\\p{Space}+([^\\p{Space}]*)\\p{Space}*$", "$1");
            res.add(line);
        }
        return res;
    }

    public static String getCompilerName(List compilers) {
        if (compilers.isEmpty()) {
            return "atl2006";
        }
        return compilers.get(0).toString();
    }

    private static Resource load(URI modelURI, ResourceSet resourceSet) throws IOException {
        Resource.Factory.Registry reg;
        Object resourceFactory;
        String fileExtension = modelURI.fileExtension();
        if (fileExtension == null || fileExtension.length() == 0) {
            fileExtension = "*";
        }
        if ((resourceFactory = (reg = Resource.Factory.Registry.INSTANCE).getExtensionToFactoryMap().get(fileExtension)) != null) {
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension, resourceFactory);
        } else {
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension, new XMIResourceFactoryImpl());
        }
        Resource modelResource = resourceSet.createResource(modelURI);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", System.getProperty("file.encoding"));
        modelResource.load(options);
        return modelResource;
    }

    private static Object eGet(EObject self, String featureName) {
        EStructuralFeature feature;
        if (self != null && (feature = self.eClass().getEStructuralFeature(featureName)) != null) {
            return self.eGet(feature);
        }
        return null;
    }
}

