/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.form;

import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractMasterForm {
    private final FormToolkit _toolkit;
    private ISelectionChangedListener _listener;
    private ToolBarManager _toolBarManager;

    protected AbstractMasterForm(FormToolkit toolkit) {
        this._toolkit = toolkit;
    }

    public final void initialize(ISelectionChangedListener listener) {
        this._listener = listener;
        this.doInitialize();
    }

    protected void doInitialize() {
    }

    public abstract Control createClientArea(Composite var1);

    public final void createHead(Form form) {
        Composite head = form.getHead();
        Composite container = this.getToolkit().createComposite(head);
        container.setLayout((Layout)new RowLayout());
        this.contributeToHeadArea(this.getToolkit(), container);
        this._toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = this._toolBarManager.createControl(container);
        toolbar.setBackground(form.getHead().getBackground());
        toolbar.setForeground(form.getHead().getForeground());
        container.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AbstractMasterForm.this._toolBarManager != null) {
                    AbstractMasterForm.this._toolBarManager.dispose();
                    AbstractMasterForm.this._toolBarManager = null;
                }
            }
        });
        form.setHeadClient((Control)container);
    }

    protected void contributeToHeadArea(FormToolkit toolkit, Composite container) {
    }

    public final void contributeActions(IToolBarManager formManager) {
        this.contributeActions(formManager, (IToolBarManager)this._toolBarManager);
    }

    protected void contributeActions(IToolBarManager formManager, IToolBarManager localManager) {
    }

    public void dispose() {
    }

    protected final FormToolkit getToolkit() {
        return this._toolkit;
    }

    protected final ISelectionChangedListener getListener() {
        return this._listener;
    }
}

