/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.core.commands;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.internal.l10n.DiagramCoreMessages;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;

public class UngroupCommand
extends AbstractTransactionalCommand {
    private Node group;

    public UngroupCommand(TransactionalEditingDomain editingDomain, Node groupView) {
        this(editingDomain, groupView, null);
    }

    public UngroupCommand(TransactionalEditingDomain editingDomain, Node group, Map options) {
        super(editingDomain, DiagramCoreMessages.UngroupCommand_Label, options, UngroupCommand.getWorkspaceFiles((EObject)group));
        this.group = group;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        this.translateChildrenLocations();
        View parentView = (View)this.getGroup().eContainer();
        if (parentView != null) {
            parentView.getPersistedChildren().addAll((Collection)this.getGroup().getPersistedChildren());
        }
        DestroyElementCommand.destroy((EObject)this.getGroup());
        return CommandResult.newOKCommandResult();
    }

    protected void translateChildrenLocations() {
        Location groupLocation = (Location)this.getGroup().getLayoutConstraint();
        for (Object child : this.getGroup().getChildren()) {
            LayoutConstraint layoutConstraint;
            if (!(child instanceof Node) || !((layoutConstraint = ((Node)child).getLayoutConstraint()) instanceof Location)) continue;
            Location location = (Location)layoutConstraint;
            location.setX(location.getX() + groupLocation.getX());
            location.setY(location.getY() + groupLocation.getY());
        }
    }

    protected Node getGroup() {
        return this.group;
    }
}

