/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.eclemma.core.launching.ICoverageLauncher;
import org.eclipse.eclemma.internal.core.DefaultScopeFilter;
import org.eclipse.eclemma.internal.core.EclEmmaCorePlugin;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScopeUtils {
    private ScopeUtils() {
    }

    public static Set<IPackageFragmentRoot> readScope(Collection<?> ids) {
        HashSet<IPackageFragmentRoot> scope = new HashSet<IPackageFragmentRoot>();
        for (Object handle : ids) {
            IJavaElement element = JavaCore.create((String)((String)handle));
            if (!(element instanceof IPackageFragmentRoot)) continue;
            scope.add((IPackageFragmentRoot)element);
        }
        return scope;
    }

    public static List<String> writeScope(Set<IPackageFragmentRoot> scope) {
        ArrayList<String> ids = new ArrayList<String>();
        for (IPackageFragmentRoot root : scope) {
            ids.add(root.getHandleIdentifier());
        }
        return ids;
    }

    public static Set<IPackageFragmentRoot> getOverallScope(ILaunchConfiguration configuration) throws CoreException {
        ICoverageLauncher launcher = (ICoverageLauncher)configuration.getType().getDelegates(Collections.singleton("coverage"))[0].getDelegate();
        return launcher.getOverallScope(configuration);
    }

    public static Set<IPackageFragmentRoot> getConfiguredScope(ILaunchConfiguration configuration) throws CoreException {
        Set<IPackageFragmentRoot> all = ScopeUtils.getOverallScope(configuration);
        List selection = configuration.getAttribute("org.eclipse.eclemma.core.SCOPE_IDS", null);
        if (selection == null) {
            DefaultScopeFilter filter = new DefaultScopeFilter(EclEmmaCorePlugin.getInstance().getPreferences());
            return filter.filter(all, configuration);
        }
        all.retainAll(ScopeUtils.readScope(selection));
        return all;
    }

    public static Set<IPackageFragmentRoot> getWorkspaceScope() throws JavaModelException {
        HashSet<IPackageFragmentRoot> scope = new HashSet<IPackageFragmentRoot>();
        IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        IJavaProject[] iJavaProjectArray = model.getJavaProjects();
        int n = iJavaProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject p = iJavaProjectArray[n2];
            scope.addAll(Arrays.asList(p.getPackageFragmentRoots()));
            ++n2;
        }
        return ScopeUtils.filterJREEntries(scope);
    }

    public static Set<IPackageFragmentRoot> filterJREEntries(Collection<IPackageFragmentRoot> scope) throws JavaModelException {
        HashSet<IPackageFragmentRoot> filtered = new HashSet<IPackageFragmentRoot>();
        block4: for (IPackageFragmentRoot root : scope) {
            IClasspathEntry entry = root.getRawClasspathEntry();
            switch (entry.getEntryKind()) {
                case 1: 
                case 3: 
                case 4: {
                    filtered.add(root);
                    break;
                }
                case 5: {
                    IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)root.getJavaProject());
                    if (container == null || container.getKind() != 1) continue block4;
                    filtered.add(root);
                }
            }
        }
        return filtered;
    }
}

