/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.parser.definitions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.tcl.definitions.Argument;
import org.eclipse.dltk.tcl.definitions.Command;
import org.eclipse.dltk.tcl.definitions.ComplexArgument;
import org.eclipse.dltk.tcl.definitions.Constant;
import org.eclipse.dltk.tcl.definitions.DefinitionsFactory;
import org.eclipse.dltk.tcl.definitions.Group;
import org.eclipse.dltk.tcl.definitions.Switch;
import org.eclipse.dltk.tcl.definitions.TypedArgument;
import org.eclipse.emf.common.util.EList;

public class DefinitionUtils {
    public static final String GENERATE_VARIANTS = "reduce_to_less";
    public static final String SWITCH_COUNT = "switch_count";

    private static boolean isSet(Map<String, Object> options, String key) {
        if (options == null) {
            return false;
        }
        if (!options.containsKey(key)) {
            return false;
        }
        Object object = options.get(key);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    private static int getInt(Map<String, Object> options, String key, int def) {
        if (options == null) {
            return def;
        }
        if (!options.containsKey(key)) {
            return def;
        }
        Object object = options.get(key);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return def;
    }

    public static List<List<Argument>> reduceSwitches(List<Argument> list, Map<String, Object> options) {
        ArrayList<List<Argument>> argumentsList = new ArrayList<List<Argument>>();
        for (Argument argument : list) {
            List<Argument> args = DefinitionUtils.reduceSwitchesArgument(argument, options);
            ArrayList newArgumentsList = new ArrayList();
            if (argumentsList.size() == 0) {
                for (Argument arg : args) {
                    ArrayList<Argument> arrayList = new ArrayList<Argument>();
                    arrayList.add(arg);
                    newArgumentsList.add(arrayList);
                }
            } else {
                for (Argument nextArgument : args) {
                    for (List list2 : argumentsList) {
                        ArrayList<Argument> nal = new ArrayList<Argument>();
                        for (Argument argument2 : list2) {
                            nal.add(DefinitionUtils.copyArgument(argument2));
                        }
                        nal.add(nextArgument);
                        newArgumentsList.add(nal);
                    }
                }
            }
            argumentsList = newArgumentsList;
        }
        return argumentsList;
    }

    public static Command[] reduceSwitches(Command command) {
        return DefinitionUtils.reduceSwitches(command, null);
    }

    public static Command[] reduceSwitches(Command command, Map<String, Object> options) {
        ArrayList<Command> commands = new ArrayList<Command>();
        EList<Argument> arguments = command.getArguments();
        List<List<Argument>> removeSwitches = DefinitionUtils.reduceSwitches(arguments, options);
        for (List<Argument> list : removeSwitches) {
            Command newCommand = DefinitionsFactory.eINSTANCE.createCommand();
            newCommand.setDeprecated(command.getDeprecated());
            newCommand.setName(command.getName());
            newCommand.setVersion(command.getVersion());
            newCommand.getArguments().addAll(list);
            commands.add(newCommand);
        }
        return commands.toArray(new Command[commands.size()]);
    }

    /*
     * WARNING - void declaration
     */
    private static List<Argument> reduceSwitchesArgument(Argument argument, Map<String, Object> options) {
        ArrayList<Argument> results = new ArrayList<Argument>();
        if (argument instanceof Switch) {
            Switch sw = (Switch)argument;
            if (DefinitionUtils.isSet(options, GENERATE_VARIANTS) && sw.getUpperBound() == -1) {
                sw = (Switch)DefinitionUtils.copyArgument(sw);
                sw.setUpperBound(sw.getLowerBound() + DefinitionUtils.getInt(options, SWITCH_COUNT, 1));
            }
            if (sw.getUpperBound() != -1) {
                void var5_15;
                Object list;
                void var5_13;
                List<List<Group>> switchVariants = new ArrayList<List<Group>>();
                boolean bl = false;
                while (var5_13 < sw.getLowerBound()) {
                    list = DefinitionUtils.processGroups(sw, 1, 1, options);
                    switchVariants = DefinitionUtils.updateVariants(switchVariants, list, false);
                    ++var5_13;
                }
                int n = sw.getLowerBound();
                while (var5_15 < sw.getUpperBound()) {
                    list = DefinitionUtils.processGroups(sw, 0, 1, options);
                    switchVariants = DefinitionUtils.updateVariants(switchVariants, (List<Group>)list, DefinitionUtils.isSet(options, GENERATE_VARIANTS));
                    ++var5_15;
                }
                if (switchVariants.size() > 1) {
                    for (List list2 : switchVariants) {
                        DefinitionUtils.addResult(results, list2);
                    }
                } else {
                    List<Group> list3 = switchVariants.get(0);
                    if (list3.size() == 1) {
                        results.add(list3.get(0));
                    } else {
                        DefinitionUtils.addResult(results, list3);
                    }
                }
            } else {
                EList<Group> groups = sw.getGroups();
                Switch switch_ = DefinitionUtils.copySwitch(sw);
                for (Group group : groups) {
                    List<Argument> variants = DefinitionUtils.reduceSwitchesArgument(group, options);
                    for (Argument variant : variants) {
                        switch_.getGroups().add((Object)((Group)variant));
                    }
                }
                results.add(switch_);
            }
        } else if (argument instanceof Group) {
            Group g = (Group)argument;
            List<List<Argument>> removeSwitches = DefinitionUtils.reduceSwitches(g.getArguments(), options);
            if (removeSwitches.size() > 0) {
                for (List<Argument> list : removeSwitches) {
                    Group ng = DefinitionUtils.copyGroup(g);
                    ng.getArguments().addAll(list);
                    results.add(ng);
                }
            } else {
                Group group = DefinitionUtils.copyGroup(g);
                results.add(group);
            }
        } else if (argument instanceof ComplexArgument) {
            ComplexArgument c = (ComplexArgument)argument;
            List<List<Argument>> removeSwitches = DefinitionUtils.reduceSwitches(c.getArguments(), options);
            if (removeSwitches.size() > 0) {
                for (List<Argument> list : removeSwitches) {
                    ComplexArgument ng = DefinitionUtils.copyComplexArgument(c);
                    ng.getArguments().addAll(list);
                    results.add(ng);
                }
            } else {
                ComplexArgument complexArgument = DefinitionUtils.copyComplexArgument(c);
                results.add(complexArgument);
            }
        } else if (argument instanceof Constant) {
            Constant nc = DefinitionUtils.copyConstant((Constant)argument);
            results.add(nc);
        } else if (argument instanceof TypedArgument) {
            TypedArgument tc = DefinitionUtils.copyTypedArgument((TypedArgument)argument);
            results.add(tc);
        }
        return results;
    }

    public static Switch copySwitch(Switch sw) {
        Switch nsw = DefinitionsFactory.eINSTANCE.createSwitch();
        nsw.setLowerBound(sw.getLowerBound());
        nsw.setUpperBound(sw.getUpperBound());
        nsw.setName(sw.getName());
        return nsw;
    }

    public static TypedArgument copyTypedArgument(TypedArgument t) {
        TypedArgument nt = DefinitionsFactory.eINSTANCE.createTypedArgument();
        nt.setLowerBound(t.getLowerBound());
        nt.setUpperBound(t.getUpperBound());
        nt.setType(t.getType());
        nt.setName(t.getName());
        return nt;
    }

    public static Constant copyConstant(Constant c) {
        Constant nc = DefinitionsFactory.eINSTANCE.createConstant();
        nc.setLowerBound(c.getLowerBound());
        nc.setUpperBound(c.getUpperBound());
        nc.setName(c.getName());
        return nc;
    }

    public static ComplexArgument copyComplexArgument(ComplexArgument c) {
        ComplexArgument nc = DefinitionsFactory.eINSTANCE.createComplexArgument();
        nc.setLowerBound(c.getLowerBound());
        nc.setUpperBound(c.getUpperBound());
        nc.setName(c.getName());
        return nc;
    }

    public static Group copyGroup(Group g) {
        Group ng = DefinitionsFactory.eINSTANCE.createGroup();
        ng.setLowerBound(g.getLowerBound());
        ng.setUpperBound(g.getUpperBound());
        ng.setConstant(g.getConstant());
        ng.setName(g.getName());
        return ng;
    }

    public static void addResult(List<Argument> results, List<Group> list) {
        Group ng = DefinitionsFactory.eINSTANCE.createGroup();
        ng.setLowerBound(1);
        ng.setUpperBound(1);
        ng.getArguments().addAll(list);
        results.add(ng);
    }

    private static List<List<Group>> updateVariants(List<List<Group>> switchVariants, List<Group> list, boolean addPrevious) {
        ArrayList<List<Group>> resultList = new ArrayList<List<Group>>();
        if (switchVariants.size() == 0) {
            for (Group g : list) {
                ArrayList<Group> gg = new ArrayList<Group>();
                gg.add(g);
                resultList.add(gg);
            }
        } else {
            for (Group g : list) {
                for (List<Group> nle : switchVariants) {
                    Argument rg = DefinitionUtils.copyArgument(g);
                    ArrayList<Group> nl = new ArrayList<Group>();
                    for (Group nlee : nle) {
                        Argument nleer = DefinitionUtils.copyArgument(nlee);
                        nl.add((Group)nleer);
                    }
                    nl.add((Group)rg);
                    resultList.add(nl);
                }
            }
        }
        if (addPrevious) {
            resultList.addAll(switchVariants);
        }
        return resultList;
    }

    public static Argument copyArgument(Argument a) {
        if (a instanceof Constant) {
            return DefinitionUtils.copyConstant((Constant)a);
        }
        if (a instanceof TypedArgument) {
            return DefinitionUtils.copyTypedArgument((TypedArgument)a);
        }
        if (a instanceof Switch) {
            Switch s = (Switch)a;
            Switch ns = DefinitionUtils.copySwitch(s);
            EList<Group> groups = s.getGroups();
            for (Group group : groups) {
                ns.getGroups().add((Object)((Group)DefinitionUtils.copyArgument(group)));
            }
            return ns;
        }
        if (a instanceof Group) {
            Group g = (Group)a;
            Group ng = DefinitionUtils.copyGroup(g);
            EList<Argument> arguments = g.getArguments();
            for (Argument argument : arguments) {
                ng.getArguments().add((Object)DefinitionUtils.copyArgument(argument));
            }
            return ng;
        }
        if (a instanceof ComplexArgument) {
            ComplexArgument g = (ComplexArgument)a;
            ComplexArgument ng = DefinitionUtils.copyComplexArgument(g);
            EList<Argument> arguments = g.getArguments();
            for (Argument argument : arguments) {
                ng.getArguments().add((Object)DefinitionUtils.copyArgument(argument));
            }
            return ng;
        }
        return null;
    }

    public static boolean equalsArgumentIgnoreName(Argument a1, Argument a2) {
        return DefinitionUtils.equalsArgument(a1, a2, true);
    }

    public static boolean equalsArgument(Argument a1, Argument a2, boolean ignoreName) {
        block17: {
            block20: {
                String const2;
                block19: {
                    block18: {
                        block16: {
                            String value2;
                            if (a1.getClass() != a2.getClass()) {
                                return false;
                            }
                            if (a1 == a2) {
                                return true;
                            }
                            if (a1.getLowerBound() != a2.getLowerBound() || a1.getUpperBound() != a2.getUpperBound()) {
                                return false;
                            }
                            if (!(ignoreName || a1.getName() == a2.getName() && a1.getName() != null && a1.getName().equals(a2.getName()))) {
                                return false;
                            }
                            if (!(a1 instanceof Constant)) break block16;
                            String value1 = ((Constant)a1).getName();
                            if (value1 != (value2 = ((Constant)a2).getName()) || value1 == null || !value1.equals(value2)) {
                                return false;
                            }
                            break block17;
                        }
                        if (!(a1 instanceof TypedArgument)) break block18;
                        if (((TypedArgument)a1).getType().getValue() != ((TypedArgument)a2).getType().getValue()) {
                            return false;
                        }
                        break block17;
                    }
                    if (!(a1 instanceof Switch)) break block19;
                    if (((Switch)a1).getGroups().size() != ((Switch)a2).getGroups().size()) {
                        return false;
                    }
                    int i = 0;
                    while (i < ((Switch)a1).getGroups().size()) {
                        if (!DefinitionUtils.equalsArgument((Argument)((Switch)a1).getGroups().get(i), (Argument)((Switch)a2).getGroups().get(i), ignoreName)) {
                            return false;
                        }
                        ++i;
                    }
                    break block17;
                }
                if (!(a1 instanceof Group)) break block20;
                String const1 = ((Group)a1).getConstant();
                if (const1 != (const2 = ((Group)a2).getConstant()) && const1 != null && !const1.equals(const2)) {
                    return false;
                }
                if (((Group)a1).getArguments().size() != ((Group)a2).getArguments().size()) {
                    return false;
                }
                int i = 0;
                while (i < ((Group)a1).getArguments().size()) {
                    if (!DefinitionUtils.equalsArgument((Argument)((Group)a1).getArguments().get(i), (Argument)((Group)a2).getArguments().get(i), ignoreName)) {
                        return false;
                    }
                    ++i;
                }
                break block17;
            }
            if (!(a1 instanceof ComplexArgument)) break block17;
            if (((ComplexArgument)a1).getArguments().size() != ((ComplexArgument)a2).getArguments().size()) {
                return false;
            }
            int i = 0;
            while (i < ((ComplexArgument)a1).getArguments().size()) {
                if (!DefinitionUtils.equalsArgument((Argument)((ComplexArgument)a1).getArguments().get(i), (Argument)((ComplexArgument)a2).getArguments().get(i), ignoreName)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static Command copyCommand(Command c) {
        Command nc = DefinitionsFactory.eINSTANCE.createCommand();
        nc.setName(c.getName());
        nc.setDeprecated(c.getDeprecated());
        nc.setVersion(c.getVersion());
        for (Argument a : c.getArguments()) {
            nc.getArguments().add((Object)DefinitionUtils.copyArgument(a));
        }
        return nc;
    }

    private static List<Group> processGroups(Switch sw, int l, int u, Map<String, Object> options) {
        EList<Group> groups = sw.getGroups();
        ArrayList<Group> results = new ArrayList<Group>();
        for (Group group : groups) {
            List<Argument> variants = DefinitionUtils.reduceSwitchesArgument(group, options);
            for (Argument variant : variants) {
                Group ng = DefinitionsFactory.eINSTANCE.createGroup();
                ng.setLowerBound(l);
                ng.setUpperBound(u);
                ng.getArguments().add((Object)variant);
                results.add(ng);
            }
        }
        return results;
    }

    public static String convertToString(Command command) {
        return DefinitionUtils.convertToString(command, false);
    }

    public static String convertToString(Command command, boolean clean) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(command.getName());
        for (Argument arg : command.getArguments()) {
            buffer.append(' ');
            buffer.append(DefinitionUtils.convertToString(arg, clean));
        }
        return buffer.toString();
    }

    private static String convertToString(Argument arg, boolean clean) {
        if (arg instanceof Constant) {
            return String.valueOf(((Constant)arg).getName()) + DefinitionUtils.boundsToString(arg);
        }
        if (arg instanceof TypedArgument) {
            TypedArgument typed = (TypedArgument)arg;
            if (!clean) {
                return String.valueOf(typed.getName()) + DefinitionUtils.boundsToString(arg);
            }
            switch (typed.getType().getValue()) {
                case 5: {
                    return "{unk_cmd}";
                }
                case 4: {
                    return "{$i>0}";
                }
                case 2: {
                    return "1";
                }
                case 3: {
                    return "1";
                }
                case 1: {
                    return "0";
                }
                case 11: {
                    return "true";
                }
                case 6: {
                    return "var";
                }
                case 8: {
                    return "#1";
                }
            }
            return typed.getName();
        }
        if (arg instanceof Group) {
            Group group = (Group)arg;
            EList<Argument> arguments = group.getArguments();
            StringBuffer b = new StringBuffer();
            if (group.getArguments().size() > 0) {
                String constant;
                if (!clean) {
                    b.append('(');
                }
                if ((constant = group.getConstant()) != null) {
                    b.append(String.valueOf(constant) + " ");
                }
                boolean first = true;
                for (Argument argument : arguments) {
                    if (!first) {
                        b.append(" ");
                    } else {
                        first = false;
                    }
                    b.append(DefinitionUtils.convertToString(argument, clean));
                }
                if (!clean) {
                    b.append(')');
                }
                b.append(DefinitionUtils.boundsToString(arg));
            } else {
                String constant = group.getConstant();
                if (constant != null) {
                    b.append(constant);
                }
            }
            return b.toString();
        }
        if (arg instanceof ComplexArgument) {
            EList<Argument> arguments = ((ComplexArgument)arg).getArguments();
            StringBuffer b = new StringBuffer();
            if (!clean) {
                b.append('^');
            } else {
                b.append('{');
            }
            boolean first = true;
            for (Argument argument : arguments) {
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(DefinitionUtils.convertToString(argument, clean));
            }
            if (!clean) {
                b.append('^');
            } else {
                b.append('}');
            }
            b.append(DefinitionUtils.boundsToString(arg));
            return b.toString();
        }
        if (arg instanceof Switch) {
            if (clean) {
                throw new IllegalArgumentException();
            }
            EList<Group> arguments = ((Switch)arg).getGroups();
            StringBuffer b = new StringBuffer();
            b.append("{");
            boolean first = true;
            for (Argument argument : arguments) {
                if (!first) {
                    b.append("|");
                } else {
                    first = false;
                }
                b.append(DefinitionUtils.convertToString(argument, clean));
            }
            b.append("}");
            b.append(DefinitionUtils.boundsToString(arg));
            return b.toString();
        }
        return arg.toString();
    }

    private static String boundsToString(Argument arg) {
        return "";
    }

    public static Constant extractGroupPseudoConstant(Group group) {
        String cval = group.getConstant();
        if (cval != null && cval.length() > 0) {
            Constant constant = DefinitionsFactory.eINSTANCE.createConstant();
            constant.setName(cval);
            constant.setLowerBound(1);
            constant.setUpperBound(1);
            constant.setStrictMatch(true);
            return constant;
        }
        return null;
    }

    public static Argument minimizeBounds(Argument argument) {
        Argument minArgument = DefinitionUtils.copyArgument(argument);
        minArgument.setLowerBound(1);
        minArgument.setUpperBound(1);
        return minArgument;
    }

    public static List<Argument> minimizeBounds(List<Argument> arguments) {
        ArrayList<Argument> minArguments = new ArrayList<Argument>();
        for (Argument argument : arguments) {
            minArguments.add(DefinitionUtils.minimizeBounds(argument));
        }
        return minArguments;
    }

    public static boolean isOptions(Switch sw) {
        return sw.getLowerBound() == 0 && (sw.getUpperBound() == -1 || sw.getUpperBound() == sw.getGroups().size());
    }

    public static boolean isMode(Switch sw) {
        for (Group group : sw.getGroups()) {
            if (group.getArguments().size() == 0) continue;
            return false;
        }
        return true;
    }
}

