/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.update;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.datatools.modelbase.sql.datatypes.CharacterStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.XMLDataType;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionBody;
import org.eclipse.datatools.modelbase.sql.query.QueryUpdateStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.UpdateAssignmentExpression;
import org.eclipse.datatools.modelbase.sql.query.UpdateSource;
import org.eclipse.datatools.modelbase.sql.query.UpdateSourceExprList;
import org.eclipse.datatools.modelbase.sql.query.UpdateSourceQuery;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLBuilderConstants;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.model.UpdateHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.VendorHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.util.LabelValuePair;
import org.eclipse.datatools.sqltools.sqlbuilder.util.StringUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.util.ViewUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.util.WindowUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.util.WorkbenchUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.views.ComboBoxCellEditor;
import org.eclipse.datatools.sqltools.sqlbuilder.views.DynamicComboBoxCellEditor;
import org.eclipse.datatools.sqltools.sqlbuilder.views.EditComboBoxCellEditor;
import org.eclipse.datatools.sqltools.sqlbuilder.views.GridContentProvider;
import org.eclipse.datatools.sqltools.sqlbuilder.views.Modifier;
import org.eclipse.datatools.sqltools.sqlbuilder.views.TableNavigator;
import org.eclipse.datatools.sqltools.sqlbuilder.views.update.UpdateTreeElement;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class UpdateTreeViewer
extends TableViewer {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    protected SQLDomainModel domainModel;
    protected UpdateTreeLabelProvider updateTreeLabelProvider;
    protected UpdateTreeContentProvider updateTreeContentProvider;
    final Table table;
    protected TableColumn c1;
    protected TableColumn c2;
    protected DynamicComboBoxCellEditor expressionCellEditor;
    protected ComboBoxCellEditor queryCellEditor;
    protected TableNavigator navigator;
    protected Vector existingSelects;

    public UpdateTreeViewer(SQLDomainModel domainModel, Composite parent) {
        super(parent, 65538);
        this.domainModel = domainModel;
        this.table = this.getTable();
        Table tbl = this.getTable();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)tbl, "org.eclipse.datatools.sqltools.sqlbuilder.sqdu0020");
        this.navigator = new TableNavigator(tbl, (StructuredViewer)this);
        int i = 0;
        while (i < 2) {
            TableColumn column = new TableColumn(tbl, 0, i);
            column.setText(i == 0 ? Messages._UI_COLUMN_UPDATE_COLUMN : Messages._UI_COLUMN_UPDATE_EXPRESSION);
            ++i;
        }
        String[] columnProperties = new String[]{(String)SQLBuilderConstants.P_STATEMENT_COLUMN, (String)SQLBuilderConstants.P_EXPRESSION};
        this.setColumnProperties(columnProperties);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, this.getMinExpressionWidth(), true));
        tbl.setLayout((Layout)layout);
        tbl.setLinesVisible(true);
        tbl.setHeaderVisible(true);
        tbl.setLayoutData((Object)ViewUtility.createFill());
        this.setCellModifier(new Modifier());
        CellEditor[] editors = new CellEditor[2];
        this.setCellEditors(editors);
        this.updateTreeContentProvider = new UpdateTreeContentProvider(domainModel);
        this.setContentProvider((IContentProvider)this.updateTreeContentProvider);
        this.updateTreeLabelProvider = new UpdateTreeLabelProvider();
        this.setLabelProvider((IBaseLabelProvider)this.updateTreeLabelProvider);
        this.addSelectionChangedListener(new SelectionChangedListener());
    }

    protected int getMinExpressionWidth() {
        GC gc = new GC((Drawable)this.table);
        int len = gc.textExtent((String)SQLBuilderConstants.P_ADD_FULLSELECT).x;
        gc.dispose();
        return len += gc.textExtent((String)"M").x;
    }

    public void setCellEditors(CellEditor[] editors) {
        super.setCellEditors(editors);
        this.navigator.moveCellEditorsAbove(editors);
    }

    public void refresh() {
        if (this.getTable().getItemCount() == 0) {
            this.navigator.setVisible(false);
        } else {
            this.navigator.setVisible(true);
            this.navigator.refresh();
            this.navigator.setSelection(0, 0);
        }
        super.refresh();
    }

    protected void setExpanded(Item node, boolean expand) {
    }

    protected boolean getExpanded(Item item) {
        return true;
    }

    public void setEnabled(boolean enable) {
        if (enable) {
            this.table.setBackground(Display.getCurrent().getSystemColor(1));
        } else {
            Composite control = this.table.getParent().getParent();
            this.table.setBackground(control.getBackground());
        }
    }

    private Vector getExistingQueries() {
        if (this.existingSelects == null) {
            this.existingSelects = new Vector();
            IProject project = this.domainModel.getProject();
            List stmtsList = WorkbenchUtility.getSelectStatementsFromProject(project, this.domainModel);
            for (IFile file : stmtsList) {
                String name = file.getName();
                String extension = file.getFileExtension();
                name = name.substring(0, name.indexOf(extension) - 1);
                this.existingSelects.add(new LabelValuePair(name, file));
            }
        }
        return this.existingSelects;
    }

    class SelectionChangedListener
    implements ISelectionChangedListener {
        SelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object selection = WindowUtility.getSelection(event.getSelection());
            if (selection != null) {
                CellEditor[] cellEditorArray = new CellEditor[2];
                cellEditorArray[1] = this.getCellEditor(selection, 1);
                CellEditor[] cellEditors = cellEditorArray;
                UpdateTreeViewer.this.setCellEditors(cellEditors);
            }
            if (UpdateTreeViewer.this.getTable().getItemCount() <= 0) {
                UpdateTreeViewer.this.navigator.setVisible(false);
            } else {
                UpdateTreeViewer.this.navigator.setVisible(true);
            }
        }

        public ComboBoxCellEditor getQueryComboBoxCellEditor() {
            Vector<LabelValuePair> contentsHolder = new Vector<LabelValuePair>();
            contentsHolder.addAll(UpdateTreeViewer.this.getExistingQueries());
            contentsHolder.add(new LabelValuePair(SQLBuilderConstants.P_ADD_SELECT, SQLBuilderConstants.P_ADD_SELECT));
            if (VendorHelper.isFullSelectSupported(UpdateTreeViewer.this.domainModel.getDatabase())) {
                contentsHolder.add(new LabelValuePair(SQLBuilderConstants.P_ADD_FULLSELECT, SQLBuilderConstants.P_ADD_FULLSELECT));
            }
            LabelValuePair[] comboContents = new LabelValuePair[contentsHolder.size()];
            Iterator contentsIterator = contentsHolder.iterator();
            int counter = 0;
            while (contentsIterator.hasNext()) {
                comboContents[counter] = (LabelValuePair)contentsIterator.next();
                ++counter;
            }
            UpdateTreeViewer.this.queryCellEditor = new ComboBoxCellEditor((Composite)UpdateTreeViewer.this.getTable(), comboContents);
            UpdateTreeViewer.this.queryCellEditor.getControl().moveAbove(null);
            return UpdateTreeViewer.this.queryCellEditor;
        }

        public DynamicComboBoxCellEditor getExprComboBoxCellEditor(boolean isExpr) {
            if (!isExpr) {
                LabelValuePair[] comboItems = new LabelValuePair[]{new LabelValuePair(SQLBuilderConstants.P_BUILD_EXPRESSION, SQLBuilderConstants.P_BUILD_EXPRESSION)};
                UpdateTreeViewer.this.expressionCellEditor = new DynamicComboBoxCellEditor((Composite)UpdateTreeViewer.this.getTable(), comboItems, this);
            } else {
                LabelValuePair[] comboItems = new LabelValuePair[]{new LabelValuePair(SQLBuilderConstants.P_EDIT_EXPRESSION, SQLBuilderConstants.P_EDIT_EXPRESSION), new LabelValuePair(SQLBuilderConstants.P_REPLACE_EXPRESSION, SQLBuilderConstants.P_REPLACE_EXPRESSION)};
                UpdateTreeViewer.this.expressionCellEditor = new DynamicComboBoxCellEditor((Composite)UpdateTreeViewer.this.getTable(), comboItems, this);
            }
            UpdateTreeViewer.this.expressionCellEditor.getControl().moveAbove(null);
            return UpdateTreeViewer.this.expressionCellEditor;
        }

        public DynamicComboBoxCellEditor getExprComboBoxCellEditor(QueryValueExpression expr) {
            if (expr == null) {
                LabelValuePair[] comboItems = new LabelValuePair[]{new LabelValuePair(SQLBuilderConstants.P_BUILD_EXPRESSION, SQLBuilderConstants.P_BUILD_EXPRESSION)};
                UpdateTreeViewer.this.expressionCellEditor = new DynamicComboBoxCellEditor((Composite)UpdateTreeViewer.this.getTable(), comboItems, this);
            } else if (expr.getDataType() instanceof XMLDataType || expr.getDataType() instanceof CharacterStringDataType) {
                LabelValuePair[] comboItems = new LabelValuePair[]{new LabelValuePair(SQLBuilderConstants.P_EDIT_EXPRESSION, SQLBuilderConstants.P_EDIT_EXPRESSION), new LabelValuePair(SQLBuilderConstants.P_REPLACE_EXPRESSION, SQLBuilderConstants.P_REPLACE_EXPRESSION), new LabelValuePair(SQLBuilderConstants.P_EDIT_INPUT_VALUE, SQLBuilderConstants.P_EDIT_INPUT_VALUE)};
                UpdateTreeViewer.this.expressionCellEditor = new DynamicComboBoxCellEditor((Composite)UpdateTreeViewer.this.getTable(), comboItems, this);
            } else {
                LabelValuePair[] comboItems = new LabelValuePair[]{new LabelValuePair(SQLBuilderConstants.P_EDIT_EXPRESSION, SQLBuilderConstants.P_EDIT_EXPRESSION), new LabelValuePair(SQLBuilderConstants.P_REPLACE_EXPRESSION, SQLBuilderConstants.P_REPLACE_EXPRESSION)};
                UpdateTreeViewer.this.expressionCellEditor = new DynamicComboBoxCellEditor((Composite)UpdateTreeViewer.this.getTable(), comboItems, this);
            }
            UpdateTreeViewer.this.expressionCellEditor.getControl().moveAbove(null);
            return UpdateTreeViewer.this.expressionCellEditor;
        }

        public CellEditor getCellEditor(Object o, int col) {
            CellEditor result = null;
            if (col == 1) {
                UpdateTreeElement treeElement = (UpdateTreeElement)o;
                if (treeElement.getRDBColumn() == null) {
                    result = this.getQueryComboBoxCellEditor();
                } else if (treeElement.getUpdateSource() instanceof UpdateSourceQuery && treeElement.getRDBColumn() != null && UpdateTreeViewer.this.domainModel.getVendor().isOracle()) {
                    result = null;
                } else {
                    ValueExpressionColumn column;
                    QueryUpdateStatement statement;
                    QueryValueExpression expr;
                    result = treeElement.getUpdateSource() != null ? ((expr = UpdateHelper.getValueForColumn(statement = treeElement.getUpdateStatement(), column = treeElement.getRDBColumn())) != null && !StringUtility.stripTrailingBlanks(expr.toString()).equals("") ? this.getExprComboBoxCellEditor((QueryValueExpression)column) : this.getExprComboBoxCellEditor(false)) : this.getExprComboBoxCellEditor(false);
                    UpdateTreeElement updTE = (UpdateTreeElement)o;
                    ValueExpressionColumn colExpr = updTE.getRDBColumn();
                    ((EditComboBoxCellEditor)result).setNeedQuotes(true);
                    ((EditComboBoxCellEditor)result).setQuotesContext("update");
                    if (colExpr != null) {
                        ((EditComboBoxCellEditor)result).setPairDataType(colExpr.getDataType());
                    }
                }
            }
            return result;
        }
    }

    public class UpdateTreeContentProvider
    extends GridContentProvider {
        public UpdateTreeContentProvider(SQLDomainModel domainModel) {
            super(domainModel.getAdapterFactory());
        }

        public Object[] getElements(Object object) {
            block11: {
                block10: {
                    this.adapterFactory.adapt(object, IStructuredItemContentProvider.class);
                    this.tableElements = new Vector();
                    if (!(object instanceof QueryUpdateStatement)) break block10;
                    QueryUpdateStatement update = (QueryUpdateStatement)object;
                    EList assignExprList = update.getAssignmentClause();
                    if (assignExprList == null) break block11;
                    for (UpdateAssignmentExpression assignExpr : assignExprList) {
                        if (assignExpr == null) continue;
                        this.adapterFactory.adapt((Notifier)assignExpr, IStructuredItemContentProvider.class);
                        UpdateSource updateSource = assignExpr.getUpdateSource();
                        EList colList = assignExpr.getTargetColumnList();
                        if (colList != null && colList.size() == 1) {
                            ValueExpressionColumn column = (ValueExpressionColumn)colList.get(0);
                            if (updateSource instanceof UpdateSourceQuery) {
                                QueryExpressionBody queryExpr = ((UpdateSourceQuery)updateSource).getQueryExpr();
                                this.createNewUpdateListElement(update, updateSource, column, (SQLQueryObject)queryExpr, false);
                                continue;
                            }
                            if (!(updateSource instanceof UpdateSourceExprList)) continue;
                            EList exprList = ((UpdateSourceExprList)updateSource).getValueExprList();
                            QueryValueExpression value = (QueryValueExpression)exprList.get(0);
                            this.createNewUpdateListElement(update, updateSource, column, (SQLQueryObject)value, false);
                            continue;
                        }
                        this.createNewUpdateListElement(update, updateSource, null, null, true);
                    }
                    break block11;
                }
                if (object instanceof UpdateTreeElement) {
                    UpdateAssignmentExpression assignExpr;
                    EList colList;
                    UpdateTreeElement treeElement = (UpdateTreeElement)object;
                    QueryUpdateStatement update = treeElement.getUpdateStatement();
                    UpdateSource updateSource = treeElement.getUpdateSource();
                    if (treeElement.hasChildren() && updateSource != null && (colList = (assignExpr = updateSource.getUpdateAssignmentExpr()).getTargetColumnList()).size() > 1) {
                        Iterator columnListItr = colList.iterator();
                        if (updateSource instanceof UpdateSourceExprList) {
                            EList values = ((UpdateSourceExprList)updateSource).getValueExprList();
                            Iterator valuesItr = values.iterator();
                            while (columnListItr.hasNext()) {
                                ValueExpressionColumn col = (ValueExpressionColumn)columnListItr.next();
                                QueryValueExpression value = (QueryValueExpression)valuesItr.next();
                                this.createNewUpdateListElement(update, updateSource, col, (SQLQueryObject)value, false);
                            }
                        } else if (updateSource instanceof UpdateSourceQuery) {
                            while (columnListItr.hasNext()) {
                                ValueExpressionColumn col = (ValueExpressionColumn)columnListItr.next();
                                this.createNewUpdateListElement(update, updateSource, col, null, false);
                            }
                        }
                    }
                }
            }
            return this.tableElements.toArray();
        }

        private UpdateTreeElement createNewUpdateListElement(QueryUpdateStatement update, UpdateSource updateSource, ValueExpressionColumn col, SQLQueryObject source, boolean hasChildren) {
            UpdateTreeElement newTreeElement = new UpdateTreeElement(update, updateSource, col, source, UpdateTreeViewer.this.domainModel, hasChildren);
            this.tableElements.add(newTreeElement);
            return newTreeElement;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof UpdateTreeElement) {
                return ((UpdateTreeElement)element).hasChildren();
            }
            return false;
        }

        public Object[] getChildren(Object element) {
            return this.getElements(element);
        }
    }

    public class UpdateTreeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object object, int columnIndex) {
            if (object instanceof UpdateTreeElement) {
                UpdateTreeElement element = (UpdateTreeElement)object;
                return element.getColumnText(columnIndex);
            }
            return "";
        }

        public Image getColumnImage(Object object, int columnIndex) {
            return null;
        }
    }
}

