/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts;

import java.util.List;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts.ColumnEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.tools.ConnectionDragCreationTool;

public class ConnectionCreationDragTracker
extends ConnectionDragCreationTool
implements DragTracker {
    private ColumnEditPart editpart;

    public ConnectionCreationDragTracker(ColumnEditPart owner) {
        this.editpart = owner;
    }

    protected boolean handleButtonDown(int button) {
        if (this.isInState(1) && button == 1) {
            this.updateTargetRequest();
            this.updateTargetUnderMouse();
            super.handleButtonDown(button);
            this.handleDrag();
            return true;
        }
        return super.handleButtonDown(button);
    }

    protected boolean handleButtonUp(int button) {
        int toolState = this.getState();
        if (toolState != 4 && toolState == 2) {
            this.performConditionalSelection();
        }
        return super.handleButtonUp(button);
    }

    protected boolean handleDragStarted() {
        this.performConditionalSelection();
        return super.handleDragStarted();
    }

    protected void performConditionalSelection() {
        if (this.getSourceEditPart().getSelected() == 0) {
            this.performSelection();
        }
    }

    protected EditPart getSourceEditPart() {
        return this.editpart;
    }

    protected void performSelection() {
        EditPartViewer viewer = this.getCurrentViewer();
        List selectedObjects = viewer.getSelectedEditParts();
        if (this.getCurrentInput().isControlKeyDown()) {
            if (selectedObjects.contains(this.getSourceEditPart())) {
                viewer.deselect(this.getSourceEditPart());
            } else {
                viewer.appendSelection(this.getSourceEditPart());
            }
        } else if (this.getCurrentInput().isShiftKeyDown()) {
            viewer.appendSelection(this.getSourceEditPart());
        } else {
            viewer.select(this.getSourceEditPart());
        }
    }
}

