/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.internal.switchtolsp;

import org.eclipse.cdt.lsp.editor.EditorConfiguration;
import org.eclipse.cdt.lsp.editor.EditorMetadata;
import org.eclipse.cdt.lsp.editor.EditorOptions;
import org.eclipse.cdt.lsp.internal.messages.LspUiMessages;
import org.eclipse.cdt.lsp.internal.switchtolsp.LinkHelper;
import org.eclipse.cdt.lsp.internal.switchtolsp.Messages;
import org.eclipse.cdt.lsp.internal.switchtolsp.SwitchToLspWizard;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.ServiceCaller;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.notifications.NotificationPopup;
import org.eclipse.jface.notifications.internal.CommonImages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class SwitchToLspBanner {
    private Composite tryLspComposite;
    private GridData tryLspCompositeLayoutData;
    private ITextEditor editor;

    public SwitchToLspBanner(ITextEditor part) {
        this.editor = part;
    }

    private void createContent() {
        Composite parent = this.tryLspComposite;
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).align(4, 128).create());
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(4, 4).spacing(10, 10).numColumns(3).create());
        composite.setBackgroundMode(1);
        composite.setBackground(Display.getDefault().getSystemColor(1));
        Label fill = new Label(composite, 0);
        fill.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Link tryLspButton = new Link(composite, 0);
        tryLspButton.setText(this.tryLspBannerLink());
        tryLspButton.addListener(13, e -> this.tryLspAction(e));
        this.createCloseButton(composite);
    }

    protected abstract void tryLspAction(Event var1);

    protected abstract String tryLspBannerLink();

    protected ITextEditor getPart() {
        return this.editor;
    }

    void createCloseButton(Composite parent) {
        final Image close = (Image)SafeRunner.run(() -> CommonImages.getImage((ImageDescriptor)CommonImages.NOTIFICATION_CLOSE));
        final Image closeHover = (Image)SafeRunner.run(() -> CommonImages.getImage((ImageDescriptor)CommonImages.NOTIFICATION_CLOSE_HOVER));
        final Label button = new Label(parent, 0);
        button.setImage(close);
        button.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                button.setImage(closeHover);
            }

            public void mouseExit(MouseEvent e) {
                button.setImage(close);
            }
        });
        button.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                SwitchToLspBanner.this.close();
            }
        });
    }

    private void close() {
        this.hideTryLsp();
        Shell shell = this.editor.getSite().getShell();
        NotificationPopup.Builder notification = NotificationPopup.forShell((Shell)shell).title(Messages.SwitchToLsp_NewExperienceTitile, true).content(parent -> this.createInfoWithLinks((Composite)parent, shell));
        notification.open();
    }

    private Control createInfoWithLinks(Composite parent, Shell parentShell) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        Label intro = new Label(composite, 0);
        intro.setText(Messages.SwitchToLsp_LearnMoreMessage);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)intro);
        Button showButton = new Button(composite, 32);
        showButton.setText(LspUiMessages.LspEditorConfigurationPage_showTryLspBanner);
        showButton.setToolTipText(LspUiMessages.LspEditorConfigurationPage_showTryLspBanner_description);
        showButton.setSelection(true);
        showButton.addListener(13, event -> {
            IWorkspace workspace = (IWorkspace)PlatformUI.getWorkbench().getService(IWorkspace.class);
            ServiceCaller.callOnce(SwitchToLspWizard.class, EditorConfiguration.class, cc -> cc.storage(workspace).save((Object)showButton.getSelection(), EditorMetadata.Predefined.showTryLspBanner));
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)showButton);
        Link link = new Link(composite, 0);
        link.setText(LinkHelper.getLinks(true));
        link.setFont(composite.getFont());
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)link);
        link.addListener(13, event -> {
            boolean bl = LinkHelper.handleLinkClick(parentShell, event);
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)link);
        return composite;
    }

    private boolean isBannerEnabled() {
        boolean showBanner = SwitchToLspWizard.showPreferLsp(this.editor);
        if (!showBanner) {
            return false;
        }
        return this.getOptionShowBanner();
    }

    private boolean getOptionShowBanner() {
        EditorConfiguration configuration = (EditorConfiguration)PlatformUI.getWorkbench().getService(EditorConfiguration.class);
        if (configuration == null) {
            return false;
        }
        EditorOptions options = null;
        IWorkspace workspace = (IWorkspace)PlatformUI.getWorkbench().getService(IWorkspace.class);
        options = configuration.options(workspace);
        if (options == null) {
            return false;
        }
        return options.showTryLspBanner();
    }

    private void showBanner() {
        if (this.tryLspComposite == null || this.tryLspComposite.isDisposed()) {
            return;
        }
        if (this.tryLspComposite.getChildren().length == 0) {
            this.createContent();
        }
        ((GridData)this.tryLspComposite.getLayoutData()).exclude = false;
        this.tryLspComposite.setVisible(true);
        this.tryLspComposite.getParent().layout(true, true);
    }

    private void hideTryLsp() {
        if (this.tryLspComposite == null) {
            return;
        }
        this.tryLspCompositeLayoutData.exclude = true;
        this.tryLspComposite.setVisible(false);
        this.tryLspComposite.getParent().layout(true, true);
    }

    public Composite create(Composite parent) {
        if (!this.isBannerEnabled()) {
            return parent;
        }
        Composite topComposite = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout(1, false);
        topLayout.marginHeight = 0;
        topLayout.marginWidth = 0;
        topLayout.horizontalSpacing = 0;
        topLayout.verticalSpacing = 0;
        topComposite.setLayout((Layout)topLayout);
        this.tryLspComposite = new Composite(topComposite, 0);
        this.tryLspCompositeLayoutData = new GridData(4, 128, true, false);
        this.tryLspComposite.setLayoutData((Object)this.tryLspCompositeLayoutData);
        GridLayout tryLspLayout = new GridLayout(1, false);
        tryLspLayout.marginHeight = 0;
        tryLspLayout.marginWidth = 0;
        tryLspLayout.horizontalSpacing = 0;
        tryLspLayout.verticalSpacing = 0;
        this.tryLspCompositeLayoutData.exclude = true;
        this.tryLspComposite.setLayout((Layout)tryLspLayout);
        this.showBanner();
        Composite editorComposite = new Composite(topComposite, 0);
        editorComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        FillLayout editorLayout = new FillLayout(512);
        editorLayout.marginHeight = 0;
        editorLayout.marginWidth = 0;
        editorLayout.spacing = 0;
        editorComposite.setLayout((Layout)editorLayout);
        return editorComposite;
    }
}

