/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.breakpointactions;

import java.util.ArrayList;
import org.eclipse.cdt.debug.ui.breakpointactions.ExternalToolActionPage;
import org.eclipse.cdt.debug.ui.breakpointactions.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.dialogs.ListDialog;

public class ExternalToolActionComposite
extends Composite {
    private Text extToolName;

    public ExternalToolActionComposite(Composite parent, int style, ExternalToolActionPage page) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.setLayout((Layout)gridLayout);
        Label executeFileLabel = new Label((Composite)this, 16384);
        executeFileLabel.setLayoutData((Object)new GridData());
        executeFileLabel.setText(Messages.getString("ExternalToolActionComposite.ToolLabel"));
        this.extToolName = new Text((Composite)this, 8);
        this.extToolName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.extToolName.setText(page.getExternalToolAction().getExternalToolName());
        final ExternalToolActionComposite externalToolActionComposite = this;
        final Button browseButton = new Button((Composite)this, 0);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] selectedTool;
                ILaunchConfiguration[] lcs = ExternalToolActionComposite.this.getLaunchConfigurations();
                LaunchConfigurationSelectionDialog dlg = new LaunchConfigurationSelectionDialog(externalToolActionComposite, lcs);
                dlg.setTitle(Messages.getString("ExternalToolActionComposite.DialogTitle"));
                dlg.setMessage(Messages.getString("ExternalToolActionComposite.DialogMessage"));
                if (lcs.length > 0) {
                    Object[] initialSelection = new ILaunchConfiguration[1];
                    String existingName = ExternalToolActionComposite.this.extToolName.getText();
                    initialSelection[0] = lcs[0];
                    if (existingName.length() > 0) {
                        int i = 0;
                        while (i < lcs.length) {
                            if (lcs[i].getName().equals(existingName)) {
                                initialSelection[0] = lcs[i];
                                break;
                            }
                            ++i;
                        }
                    }
                    dlg.setInitialSelections(initialSelection);
                }
                dlg.setAddCancelButton(false);
                if (dlg.open() == 0 && (selectedTool = dlg.getResult()).length > 0 && selectedTool[0] instanceof ILaunchConfiguration) {
                    externalToolActionComposite.setExternalToolName(((ILaunchConfiguration)selectedTool[0]).getName());
                }
            }
        });
        browseButton.setText(Messages.getString("ExternalToolActionComposite.ChooseButtonTitle"));
        browseButton.setEnabled(this.getLaunchConfigurations().length > 0);
        Button externalToolsButton = new Button((Composite)this, 0);
        externalToolsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)externalToolActionComposite.getShell(), (IStructuredSelection)new StructuredSelection(), (String)"org.eclipse.ui.externaltools.launchGroup");
                browseButton.setEnabled(ExternalToolActionComposite.this.getLaunchConfigurations().length > 0);
            }
        });
        externalToolsButton.setText(Messages.getString("ExternalToolActionComposite.ExternalToolsButtonTitle"));
    }

    protected void setExternalToolName(String externalToolName) {
        this.extToolName.setText(externalToolName);
    }

    private boolean equalCategories(String c1, String c2) {
        if (c1 == null || c2 == null) {
            return c1 == c2;
        }
        return c1.equals(c2);
    }

    public ILaunchConfiguration[] getLaunchConfigurations() {
        ArrayList<ILaunchConfiguration> onlyExternalTools = new ArrayList<ILaunchConfiguration>();
        ILaunchManager lcm = DebugPlugin.getDefault().getLaunchManager();
        try {
            ILaunchConfiguration[] launchConfigurations = lcm.getLaunchConfigurations();
            int i = 0;
            while (i < launchConfigurations.length) {
                ILaunchConfiguration config = launchConfigurations[i];
                ILaunchConfigurationType type = config.getType();
                boolean priv = false;
                try {
                    priv = config.getAttribute("org.eclipse.debug.ui.private", false);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                if (type != null && !priv && type.supportsMode("run") && this.equalCategories(type.getCategory(), "org.eclipse.ui.externaltools") && !WorkbenchActivityHelper.filterItem((Object)new LaunchConfigurationTypeContribution(type))) {
                    onlyExternalTools.add(launchConfigurations[i]);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return onlyExternalTools.toArray(new ILaunchConfiguration[onlyExternalTools.size()]);
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public String getLaunchConfigName() {
        return this.extToolName.getText();
    }

    public class LaunchConfigurationSelectionDialog
    extends ListDialog {
        private ILaunchConfiguration[] launchConfigs;

        public LaunchConfigurationSelectionDialog(ExternalToolActionComposite composite, ILaunchConfiguration[] lcs) {
            super(composite.getShell());
            this.launchConfigs = lcs;
            this.setInput((Object)composite);
            this.setContentProvider(new IStructuredContentProvider(){

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public Object[] getElements(Object parent) {
                    return LaunchConfigurationSelectionDialog.this.launchConfigs;
                }
            });
            this.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    return ((ILaunchConfiguration)element).getName();
                }
            });
        }
    }

    class LaunchConfigurationTypeContribution
    implements IPluginContribution {
        protected ILaunchConfigurationType type;

        public LaunchConfigurationTypeContribution(ILaunchConfigurationType type) {
            this.type = type;
        }

        public String getLocalId() {
            return this.type.getIdentifier();
        }

        public String getPluginId() {
            return this.type.getPluginIdentifier();
        }
    }
}

