/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.catalog;

import io.github.toolfactory.jvm.function.InitializeException;
import io.github.toolfactory.jvm.function.catalog.SetAccessibleFunction;
import io.github.toolfactory.jvm.function.catalog.ThrowExceptionFunction;
import io.github.toolfactory.jvm.function.catalog.UnsafeSupplier;
import io.github.toolfactory.jvm.function.template.BiFunction;
import io.github.toolfactory.jvm.function.template.Supplier;
import io.github.toolfactory.jvm.util.ObjectProvider;
import io.github.toolfactory.jvm.util.Strings;
import io.github.toolfactory.narcissus.Narcissus;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import sun.misc.Unsafe;

public interface GetFieldValueFunction
extends BiFunction<Object, Field, Object> {

    public static interface Native
    extends GetFieldValueFunction {

        public static class ForJava7
        implements Native {
            public ForJava7(Map<Object, Object> context) throws InitializeException {
                this.checkNativeEngine();
            }

            protected void checkNativeEngine() throws InitializeException {
                if (!Narcissus.libraryLoaded) {
                    throw new InitializeException(Strings.compile("Could not initialize the native engine {}", Narcissus.class.getName()));
                }
            }

            @Override
            public Object apply(Object target, Field field) {
                if (Modifier.isStatic(field.getModifiers())) {
                    return Narcissus.getStaticField((Field)field);
                }
                return Narcissus.getField((Object)target, (Field)field);
            }
        }
    }

    public static class ForJava25
    extends ForJava7 {
        protected SetAccessibleFunction setAccessibleFunction;
        protected ThrowExceptionFunction throwExceptionFunction;
        protected Supplier<SetAccessibleFunction> setAccessibleFunctionSupplier;

        public ForJava25(final Map<Object, Object> context) {
            super(context);
            this.throwExceptionFunction = ObjectProvider.get(context).getOrBuildObject(ThrowExceptionFunction.class, context);
            this.setAccessibleFunctionSupplier = new Supplier<SetAccessibleFunction>(){

                @Override
                public SetAccessibleFunction get() {
                    return ObjectProvider.get(context).getOrBuildObject(SetAccessibleFunction.class, context);
                }
            };
        }

        @Override
        public Object apply(Object target, Field field) {
            boolean isStatic = Modifier.isStatic(field.getModifiers());
            try {
                target = isStatic ? field.getDeclaringClass() : target;
                Long fieldOffset = isStatic ? this.unsafe.staticFieldOffset(field) : this.unsafe.objectFieldOffset(field);
                return this.getByUnsafe(target, field, fieldOffset, field.getType());
            }
            catch (UnsupportedOperationException exc) {
                try {
                    this.setAccessible(field);
                    if (isStatic) {
                        return field.get(null);
                    }
                    return field.get(target);
                }
                catch (Throwable exc2) {
                    return this.throwExceptionFunction.apply(exc2);
                }
            }
        }

        protected void setAccessible(Field field) throws Throwable {
            try {
                this.setAccessibleFunction.accept(field, true);
            }
            catch (NullPointerException exc) {
                if (this.setAccessibleFunction == null) {
                    this.setAccessibleFunction = this.setAccessibleFunctionSupplier.get();
                    this.setAccessible(field);
                }
                this.throwExceptionFunction.accept(exc);
            }
        }
    }

    public static class ForJava7
    implements GetFieldValueFunction {
        protected Unsafe unsafe;

        public ForJava7(Map<Object, Object> context) {
            this.unsafe = (Unsafe)ObjectProvider.get(context).getOrBuildObject(UnsafeSupplier.class, context).get();
        }

        @Override
        public Object apply(Object target, Field field) {
            boolean isStatic = Modifier.isStatic(field.getModifiers());
            target = isStatic ? field.getDeclaringClass() : target;
            Long fieldOffset = isStatic ? this.unsafe.staticFieldOffset(field) : this.unsafe.objectFieldOffset(field);
            return this.getByUnsafe(target, field, fieldOffset, field.getType());
        }

        protected Object getByUnsafe(Object target, Field field, long fieldOffset, Class<?> cls) {
            if (!cls.isPrimitive()) {
                if (!Modifier.isVolatile(field.getModifiers())) {
                    return this.unsafe.getObject(target, fieldOffset);
                }
                return this.unsafe.getObjectVolatile(target, fieldOffset);
            }
            if (cls == Short.TYPE) {
                if (!Modifier.isVolatile(field.getModifiers())) {
                    return this.unsafe.getShort(target, fieldOffset);
                }
                return this.unsafe.getShortVolatile(target, fieldOffset);
            }
            if (cls == Integer.TYPE) {
                if (!Modifier.isVolatile(field.getModifiers())) {
                    return this.unsafe.getInt(target, fieldOffset);
                }
                return this.unsafe.getIntVolatile(target, fieldOffset);
            }
            if (cls == Long.TYPE) {
                if (!Modifier.isVolatile(field.getModifiers())) {
                    return this.unsafe.getLong(target, fieldOffset);
                }
                return this.unsafe.getLongVolatile(target, fieldOffset);
            }
            if (cls == Float.TYPE) {
                if (!Modifier.isVolatile(field.getModifiers())) {
                    return Float.valueOf(this.unsafe.getFloat(target, fieldOffset));
                }
                return Float.valueOf(this.unsafe.getFloatVolatile(target, fieldOffset));
            }
            if (cls == Double.TYPE) {
                if (!Modifier.isVolatile(field.getModifiers())) {
                    return this.unsafe.getDouble(target, fieldOffset);
                }
                return this.unsafe.getDoubleVolatile(target, fieldOffset);
            }
            if (cls == Boolean.TYPE) {
                if (!Modifier.isVolatile(field.getModifiers())) {
                    return this.unsafe.getBoolean(target, fieldOffset);
                }
                return this.unsafe.getBooleanVolatile(target, fieldOffset);
            }
            if (cls == Byte.TYPE) {
                if (!Modifier.isVolatile(field.getModifiers())) {
                    return this.unsafe.getByte(target, fieldOffset);
                }
                return this.unsafe.getByteVolatile(target, fieldOffset);
            }
            if (!Modifier.isVolatile(field.getModifiers())) {
                return Character.valueOf(this.unsafe.getChar(target, fieldOffset));
            }
            return Character.valueOf(this.unsafe.getCharVolatile(target, fieldOffset));
        }
    }
}

