/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adapters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDAdapterFactory;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDBaseAdapter;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.model.IActionProvider;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.model.IModelProxy;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IADTObjectListener;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IModel;
import org.eclipse.wst.xsd.ui.internal.adt.outline.ITreeElement;
import org.eclipse.wst.xsd.ui.internal.common.actions.AddXSDAttributeDeclarationAction;
import org.eclipse.wst.xsd.ui.internal.common.actions.AddXSDAttributeGroupDefinitionAction;
import org.eclipse.wst.xsd.ui.internal.common.actions.AddXSDElementAction;
import org.eclipse.wst.xsd.ui.internal.common.actions.AddXSDSchemaDirectiveAction;
import org.eclipse.xsd.XSDSchema;

public class CategoryAdapter
extends XSDBaseAdapter
implements IModelProxy,
IActionProvider,
IADTObjectListener {
    protected String text;
    protected Image image;
    protected Object parent;
    protected int groupType;
    protected Collection children;
    protected Collection allChildren;
    XSDSchema xsdSchema;
    public static final int ATTRIBUTES = 1;
    public static final int ELEMENTS = 2;
    public static final int TYPES = 3;
    public static final int GROUPS = 5;
    public static final int DIRECTIVES = 6;
    public static final int NOTATIONS = 7;
    public static final int ATTRIBUTE_GROUPS = 8;
    public static final int IDENTITY_CONSTRAINTS = 9;
    public static final int ANNOTATIONS = 10;

    public CategoryAdapter(String label, Image image, Collection children, XSDSchema xsdSchema, int groupType) {
        this.text = label;
        this.image = image;
        this.parent = xsdSchema;
        this.xsdSchema = xsdSchema;
        this.target = xsdSchema;
        this.children = children;
        this.groupType = groupType;
    }

    public XSDSchema getXSDSchema() {
        return this.xsdSchema;
    }

    public int getGroupType() {
        return this.groupType;
    }

    public Image getImage() {
        return this.image;
    }

    public String getText() {
        return this.text;
    }

    public ITreeElement[] getChildren() {
        return this.children.toArray(new ITreeElement[0]);
    }

    public ITreeElement[] getAllChildren() {
        return this.allChildren.toArray(new ITreeElement[0]);
    }

    public void setChildren(Collection list) {
        this.children = list;
    }

    public void setAllChildren(Collection list) {
        this.allChildren = list;
    }

    public Object getParent(Object element) {
        return this.xsdSchema;
    }

    public boolean hasChildren(Object element) {
        return true;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public String[] getActions(Object object) {
        ArrayList<String> actionIDs = new ArrayList<String>();
        switch (this.groupType) {
            case 3: {
                actionIDs.add("org.eclipse.wst.xsd.ui.internal.editor.AddXSDComplexTypeDefinitionAction");
                actionIDs.add("org.eclipse.wst.xsd.ui.internal.editor.AddXSDSimpleTypeDefinitionAction");
                break;
            }
            case 2: {
                actionIDs.add(AddXSDElementAction.ID);
                break;
            }
            case 5: {
                actionIDs.add("AddXSDModelGroupDefinitionAction");
                break;
            }
            case 1: {
                actionIDs.add(AddXSDAttributeDeclarationAction.ID);
                actionIDs.add(AddXSDAttributeGroupDefinitionAction.ID);
                break;
            }
            case 8: {
                actionIDs.add(AddXSDAttributeGroupDefinitionAction.ID);
                break;
            }
            case 6: {
                actionIDs.add(AddXSDSchemaDirectiveAction.INCLUDE_ID);
                actionIDs.add(AddXSDSchemaDirectiveAction.IMPORT_ID);
                actionIDs.add(AddXSDSchemaDirectiveAction.REDEFINE_ID);
            }
        }
        actionIDs.add("org.eclipse.jface.action.Separator");
        actionIDs.add("org.eclipse.wst.xsd.ui.internal.adt.actions.ShowPropertiesViewAction");
        return actionIDs.toArray(new String[0]);
    }

    public void propertyChanged(Object object, String property) {
        if (this.getText().equals(property)) {
            this.notifyListeners(this, property);
        }
    }

    public List getTypes() {
        return null;
    }

    public IModel getModel() {
        return (IModel)XSDAdapterFactory.getInstance().adapt((Notifier)this.xsdSchema);
    }
}

