/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.contentmodel;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.wst.html.core.internal.contentmodel.CMNamedNodeMapImpl;
import org.eclipse.wst.html.core.internal.contentmodel.HTMLAttrDeclImpl;
import org.eclipse.wst.html.core.internal.contentmodel.HTMLAttributeDeclaration;
import org.eclipse.wst.html.core.internal.contentmodel.HTMLCMDataTypeImpl;
import org.eclipse.wst.html.core.internal.provisional.HTML40Namespace;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;

class AttributeCollection
extends CMNamedNodeMapImpl
implements HTML40Namespace {
    private static final String[] BODYCOLORS = new String[]{"bgcolor", "text", "link", "vlink", "alink"};
    private static final String[] CORE = new String[]{"id", "class", "style", "title"};
    private static final String[] EVENTS = new String[]{"onclick", "ondblclick", "onmousedown", "onmouseup", "onmouseover", "onmousemove", "onmouseout", "onkeypress", "onkeydown", "onkeyup", "onhelp"};
    private static final String[] I18N = new String[]{"lang", "dir"};
    private static final String[] CELLHALIGN = new String[]{"char", "charoff"};

    protected HTMLAttrDeclImpl create(String attrName) {
        HTMLAttrDeclImpl attr = null;
        HTMLCMDataTypeImpl atype = null;
        if (attrName.equalsIgnoreCase("abbr")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("abbr", atype, 1);
        } else if (attrName.equalsIgnoreCase("accept")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("accept", atype, 1);
        } else if (attrName.equalsIgnoreCase("accept-charset")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("accept-charset", atype, 1);
        } else if (attrName.equalsIgnoreCase("action")) {
            atype = new HTMLCMDataTypeImpl("URI");
            attr = new HTMLAttrDeclImpl("action", atype, 2);
        } else if (attrName.equalsIgnoreCase("archive")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("archive", atype, 1);
        } else if (attrName.equalsIgnoreCase("accesskey")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("accesskey", atype, 1);
        } else if (attrName.equalsIgnoreCase("alink")) {
            atype = new HTMLCMDataTypeImpl("COLOR");
            attr = new HTMLAttrDeclImpl("alink", atype, 1);
        } else if (attrName.equalsIgnoreCase("alt")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("alt", atype, 2);
        } else if (attrName.equalsIgnoreCase("autostart")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"true", "false"};
            atype.setEnumValues(values);
            attr = new HTMLAttrDeclImpl("autostart", atype, 1);
        } else if (attrName.equalsIgnoreCase("autoplay")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"true", "false"};
            atype.setEnumValues(values);
            attr = new HTMLAttrDeclImpl("autoplay", atype, 1);
        } else if (attrName.equalsIgnoreCase("autosize")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"true", "false"};
            atype.setEnumValues(values);
            attr = new HTMLAttrDeclImpl("autosize", atype, 1);
        } else if (attrName.equalsIgnoreCase("axis")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("axis", atype, 1);
        } else if (attrName.equalsIgnoreCase("background")) {
            atype = new HTMLCMDataTypeImpl("URI");
            attr = new HTMLAttrDeclImpl("background", atype, 1);
        } else if (attrName.equalsIgnoreCase("behavior")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"scroll", "slide", "alternate"};
            atype.setEnumValues(values);
            atype.setImpliedValue(3, "scroll");
            attr = new HTMLAttrDeclImpl("behavior", atype, 1);
        } else if (attrName.equalsIgnoreCase("bgcolor")) {
            atype = new HTMLCMDataTypeImpl("COLOR");
            attr = new HTMLAttrDeclImpl("bgcolor", atype, 1);
        } else if (attrName.equalsIgnoreCase("border")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("border", atype, 1);
        } else if (attrName.equalsIgnoreCase("cellspacing")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("cellspacing", atype, 1);
        } else if (attrName.equalsIgnoreCase("cellpadding")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("cellpadding", atype, 1);
        } else if (attrName.equalsIgnoreCase("cgi")) {
            atype = new HTMLCMDataTypeImpl("URI");
            attr = new HTMLAttrDeclImpl("cgi", atype, 1);
        } else if (attrName.equalsIgnoreCase("char")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("char", atype, 1);
        } else if (attrName.equalsIgnoreCase("charoff")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("charoff", atype, 1);
        } else if (attrName.equalsIgnoreCase("charset")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("charset", atype, 1);
        } else if (attrName.equalsIgnoreCase("cite")) {
            atype = new HTMLCMDataTypeImpl("URI");
            attr = new HTMLAttrDeclImpl("cite", atype, 1);
        } else if (attrName.equalsIgnoreCase("class")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("class", atype, 1);
        } else if (attrName.equalsIgnoreCase("classid")) {
            atype = new HTMLCMDataTypeImpl("URI");
            attr = new HTMLAttrDeclImpl("classid", atype, 1);
        } else if (attrName.equalsIgnoreCase("cmd")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("cmd", atype, 1);
        } else if (attrName.equalsIgnoreCase("checked")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"checked"};
            atype.setEnumValues(values);
            attr = new HTMLAttrDeclImpl("checked", atype, 1);
        } else if (attrName.equalsIgnoreCase("clear")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"left", "all", "right", "none"};
            atype.setEnumValues(values);
            atype.setImpliedValue(3, "none");
            attr = new HTMLAttrDeclImpl("clear", atype, 1);
        } else if (attrName.equalsIgnoreCase("code")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("code", atype, 1);
        } else if (attrName.equalsIgnoreCase("codebase")) {
            atype = new HTMLCMDataTypeImpl("URI");
            attr = new HTMLAttrDeclImpl("codebase", atype, 1);
        } else if (attrName.equalsIgnoreCase("codetype")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("codetype", atype, 1);
        } else if (attrName.equalsIgnoreCase("color")) {
            atype = new HTMLCMDataTypeImpl("COLOR");
            attr = new HTMLAttrDeclImpl("color", atype, 1);
        } else if (attrName.equalsIgnoreCase("compact")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"compact"};
            atype.setEnumValues(values);
            attr = new HTMLAttrDeclImpl("compact", atype, 1);
        } else if (attrName.equalsIgnoreCase("cols")) {
            atype = new HTMLCMDataTypeImpl("NUMBER");
            attr = new HTMLAttrDeclImpl("cols", atype, 2);
        } else if (attrName.equalsIgnoreCase("colspan")) {
            atype = new HTMLCMDataTypeImpl("NUMBER");
            atype.setImpliedValue(3, "1");
            attr = new HTMLAttrDeclImpl("colspan", atype, 1);
        } else if (attrName.equalsIgnoreCase("content")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("content", atype, 2);
        } else if (attrName.equalsIgnoreCase("controller")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"true", "false"};
            atype.setEnumValues(values);
            atype.setImpliedValue(3, "true");
            attr = new HTMLAttrDeclImpl("controller", atype, 1);
        } else if (attrName.equalsIgnoreCase("coords")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("coords", atype, 1);
        } else if (attrName.equalsIgnoreCase("data")) {
            atype = new HTMLCMDataTypeImpl("URI");
            attr = new HTMLAttrDeclImpl("data", atype, 1);
        } else if (attrName.equalsIgnoreCase("datetime")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("datetime", atype, 1);
        } else if (attrName.equalsIgnoreCase("datapagesize")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("datapagesize", atype, 1);
        } else if (attrName.equalsIgnoreCase("declare")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"declare"};
            atype.setEnumValues(values);
            attr = new HTMLAttrDeclImpl("declare", atype, 1);
        } else if (attrName.equalsIgnoreCase("defer")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"defer"};
            atype.setEnumValues(values);
            attr = new HTMLAttrDeclImpl("defer", atype, 1);
        } else if (attrName.equalsIgnoreCase("dir")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"ltr", "rtl"};
            atype.setEnumValues(values);
            attr = new HTMLAttrDeclImpl("dir", atype, 1);
        } else if (attrName.equalsIgnoreCase("direction")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"left", "right", "up", "down"};
            atype.setEnumValues(values);
            attr = new HTMLAttrDeclImpl("direction", atype, 1);
        } else if (attrName.equalsIgnoreCase("directkey")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("directkey", atype, 1);
        } else if (attrName.equalsIgnoreCase("disabled")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"disabled"};
            atype.setEnumValues(values);
            attr = new HTMLAttrDeclImpl("disabled", atype, 1);
        } else if (attrName.equalsIgnoreCase("enctype")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            atype.setImpliedValue(3, "application/x-www-form-urlencoded");
            attr = new HTMLAttrDeclImpl("enctype", atype, 1);
        } else if (attrName.equalsIgnoreCase("errmsg")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("errmsg", atype, 1);
        } else if (attrName.equalsIgnoreCase("event")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("event", atype, 1);
        } else if (attrName.equalsIgnoreCase("face")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("face", atype, 1);
        } else if (attrName.equalsIgnoreCase("file")) {
            atype = new HTMLCMDataTypeImpl("URI");
            attr = new HTMLAttrDeclImpl("file", atype, 1);
        } else if (attrName.equalsIgnoreCase("for")) {
            atype = new HTMLCMDataTypeImpl("URI");
            attr = new HTMLAttrDeclImpl("for", atype, 1);
        } else if (attrName.equalsIgnoreCase("frame")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"void", "above", "below", "hsides", "lhs", "rhs", "vsides", "box", "border"};
            atype.setEnumValues(values);
            attr = new HTMLAttrDeclImpl("frame", atype, 1);
        } else if (attrName.equalsIgnoreCase("frameborder")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"1", "0"};
            atype.setEnumValues(values);
            atype.setImpliedValue(3, "1");
            attr = new HTMLAttrDeclImpl("frameborder", atype, 1);
        } else if (attrName.equalsIgnoreCase("framespacing")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("framespacing", atype, 1);
        } else if (attrName.equalsIgnoreCase("headers")) {
            atype = new HTMLCMDataTypeImpl("IDREFS");
            attr = new HTMLAttrDeclImpl("headers", atype, 1);
        } else if (attrName.equalsIgnoreCase("height")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("height", atype, 1);
        } else if (attrName.equalsIgnoreCase("hidden")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("hidden", atype, 1);
        } else if (attrName.equalsIgnoreCase("href")) {
            atype = new HTMLCMDataTypeImpl("URI");
            attr = new HTMLAttrDeclImpl("href", atype, 1);
        } else if (attrName.equalsIgnoreCase("hreflang")) {
            atype = new HTMLCMDataTypeImpl("NAME");
            attr = new HTMLAttrDeclImpl("hreflang", atype, 1);
        } else if (attrName.equalsIgnoreCase("hspace")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("hspace", atype, 1);
        } else if (attrName.equalsIgnoreCase("http-equiv")) {
            atype = new HTMLCMDataTypeImpl("NAME");
            attr = new HTMLAttrDeclImpl("http-equiv", atype, 1);
        } else if (attrName.equalsIgnoreCase("id")) {
            atype = new HTMLCMDataTypeImpl("ID");
            attr = new HTMLAttrDeclImpl("id", atype, 1);
        } else if (attrName.equalsIgnoreCase("ismap")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"ismap"};
            atype.setEnumValues(values);
            attr = new HTMLAttrDeclImpl("ismap", atype, 1);
        } else if (attrName.equalsIgnoreCase("istyle")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("istyle", atype, 1);
        } else if (attrName.equalsIgnoreCase("label")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("label", atype, 1);
        } else if (attrName.equalsIgnoreCase("lang")) {
            atype = new HTMLCMDataTypeImpl("NAME");
            attr = new HTMLAttrDeclImpl("lang", atype, 1);
        } else if (attrName.equalsIgnoreCase("language")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("language", atype, 1);
        } else if (attrName.equalsIgnoreCase("link")) {
            atype = new HTMLCMDataTypeImpl("COLOR");
            attr = new HTMLAttrDeclImpl("link", atype, 1);
        } else if (attrName.equalsIgnoreCase("longdesc")) {
            atype = new HTMLCMDataTypeImpl("URI");
            attr = new HTMLAttrDeclImpl("longdesc", atype, 1);
        } else if (attrName.equalsIgnoreCase("loop")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("loop", atype, 1);
        } else if (attrName.equalsIgnoreCase("macro")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("macro", atype, 1);
        } else if (attrName.equalsIgnoreCase("mapfile")) {
            atype = new HTMLCMDataTypeImpl("URI");
            attr = new HTMLAttrDeclImpl("mapfile", atype, 1);
        } else if (attrName.equalsIgnoreCase("marginwidth")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("marginwidth", atype, 1);
        } else if (attrName.equalsIgnoreCase("marginheight")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("marginheight", atype, 1);
        } else if (attrName.equalsIgnoreCase("maxlength")) {
            atype = new HTMLCMDataTypeImpl("NUMBER");
            attr = new HTMLAttrDeclImpl("maxlength", atype, 1);
        } else if (attrName.equalsIgnoreCase("mayscript")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"mayscript"};
            atype.setEnumValues(values);
            attr = new HTMLAttrDeclImpl("mayscript", atype, 1);
        } else if (attrName.equalsIgnoreCase("media")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("media", atype, 1);
        } else if (attrName.equalsIgnoreCase("method")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"get", "post"};
            atype.setEnumValues(values);
            atype.setImpliedValue(3, "get");
            attr = new HTMLAttrDeclImpl("method", atype, 1);
        } else if (attrName.equalsIgnoreCase("multiple")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"multiple"};
            atype.setEnumValues(values);
            attr = new HTMLAttrDeclImpl("multiple", atype, 1);
        } else if (attrName.equalsIgnoreCase("name")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("name", atype, 1);
        } else if (attrName.equalsIgnoreCase("nohref")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"nohref"};
            atype.setEnumValues(values);
            attr = new HTMLAttrDeclImpl("nohref", atype, 1);
        } else if (attrName.equalsIgnoreCase("noresize")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"noresize"};
            atype.setEnumValues(values);
            attr = new HTMLAttrDeclImpl("noresize", atype, 1);
        } else if (attrName.equalsIgnoreCase("noshade")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"noshade"};
            atype.setEnumValues(values);
            attr = new HTMLAttrDeclImpl("noshade", atype, 1);
        } else if (attrName.equalsIgnoreCase("nowrap")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"nowrap"};
            atype.setEnumValues(values);
            attr = new HTMLAttrDeclImpl("nowrap", atype, 1);
        } else if (attrName.equalsIgnoreCase("object")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"object"};
            atype.setEnumValues(values);
            attr = new HTMLAttrDeclImpl("object", atype, 1);
        } else if (attrName.equalsIgnoreCase("onblur")) {
            atype = new HTMLCMDataTypeImpl("EVENT");
            attr = new HTMLAttrDeclImpl("onblur", atype, 1);
        } else if (attrName.equalsIgnoreCase("onclick")) {
            atype = new HTMLCMDataTypeImpl("EVENT");
            attr = new HTMLAttrDeclImpl("onclick", atype, 1);
        } else if (attrName.equalsIgnoreCase("onchange")) {
            atype = new HTMLCMDataTypeImpl("EVENT");
            attr = new HTMLAttrDeclImpl("onchange", atype, 1);
        } else if (attrName.equalsIgnoreCase("ondblclick")) {
            atype = new HTMLCMDataTypeImpl("EVENT");
            attr = new HTMLAttrDeclImpl("ondblclick", atype, 1);
        } else if (attrName.equalsIgnoreCase("onfocus")) {
            atype = new HTMLCMDataTypeImpl("EVENT");
            attr = new HTMLAttrDeclImpl("onfocus", atype, 1);
        } else if (attrName.equalsIgnoreCase("onhelp")) {
            atype = new HTMLCMDataTypeImpl("EVENT");
            attr = new HTMLAttrDeclImpl("onhelp", atype, 1);
        } else if (attrName.equalsIgnoreCase("onkeypress")) {
            atype = new HTMLCMDataTypeImpl("EVENT");
            attr = new HTMLAttrDeclImpl("onkeypress", atype, 1);
        } else if (attrName.equalsIgnoreCase("onkeydown")) {
            atype = new HTMLCMDataTypeImpl("EVENT");
            attr = new HTMLAttrDeclImpl("onkeydown", atype, 1);
        } else if (attrName.equalsIgnoreCase("onkeyup")) {
            atype = new HTMLCMDataTypeImpl("EVENT");
            attr = new HTMLAttrDeclImpl("onkeyup", atype, 1);
        } else if (attrName.equalsIgnoreCase("onload")) {
            atype = new HTMLCMDataTypeImpl("EVENT");
            attr = new HTMLAttrDeclImpl("onload", atype, 1);
        } else if (attrName.equalsIgnoreCase("onmousedown")) {
            atype = new HTMLCMDataTypeImpl("EVENT");
            attr = new HTMLAttrDeclImpl("onmousedown", atype, 1);
        } else if (attrName.equalsIgnoreCase("onmouseup")) {
            atype = new HTMLCMDataTypeImpl("EVENT");
            attr = new HTMLAttrDeclImpl("onmouseup", atype, 1);
        } else if (attrName.equalsIgnoreCase("onmouseover")) {
            atype = new HTMLCMDataTypeImpl("EVENT");
            attr = new HTMLAttrDeclImpl("onmouseover", atype, 1);
        } else if (attrName.equalsIgnoreCase("onmousemove")) {
            atype = new HTMLCMDataTypeImpl("EVENT");
            attr = new HTMLAttrDeclImpl("onmousemove", atype, 1);
        } else if (attrName.equalsIgnoreCase("onmouseout")) {
            atype = new HTMLCMDataTypeImpl("EVENT");
            attr = new HTMLAttrDeclImpl("onmouseout", atype, 1);
        } else if (attrName.equalsIgnoreCase("onreset")) {
            atype = new HTMLCMDataTypeImpl("EVENT");
            attr = new HTMLAttrDeclImpl("onreset", atype, 1);
        } else if (attrName.equalsIgnoreCase("onselect")) {
            atype = new HTMLCMDataTypeImpl("EVENT");
            attr = new HTMLAttrDeclImpl("onselect", atype, 1);
        } else if (attrName.equalsIgnoreCase("onsubmit")) {
            atype = new HTMLCMDataTypeImpl("EVENT");
            attr = new HTMLAttrDeclImpl("onsubmit", atype, 1);
        } else if (attrName.equalsIgnoreCase("onunload")) {
            atype = new HTMLCMDataTypeImpl("EVENT");
            attr = new HTMLAttrDeclImpl("onunload", atype, 1);
        } else if (attrName.equalsIgnoreCase("palette")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("palette", atype, 1);
        } else if (attrName.equalsIgnoreCase("panel")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("panel", atype, 1);
        } else if (attrName.equalsIgnoreCase("playcount")) {
            atype = new HTMLCMDataTypeImpl("NUMBER");
            attr = new HTMLAttrDeclImpl("playcount", atype, 1);
        } else if (attrName.equalsIgnoreCase("profile")) {
            atype = new HTMLCMDataTypeImpl("URI");
            attr = new HTMLAttrDeclImpl("profile", atype, 1);
        } else if (attrName.equalsIgnoreCase("prompt")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("prompt", atype, 1);
        } else if (attrName.equalsIgnoreCase("readonly")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"readonly"};
            atype.setEnumValues(values);
            attr = new HTMLAttrDeclImpl("readonly", atype, 1);
        } else if (attrName.equalsIgnoreCase("repeat")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("repeat", atype, 1);
        } else if (attrName.equalsIgnoreCase("rel")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("rel", atype, 1);
        } else if (attrName.equalsIgnoreCase("rev")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("rev", atype, 1);
        } else if (attrName.equalsIgnoreCase("rows")) {
            atype = new HTMLCMDataTypeImpl("NUMBER");
            attr = new HTMLAttrDeclImpl("rows", atype, 2);
        } else if (attrName.equalsIgnoreCase("rowspan")) {
            atype = new HTMLCMDataTypeImpl("NUMBER");
            atype.setImpliedValue(3, "1");
            attr = new HTMLAttrDeclImpl("rowspan", atype, 1);
        } else if (attrName.equalsIgnoreCase("rules")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"none", "groups", "rows", "cols", "all"};
            atype.setEnumValues(values);
            attr = new HTMLAttrDeclImpl("rules", atype, 1);
        } else if (attrName.equalsIgnoreCase("scale")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("scale", atype, 1);
        } else if (attrName.equalsIgnoreCase("scheme")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("scheme", atype, 1);
        } else if (attrName.equalsIgnoreCase("selected")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"selected"};
            atype.setEnumValues(values);
            attr = new HTMLAttrDeclImpl("selected", atype, 1);
        } else if (attrName.equalsIgnoreCase("scope")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"row", "col", "rowgroup", "colgroup"};
            atype.setEnumValues(values);
            attr = new HTMLAttrDeclImpl("scope", atype, 1);
        } else if (attrName.equalsIgnoreCase("scrollamount")) {
            atype = new HTMLCMDataTypeImpl("NUMBER");
            attr = new HTMLAttrDeclImpl("scrollamount", atype, 1);
        } else if (attrName.equalsIgnoreCase("scrolldelay")) {
            atype = new HTMLCMDataTypeImpl("NUMBER");
            attr = new HTMLAttrDeclImpl("scrolldelay", atype, 1);
        } else if (attrName.equalsIgnoreCase("scrolling")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"yes", "no", "auto"};
            atype.setEnumValues(values);
            atype.setImpliedValue(3, "auto");
            attr = new HTMLAttrDeclImpl("scrolling", atype, 1);
        } else if (attrName.equalsIgnoreCase("shape")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"rect", "circle", "poly", "default"};
            atype.setEnumValues(values);
            atype.setImpliedValue(3, "rect");
            attr = new HTMLAttrDeclImpl("shape", atype, 1);
        } else if (attrName.equalsIgnoreCase("showcontrols")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"true", "false"};
            atype.setEnumValues(values);
            attr = new HTMLAttrDeclImpl("showcontrols", atype, 1);
        } else if (attrName.equalsIgnoreCase("size")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("size", atype, 1);
        } else if (attrName.equalsIgnoreCase("sizefmt")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("sizefmt", atype, 1);
        } else if (attrName.equalsIgnoreCase("span")) {
            atype = new HTMLCMDataTypeImpl("NUMBER");
            atype.setImpliedValue(3, "1");
            attr = new HTMLAttrDeclImpl("span", atype, 1);
        } else if (attrName.equalsIgnoreCase("src")) {
            atype = new HTMLCMDataTypeImpl("URI");
            attr = new HTMLAttrDeclImpl("src", atype, 1);
        } else if (attrName.equalsIgnoreCase("start")) {
            atype = new HTMLCMDataTypeImpl("NUMBER");
            attr = new HTMLAttrDeclImpl("start", atype, 1);
        } else if (attrName.equalsIgnoreCase("standby")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("standby", atype, 1);
        } else if (attrName.equalsIgnoreCase("style")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("style", atype, 1);
        } else if (attrName.equalsIgnoreCase("summary")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("summary", atype, 1);
        } else if (attrName.equalsIgnoreCase("tabindex")) {
            atype = new HTMLCMDataTypeImpl("NUMBER");
            attr = new HTMLAttrDeclImpl("tabindex", atype, 1);
        } else if (attrName.equalsIgnoreCase("target")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("target", atype, 1);
        } else if (attrName.equalsIgnoreCase("text")) {
            atype = new HTMLCMDataTypeImpl("COLOR");
            attr = new HTMLAttrDeclImpl("text", atype, 1);
        } else if (attrName.equalsIgnoreCase("textfocus")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("textfocus", atype, 1);
        } else if (attrName.equalsIgnoreCase("title")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("title", atype, 1);
        } else if (attrName.equalsIgnoreCase("timefmt")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("timefmt", atype, 1);
        } else if (attrName.equalsIgnoreCase("truespeed")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"truespeed"};
            atype.setEnumValues(values);
            attr = new HTMLAttrDeclImpl("truespeed", atype, 1);
        } else if (attrName.equalsIgnoreCase("type")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("type", atype, 1);
        } else if (attrName.equalsIgnoreCase("usemap")) {
            atype = new HTMLCMDataTypeImpl("URI");
            attr = new HTMLAttrDeclImpl("usemap", atype, 1);
        } else if (attrName.equalsIgnoreCase("valign")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"top", "middle", "bottom", "baseline"};
            atype.setEnumValues(values);
            attr = new HTMLAttrDeclImpl("valign", atype, 1);
        } else if (attrName.equalsIgnoreCase("value")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("value", atype, 1);
        } else if (attrName.equalsIgnoreCase("valuetype")) {
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"data", "ref", "object"};
            atype.setEnumValues(values);
            atype.setImpliedValue(3, "data");
            attr = new HTMLAttrDeclImpl("valuetype", atype, 1);
        } else if (attrName.equalsIgnoreCase("var")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("var", atype, 1);
        } else if (attrName.equalsIgnoreCase("version")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            atype.setImpliedValue(2, "-//W3C//DTD HTML 4.01 Transitional//EN");
            attr = new HTMLAttrDeclImpl("version", atype, 3);
        } else if (attrName.equalsIgnoreCase("virtual")) {
            atype = new HTMLCMDataTypeImpl("URI");
            attr = new HTMLAttrDeclImpl("virtual", atype, 1);
        } else if (attrName.equalsIgnoreCase("vlink")) {
            atype = new HTMLCMDataTypeImpl("COLOR");
            attr = new HTMLAttrDeclImpl("vlink", atype, 1);
        } else if (attrName.equalsIgnoreCase("volume")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("volume", atype, 1);
        } else if (attrName.equalsIgnoreCase("width")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("width", atype, 1);
        } else if (attrName.equalsIgnoreCase("vspace")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("vspace", atype, 1);
        } else if (attrName.equalsIgnoreCase("topmargin")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("topmargin", atype, 1);
        } else if (attrName.equalsIgnoreCase("bottommargin")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("bottommargin", atype, 1);
        } else if (attrName.equalsIgnoreCase("leftmargin")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("leftmargin", atype, 1);
        } else if (attrName.equalsIgnoreCase("rightmargin")) {
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("rightmargin", atype, 1);
        } else if (attrName.equalsIgnoreCase("bordercolor")) {
            atype = new HTMLCMDataTypeImpl("COLOR");
            attr = new HTMLAttrDeclImpl("bordercolor", atype, 1);
        } else {
            attr = null;
        }
        return attr;
    }

    public static final HTMLAttrDeclImpl createAlignForCaption() {
        HTMLCMDataTypeImpl atype = new HTMLCMDataTypeImpl("ENUM");
        String[] values = new String[]{"top", "bottom", "left", "right"};
        atype.setEnumValues(values);
        HTMLAttrDeclImpl attr = new HTMLAttrDeclImpl("align", atype, 1);
        return attr;
    }

    public static final HTMLAttrDeclImpl createAlignForImage() {
        HTMLCMDataTypeImpl atype = new HTMLCMDataTypeImpl("ENUM");
        String[] values = new String[]{"top", "middle", "bottom", "left", "right"};
        atype.setEnumValues(values);
        HTMLAttrDeclImpl attr = new HTMLAttrDeclImpl("align", atype, 1);
        return attr;
    }

    public static final HTMLAttrDeclImpl createAlignForLegend() {
        HTMLCMDataTypeImpl atype = new HTMLCMDataTypeImpl("ENUM");
        String[] values = new String[]{"top", "bottom", "left", "right"};
        atype.setEnumValues(values);
        HTMLAttrDeclImpl attr = new HTMLAttrDeclImpl("align", atype, 1);
        return attr;
    }

    public static final HTMLAttrDeclImpl createAlignForParagraph() {
        HTMLCMDataTypeImpl atype = new HTMLCMDataTypeImpl("ENUM");
        String[] values = new String[]{"left", "center", "right", "justify"};
        atype.setEnumValues(values);
        HTMLAttrDeclImpl attr = new HTMLAttrDeclImpl("align", atype, 1);
        return attr;
    }

    public void getAttrs(CMNamedNodeMapImpl declarations) {
        Iterator<String> names = Arrays.asList(CORE).iterator();
        this.getDeclarations(declarations, names);
        names = Arrays.asList(I18N).iterator();
        this.getDeclarations(declarations, names);
        names = Arrays.asList(EVENTS).iterator();
        this.getDeclarations(declarations, names);
    }

    public void getBodycolors(CMNamedNodeMapImpl declarations) {
        Iterator<String> names = Arrays.asList(BODYCOLORS).iterator();
        this.getDeclarations(declarations, names);
    }

    public void getCellhalign(CMNamedNodeMapImpl declarations) {
        HTMLCMDataTypeImpl atype = new HTMLCMDataTypeImpl("ENUM");
        String[] values = new String[]{"left", "center", "right", "justify", "char"};
        atype.setEnumValues(values);
        HTMLAttrDeclImpl attr = new HTMLAttrDeclImpl("align", atype, 1);
        declarations.putNamedItem("align", attr);
        Iterator<String> names = Arrays.asList(CELLHALIGN).iterator();
        this.getDeclarations(declarations, names);
    }

    public void getCellvalign(CMNamedNodeMapImpl declarations) {
        HTMLAttributeDeclaration dec = this.getDeclaration("valign");
        if (dec != null) {
            declarations.putNamedItem("valign", (CMNode)dec);
        }
    }

    public void getCore(CMNamedNodeMapImpl declarations) {
        Iterator<String> names = Arrays.asList(CORE).iterator();
        this.getDeclarations(declarations, names);
    }

    public HTMLAttributeDeclaration getDeclaration(String attrName) {
        CMNode cmnode = this.getNamedItem(attrName);
        if (cmnode != null) {
            return (HTMLAttributeDeclaration)cmnode;
        }
        HTMLAttrDeclImpl dec = this.create(attrName);
        if (dec != null) {
            this.putNamedItem(attrName, dec);
        }
        return dec;
    }

    public void getDeclarations(CMNamedNodeMapImpl declarations, Iterator names) {
        while (names.hasNext()) {
            String attrName = (String)names.next();
            HTMLAttributeDeclaration dec = this.getDeclaration(attrName);
            if (dec == null) continue;
            declarations.putNamedItem(attrName, (CMNode)dec);
        }
    }

    public void getEvents(CMNamedNodeMapImpl declarations) {
        Iterator<String> names = Arrays.asList(EVENTS).iterator();
        this.getDeclarations(declarations, names);
    }

    public void getI18n(CMNamedNodeMapImpl declarations) {
        Iterator<String> names = Arrays.asList(I18N).iterator();
        this.getDeclarations(declarations, names);
    }

    public void createAttributeDeclarations(String elementName, CMNamedNodeMapImpl attributes) {
        if (elementName.equals("INPUT")) {
            HTMLCMDataTypeImpl atype = null;
            HTMLAttrDeclImpl attr = null;
            atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"text", "password", "checkbox", "radio", "submit", "reset", "file", "hidden", "image", "button"};
            atype.setEnumValues(values);
            atype.setImpliedValue(3, "text");
            attr = new HTMLAttrDeclImpl("type", atype, 1);
            attributes.putNamedItem("type", attr);
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("size", atype, 1);
            attributes.putNamedItem("size", attr);
            atype = new HTMLCMDataTypeImpl("CDATA");
            attr = new HTMLAttrDeclImpl("alt", atype, 1);
            attributes.putNamedItem("alt", attr);
            attr = AttributeCollection.createAlignForImage();
            attributes.putNamedItem("align", attr);
            String[] names = new String[]{"name", "value", "checked", "disabled", "readonly", "size", "maxlength", "src", "alt", "usemap", "ismap", "tabindex", "accesskey", "onfocus", "onblur", "onselect", "onchange", "accept", "align", "istyle", "width", "height", "border"};
            this.getDeclarations(attributes, Arrays.asList(names).iterator());
        } else if (elementName.equals("LINK")) {
            String[] names = new String[]{"charset", "href", "hreflang", "rel", "rev", "media", "target"};
            this.getDeclarations(attributes, Arrays.asList(names).iterator());
            HTMLCMDataTypeImpl atype = new HTMLCMDataTypeImpl("CDATA");
            HTMLAttrDeclImpl attr = new HTMLAttrDeclImpl("type", atype, 1);
            attributes.putNamedItem("type", attr);
        } else if (elementName.equals("A")) {
            String[] names = new String[]{"charset", "type", "name", "href", "hreflang", "target", "rel", "rev", "accesskey", "directkey", "shape", "coords", "tabindex", "onfocus", "onblur"};
            this.getDeclarations(attributes, Arrays.asList(names).iterator());
        } else if (elementName.equals("FORM")) {
            String[] names = new String[]{"action", "method", "enctype", "accept", "name", "onsubmit", "onreset", "target", "accept-charset"};
            this.getDeclarations(attributes, Arrays.asList(names).iterator());
        } else if (elementName.equals("AREA")) {
            String[] names = new String[]{"shape", "coords", "href", "target", "nohref", "alt", "tabindex", "accesskey", "onfocus", "onblur"};
            this.getDeclarations(attributes, Arrays.asList(names).iterator());
        } else if (elementName.equals("META")) {
            this.getI18n(attributes);
            HTMLCMDataTypeImpl atype = new HTMLCMDataTypeImpl("NAME");
            HTMLAttrDeclImpl attr = new HTMLAttrDeclImpl("name", atype, 1);
            attributes.putNamedItem("name", attr);
            String[] names = new String[]{"http-equiv", "content", "scheme"};
            this.getDeclarations(attributes, Arrays.asList(names).iterator());
        } else if (elementName.equals("IMG")) {
            HTMLCMDataTypeImpl atype = null;
            HTMLAttrDeclImpl attr = null;
            atype = new HTMLCMDataTypeImpl("URI");
            attr = new HTMLAttrDeclImpl("src", atype, 2);
            attributes.putNamedItem("src", attr);
            String[] names = new String[]{"alt", "longdesc", "name", "height", "width", "usemap", "ismap", "border", "hspace", "vspace", "mapfile"};
            this.getDeclarations(attributes, Arrays.asList(names).iterator());
            attr = AttributeCollection.createAlignForImage();
            attributes.putNamedItem("align", attr);
        } else if (elementName.equals("PARAM")) {
            String[] names = new String[]{"id", "value", "valuetype", "type"};
            this.getDeclarations(attributes, Arrays.asList(names).iterator());
            HTMLCMDataTypeImpl atype = new HTMLCMDataTypeImpl("CDATA");
            HTMLAttrDeclImpl attr = new HTMLAttrDeclImpl("name", atype, 2);
            attributes.putNamedItem("name", attr);
        } else if (elementName.equals("TEXTAREA")) {
            String[] names = new String[]{"name", "rows", "cols", "disabled", "readonly", "tabindex", "accesskey", "onfocus", "onblur", "onselect", "onchange", "istyle"};
            this.getDeclarations(attributes, Arrays.asList(names).iterator());
        } else if (elementName.equals("SCRIPT")) {
            String[] names = new String[]{"charset", "language", "src", "defer", "event", "for"};
            this.getDeclarations(attributes, Arrays.asList(names).iterator());
            HTMLCMDataTypeImpl atype = new HTMLCMDataTypeImpl("CDATA");
            atype.setImpliedValue(3, "text/javascript");
            HTMLAttrDeclImpl attr = new HTMLAttrDeclImpl("type", atype, 2);
            attributes.putNamedItem("type", attr);
        } else if (elementName.equals("STYLE")) {
            this.getI18n(attributes);
            String[] names = new String[]{"media", "title"};
            this.getDeclarations(attributes, Arrays.asList(names).iterator());
            HTMLCMDataTypeImpl atype = new HTMLCMDataTypeImpl("CDATA");
            atype.setImpliedValue(3, "text/css");
            HTMLAttrDeclImpl attr = new HTMLAttrDeclImpl("type", atype, 2);
            attributes.putNamedItem("type", attr);
        } else if (elementName.equals("SELECT")) {
            HTMLCMDataTypeImpl atype = new HTMLCMDataTypeImpl("NUMBER");
            HTMLAttrDeclImpl attr = new HTMLAttrDeclImpl("size", atype, 1);
            attributes.putNamedItem("size", attr);
            String[] names = new String[]{"name", "multiple", "disabled", "tabindex", "onfocus", "onblur", "onchange"};
            this.getDeclarations(attributes, Arrays.asList(names).iterator());
        } else if (elementName.equals("LI")) {
            HTMLCMDataTypeImpl atype = new HTMLCMDataTypeImpl("CDATA");
            HTMLAttrDeclImpl attr = new HTMLAttrDeclImpl("type", atype, 1);
            attributes.putNamedItem("type", attr);
            atype = new HTMLCMDataTypeImpl("NUMBER");
            attr = new HTMLAttrDeclImpl("value", atype, 1);
            attributes.putNamedItem("value", attr);
        } else if (elementName.equals("OL")) {
            HTMLCMDataTypeImpl atype = new HTMLCMDataTypeImpl("CDATA");
            HTMLAttrDeclImpl attr = new HTMLAttrDeclImpl("type", atype, 1);
            attributes.putNamedItem("type", attr);
            String[] names = new String[]{"compact", "start"};
            this.getDeclarations(attributes, Arrays.asList(names).iterator());
        } else if (elementName.equals("IFRAME")) {
            this.getCore(attributes);
            String[] names = new String[]{"longdesc", "name", "src", "frameborder", "marginwidth", "marginheight", "scrolling", "height", "width"};
            this.getDeclarations(attributes, Arrays.asList(names).iterator());
            HTMLAttrDeclImpl attr = AttributeCollection.createAlignForImage();
            if (attr != null) {
                attributes.putNamedItem("align", attr);
            }
        } else if (elementName.equals("HTML")) {
            this.getI18n(attributes);
            HTMLAttributeDeclaration adec = this.getDeclaration("version");
            if (adec != null) {
                attributes.putNamedItem("version", (CMNode)adec);
            }
        } else if (elementName.equals("MENU")) {
            String[] names = new String[]{"compact"};
            this.getDeclarations(attributes, Arrays.asList(names).iterator());
        } else if (elementName.equals("BUTTON")) {
            String[] names = new String[]{"name", "value", "disabled", "tabindex", "accesskey", "onfocus", "onblur"};
            this.getDeclarations(attributes, Arrays.asList(names).iterator());
            HTMLCMDataTypeImpl atype = new HTMLCMDataTypeImpl("ENUM");
            String[] values = new String[]{"button", "submit", "reset"};
            atype.setEnumValues(values);
            HTMLAttrDeclImpl attr = new HTMLAttrDeclImpl("type", atype, 1);
            attributes.putNamedItem("type", attr);
        } else if (elementName.equals("TABLE")) {
            String[] names = new String[]{"summary", "width", "border", "frame", "rules", "cellspacing", "cellpadding", "bgcolor", "datapagesize", "height", "background", "bordercolor"};
            this.getDeclarations(attributes, Arrays.asList(names).iterator());
            HTMLCMDataTypeImpl atype = new HTMLCMDataTypeImpl("ENUM");
            String[] alignValues = new String[]{"left", "center", "right"};
            atype.setEnumValues(alignValues);
            HTMLAttrDeclImpl adec = new HTMLAttrDeclImpl("align", atype, 1);
            attributes.putNamedItem("align", adec);
        }
    }
}

