/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.utils;

import net.bytebuddy.ByteBuddy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.reflect.IClassLoaderInitializer;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swt.model.widgets.SwtInvocationEvaluatorInterceptor;

public final class ResourceManagerClassLoaderInitializer
implements IClassLoaderInitializer {
    public static final IClassLoaderInitializer INSTANCE = new ResourceManagerClassLoaderInitializer();

    private ResourceManagerClassLoaderInitializer() {
    }

    public void initialize(final ClassLoader classLoader) {
        ExecutionUtils.runIgnore((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                Class<?> managerClass = classLoader.loadClass("org.eclipse.wb.swt.ResourceManager");
                Class<?> providerClass = classLoader.loadClass("org.eclipse.wb.swt.ResourceManager$PluginResourceProvider");
                ResourceManagerClassLoaderInitializer.this.initialize_ResourceManager(classLoader, managerClass, providerClass);
            }
        });
    }

    public void deinitialize(ClassLoader classLoader) {
    }

    private void initialize_ResourceManager(ClassLoader classLoader, Class<?> managerClass, Class<?> providerClass) throws Exception {
        Object provider = this.createProvider(classLoader, providerClass);
        ReflectionUtils.setField(managerClass, (String)"m_designTimePluginResourceProvider", (Object)provider);
    }

    private Object createProvider(ClassLoader classLoader, Class<?> providerClass) {
        try {
            return new ByteBuddy().subclass(providerClass).method((ElementMatcher)ElementMatchers.named((String)"getEntry")).intercept((Implementation)InvocationHandlerAdapter.of((proxy, method, args) -> {
                String symbolicName = (String)args[0];
                String fullPath = (String)args[1];
                return SwtInvocationEvaluatorInterceptor.getEntry(symbolicName, fullPath);
            })).make().load(classLoader).getLoaded().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new DesignerException(313, (Throwable)e, new String[0]);
        }
    }
}

