/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui.disassembly;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.AbstractDisassemblyBackend;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.AddressRangePosition;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.DisassemblyUtils;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.IDisassemblyBackend;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.internal.cdt.ui.Activator;
import org.eclipse.tcf.internal.debug.launch.TCFSourceLookupDirector;
import org.eclipse.tcf.internal.debug.launch.TCFSourceLookupParticipant;
import org.eclipse.tcf.internal.debug.model.TCFContextState;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.internal.debug.model.TCFSourceRef;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenStackTrace;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tcf.internal.debug.ui.model.TCFNumberFormat;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IDisassembly;
import org.eclipse.tcf.services.IExpressions;
import org.eclipse.tcf.services.ILineNumbers;
import org.eclipse.tcf.services.IMemory;
import org.eclipse.tcf.services.IMemoryMap;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.services.ISymbols;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.tcf.util.TCFTask;
import org.eclipse.ui.PlatformUI;

public class TCFDisassemblyBackend
extends AbstractDisassemblyBackend {
    private volatile boolean fSuspended;
    private volatile TCFNodeExecContext fExecContext;
    private volatile TCFNodeExecContext fMemoryContext;
    private volatile TCFNodeStackFrame fActiveFrame;
    private volatile int fSuspendCount;
    private volatile int fContextCount;
    private volatile boolean disposed;
    private final IRunControl.RunControlListener fRunControlListener = new TCFRunControlListener();
    private final IMemoryMap.MemoryMapListener fMemoryMapListener = new TCFMemoryMapListener();
    private final IChannel.IChannelListener fChannelListener = new TCFChannelListener();
    private final ILaunchesListener fLaunchesListener = new TCFLaunchListener();

    public boolean supportsDebugContext(IAdaptable context) {
        return (context instanceof TCFNodeExecContext || context instanceof TCFNodeStackFrame) && this.hasDisassemblyService((TCFNode)context);
    }

    private boolean hasDisassemblyService(final TCFNode context) {
        Boolean hasService = (Boolean)new TCFTask<Boolean>(){

            public void run() {
                IDisassembly disass = null;
                IChannel channel = context.getChannel();
                if (channel != null && channel.getState() != 2) {
                    disass = (IDisassembly)channel.getRemoteService(IDisassembly.class);
                }
                this.done(disass != null);
            }
        }.getE();
        return hasService != null && hasService != false;
    }

    public boolean hasDebugContext() {
        return this.fExecContext != null;
    }

    public IDisassemblyBackend.SetDebugContextResult setDebugContext(final IAdaptable context) {
        IDisassemblyBackend.SetDebugContextResult result;
        block10: {
            TCFNodeExecContext thread = null;
            result = new IDisassemblyBackend.SetDebugContextResult();
            if (context instanceof TCFNodeExecContext) {
                thread = (TCFNodeExecContext)context;
            } else if (context instanceof TCFNodeStackFrame) {
                thread = (TCFNodeExecContext)((TCFNodeStackFrame)context).getParent();
            }
            if (this.fExecContext != thread) {
                result.contextChanged = true;
                ++this.fContextCount;
                if (this.fExecContext != null) {
                    this.removeListeners(this.fExecContext);
                }
                this.fExecContext = thread;
                if (this.fExecContext != null) {
                    this.addListeners(this.fExecContext);
                }
            }
            this.fSuspended = false;
            this.fMemoryContext = null;
            this.fActiveFrame = null;
            if (this.fExecContext != null) {
                IChannel channel = thread.getChannel();
                try {
                    new TCFTask<Object>(this.fExecContext.getChannel()){

                        public void run() {
                            TCFDataCache mem_cache = TCFDisassemblyBackend.this.fExecContext.getMemoryNode();
                            if (!mem_cache.validate((Runnable)((Object)this))) {
                                return;
                            }
                            TCFDataCache state_cache = TCFDisassemblyBackend.this.fExecContext.getState();
                            if (!state_cache.validate((Runnable)((Object)this))) {
                                return;
                            }
                            if (context instanceof TCFNodeExecContext) {
                                TCFChildrenStackTrace stack = ((TCFNodeExecContext)context).getStackTrace();
                                if (!stack.validate((Runnable)((Object)this))) {
                                    return;
                                }
                                TCFDisassemblyBackend.this.fActiveFrame = stack.getTopFrame();
                            } else if (context instanceof TCFNodeStackFrame) {
                                TCFDisassemblyBackend.this.fActiveFrame = (TCFNodeStackFrame)context;
                            }
                            TCFContextState state_data = (TCFContextState)state_cache.getData();
                            TCFDisassemblyBackend.this.fSuspended = state_data != null && state_data.is_suspended;
                            TCFDisassemblyBackend.this.fMemoryContext = (TCFNodeExecContext)mem_cache.getData();
                            this.done(null);
                        }
                    }.getE();
                }
                catch (Error x) {
                    if (channel.getState() != 1) break block10;
                    throw x;
                }
            }
        }
        String string = result.sessionId = this.fExecContext != null ? this.fExecContext.getID() : null;
        if (!result.contextChanged && this.fActiveFrame != null) {
            this.fCallback.asyncExec(new Runnable(){

                @Override
                public void run() {
                    TCFDisassemblyBackend.this.fCallback.gotoFrameIfActive(TCFDisassemblyBackend.this.getFrameLevel());
                }
            });
        }
        return result;
    }

    private void addListeners(final TCFNodeExecContext context) {
        assert (context != null);
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                IMemoryMap mmap;
                IChannel channel = context.getChannel();
                IRunControl rctl = (IRunControl)channel.getRemoteService(IRunControl.class);
                if (rctl != null) {
                    rctl.addListener(TCFDisassemblyBackend.this.fRunControlListener);
                }
                if ((mmap = (IMemoryMap)channel.getRemoteService(IMemoryMap.class)) != null) {
                    mmap.addListener(TCFDisassemblyBackend.this.fMemoryMapListener);
                }
                channel.addChannelListener(TCFDisassemblyBackend.this.fChannelListener);
            }
        });
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener(this.fLaunchesListener);
    }

    private void removeListeners(final TCFNodeExecContext context) {
        assert (context != null);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener(this.fLaunchesListener);
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                IMemoryMap mmap;
                IChannel channel = context.getChannel();
                IRunControl rctl = (IRunControl)channel.getRemoteService(IRunControl.class);
                if (rctl != null) {
                    rctl.removeListener(TCFDisassemblyBackend.this.fRunControlListener);
                }
                if ((mmap = (IMemoryMap)channel.getRemoteService(IMemoryMap.class)) != null) {
                    mmap.removeListener(TCFDisassemblyBackend.this.fMemoryMapListener);
                }
                channel.removeChannelListener(TCFDisassemblyBackend.this.fChannelListener);
            }
        });
    }

    private void handleContextSuspended(BigInteger pc) {
        ++this.fSuspendCount;
        this.fSuspended = true;
        this.fCallback.handleTargetSuspended();
    }

    private void handleContextResumed() {
        this.fSuspended = false;
        this.fCallback.handleTargetResumed();
    }

    private void handleSessionEnded() {
        ++this.fContextCount;
        this.fCallback.handleTargetEnded();
    }

    public void clearDebugContext() {
        this.fSuspended = false;
        if (this.fExecContext != null) {
            this.removeListeners(this.fExecContext);
        }
        this.fExecContext = null;
        this.fMemoryContext = null;
        this.fActiveFrame = null;
    }

    public void retrieveFrameAddress(final int targetFrame) {
        final Request request = new Request();
        if (!request.check()) {
            return;
        }
        try {
            BigInteger address;
            BigInteger bigInteger = address = !this.fSuspended ? null : (BigInteger)new TCFTask<BigInteger>(request.ctx.getChannel()){

                public void run() {
                    if (targetFrame == 0) {
                        TCFDataCache addr = request.ctx.getAddress();
                        if (!addr.validate((Runnable)((Object)this))) {
                            return;
                        }
                        this.done((BigInteger)addr.getData());
                        return;
                    }
                    TCFChildrenStackTrace stack = request.ctx.getStackTrace();
                    if (!stack.validate((Runnable)((Object)this))) {
                        return;
                    }
                    Map frameData = (Map)stack.getData();
                    for (TCFNode node : frameData.values()) {
                        TCFNodeStackFrame frame;
                        if (!(node instanceof TCFNodeStackFrame) || (frame = (TCFNodeStackFrame)node).getFrameNo() != targetFrame) continue;
                        TCFDataCache addr = frame.getAddress();
                        if (!addr.validate((Runnable)((Object)this))) {
                            return;
                        }
                        this.done((BigInteger)addr.getData());
                        return;
                    }
                    this.done(null);
                }
            }.getE();
            if (!request.check()) {
                return;
            }
            request.done();
            if (address == null) {
                address = BigInteger.valueOf(-2L);
            }
            if (targetFrame == 0) {
                this.fCallback.updatePC(address);
            } else {
                this.fCallback.gotoFrame(targetFrame, address);
            }
        }
        catch (Throwable x) {
            request.done();
        }
    }

    public int getFrameLevel() {
        if (this.fActiveFrame == null) {
            return -1;
        }
        return (Integer)new TCFTask<Integer>(){

            public void run() {
                if (!TCFDisassemblyBackend.this.fExecContext.getStackTrace().validate((Runnable)((Object)this))) {
                    return;
                }
                this.done(TCFDisassemblyBackend.this.fActiveFrame.getFrameNo());
            }
        }.getE();
    }

    public boolean isSuspended() {
        return this.fSuspended;
    }

    public boolean hasFrameContext() {
        return this.fActiveFrame != null;
    }

    public String getFrameFile() {
        if (this.fActiveFrame == null) {
            return null;
        }
        return (String)new TCFTask<String>(this.fActiveFrame.getChannel()){

            public void run() {
                TCFDataCache sourceRefCache = TCFDisassemblyBackend.this.fActiveFrame.getLineInfo();
                if (!sourceRefCache.validate((Runnable)((Object)this))) {
                    return;
                }
                TCFSourceRef sourceRef = (TCFSourceRef)sourceRefCache.getData();
                if (sourceRef != null && sourceRef.area != null) {
                    this.done(TCFSourceLookupParticipant.toFileName((ILineNumbers.CodeArea)sourceRef.area));
                    return;
                }
                this.done(null);
            }
        }.getE();
    }

    public int getFrameLine() {
        if (this.fActiveFrame == null) {
            return -1;
        }
        return (Integer)new TCFTask<Integer>(this.fActiveFrame.getChannel()){

            public void run() {
                TCFDataCache sourceRefCache = TCFDisassemblyBackend.this.fActiveFrame.getLineInfo();
                if (!sourceRefCache.validate((Runnable)((Object)this))) {
                    return;
                }
                TCFSourceRef sourceRef = (TCFSourceRef)sourceRefCache.getData();
                if (sourceRef != null && sourceRef.area != null) {
                    this.done(sourceRef.area.start_line);
                    return;
                }
                this.done(-1);
            }
        }.getE();
    }

    public void retrieveDisassembly(final BigInteger startAddress, BigInteger endAddress, String file, int lineNumber, int lines, final boolean mixed, final boolean showSymbols, boolean showDisassembly, final int linesHint) {
        final Request request = new Request();
        Protocol.invokeLater((Runnable)new Runnable(){
            IMemory.MemoryContext mem;
            boolean big_endian;
            int addr_bits;
            IDisassembly.IDisassemblyLine[] disassembly;
            AddressRange range;
            boolean done_disassembly;
            ISymbols.Symbol[] symbol_array;
            boolean done_symbols;
            ILineNumbers.CodeArea[] code_areas;
            boolean done_line_numbers;
            byte[] code;
            boolean done_code;

            @Override
            public void run() {
                if (!request.check()) {
                    return;
                }
                IChannel channel = request.ctx.getChannel();
                IDisassembly disass = (IDisassembly)channel.getRemoteService(IDisassembly.class);
                if (disass == null) {
                    request.done();
                    return;
                }
                TCFDataCache cache = request.mem.getMemoryContext();
                if (!cache.validate((Runnable)this)) {
                    return;
                }
                this.mem = (IMemory.MemoryContext)cache.getData();
                if (this.mem == null) {
                    request.done();
                    return;
                }
                this.big_endian = this.mem.isBigEndian();
                this.addr_bits = this.mem.getAddressSize() * 8;
                int accessSize = 0;
                BigInteger mem_end = BigInteger.ONE.shiftLeft(this.addr_bits);
                mem_end = mem_end.subtract(BigInteger.ONE);
                final BigInteger requestedLineEndAddr = startAddress.add(BigInteger.valueOf(linesHint * this.mem.getAddressSize()));
                if (startAddress.compareTo(mem_end) > 0) {
                    TCFDisassemblyBackend.this.fCallback.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TCFDisassemblyBackend.this.insertEmptySpace(request, startAddress, requestedLineEndAddr);
                        }
                    });
                    return;
                }
                accessSize = requestedLineEndAddr.compareTo(mem_end) > 0 ? mem_end.subtract(startAddress).intValue() + 1 : linesHint * this.mem.getAddressSize();
                if (!this.done_disassembly) {
                    HashMap params = new HashMap();
                    disass.disassemble(this.mem.getID(), (Number)startAddress, accessSize, params, new IDisassembly.DoneDisassemble(){

                        public void doneDisassemble(IToken token, final Throwable error, IDisassembly.IDisassemblyLine[] res) {
                            if (error != null) {
                                TCFDisassemblyBackend.this.fCallback.asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        TCFDisassemblyBackend.this.insertError(request, startAddress, error);
                                        if (TCFDisassemblyBackend.this.fCallback.getAddressSize() < addr_bits) {
                                            TCFDisassemblyBackend.this.fCallback.addressSizeChanged(addr_bits);
                                        }
                                    }
                                });
                                return;
                            }
                            if (res != null && res.length > 0) {
                                disassembly = res;
                                range = new AddressRange();
                                range.start = JSON.toBigInteger((Number)res[0].getAddress());
                                IDisassembly.IDisassemblyLine last = res[res.length - 1];
                                range.end = JSON.toBigInteger((Number)last.getAddress()).add(BigInteger.valueOf(last.getSize()));
                            }
                            done_disassembly = true;
                            this.run();
                        }
                    });
                    return;
                }
                if (!(this.done_symbols || this.range != null && showSymbols)) {
                    this.done_symbols = true;
                }
                if (!this.done_symbols) {
                    final ISymbols symbols = (ISymbols)channel.getRemoteService(ISymbols.class);
                    if (symbols == null) {
                        this.done_symbols = true;
                    } else {
                        final ArrayList symbol_list = new ArrayList();
                        IDisassembly.IDisassemblyLine line = this.disassembly[0];
                        symbols.findByAddr(this.mem.getID(), line.getAddress(), new ISymbols.DoneFind(){
                            int idx = 0;

                            public void doneFind(IToken token, Exception error, String symbol_id) {
                                if (error == null && symbol_id != null) {
                                    symbols.getContext(symbol_id, new ISymbols.DoneGetContext(){

                                        public void doneGetContext(IToken token, Exception error, ISymbols.Symbol context) {
                                            BigInteger nextAddress = null;
                                            if (error == null && context != null && context.getTypeClass().equals((Object)ISymbols.TypeClass.function) && context.getAddress() != null && context.getSize() >= 0) {
                                                symbol_list.add(context);
                                                nextAddress = JSON.toBigInteger((Number)context.getAddress()).add(BigInteger.valueOf(context.getSize()));
                                            }
                                            this.findNextSymbol(nextAddress);
                                        }
                                    });
                                    return;
                                }
                                this.findNextSymbol(null);
                            }

                            private void findNextSymbol(BigInteger nextAddress) {
                                while (++this.idx < disassembly.length) {
                                    BigInteger instrAddress = JSON.toBigInteger((Number)disassembly[this.idx].getAddress());
                                    if (nextAddress != null && instrAddress.compareTo(nextAddress) < 0) continue;
                                    symbols.findByAddr(mem.getID(), (Number)instrAddress, (ISymbols.DoneFind)this);
                                    return;
                                }
                                symbol_array = symbol_list.toArray(new ISymbols.Symbol[symbol_list.size()]);
                                done_symbols = true;
                                this.run();
                            }
                        });
                        return;
                    }
                }
                if (!(this.done_line_numbers || this.range != null && mixed)) {
                    this.done_line_numbers = true;
                }
                if (!this.done_line_numbers) {
                    ILineNumbers lineNumbers = (ILineNumbers)channel.getRemoteService(ILineNumbers.class);
                    if (lineNumbers == null) {
                        this.done_line_numbers = true;
                    } else {
                        lineNumbers.mapToSource(this.mem.getID(), (Number)this.range.start, (Number)this.range.end, new ILineNumbers.DoneMapToSource(){

                            public void doneMapToSource(IToken token, Exception error, ILineNumbers.CodeArea[] areas) {
                                if (error != null) {
                                    Activator.log(error);
                                } else {
                                    code_areas = areas;
                                }
                                done_line_numbers = true;
                                this.run();
                            }
                        });
                        return;
                    }
                }
                if (!this.done_code && this.range == null) {
                    this.done_code = true;
                }
                if (!this.done_code) {
                    this.code = new byte[this.range.end.subtract(this.range.start).intValue()];
                    this.mem.get((Number)this.range.start, 1, this.code, 0, this.code.length, 0, new IMemory.DoneMemory(){

                        public void doneMemory(IToken token, IMemory.MemoryError error) {
                            done_code = true;
                            this.run();
                        }
                    });
                    return;
                }
                TCFDisassemblyBackend.this.fCallback.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TCFDisassemblyBackend.this.insertDisassembly(request, startAddress, code, range, big_endian, disassembly, symbol_array, code_areas);
                        if (TCFDisassemblyBackend.this.fCallback.getAddressSize() < addr_bits) {
                            TCFDisassemblyBackend.this.fCallback.addressSizeChanged(addr_bits);
                        }
                    }
                });
            }
        });
    }

    private long getModCount() {
        return ((IDocumentExtension4)this.fCallback.getDocument()).getModificationStamp();
    }

    /*
     * Exception decompiling
     */
    protected final void insertDisassembly(Request request, BigInteger startAddress, byte[] code, AddressRange range, boolean big_endian, IDisassembly.IDisassemblyLine[] instructions, ISymbols.Symbol[] symbols, ILineNumbers.CodeArea[] codeAreas) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void insertError(Request request, BigInteger address, Throwable error) {
        if (!request.check()) {
            return;
        }
        this.fCallback.lockScroller();
        this.fCallback.insertError(address, TCFModel.getErrorMessage((Throwable)error, (boolean)false));
        request.done();
        this.fCallback.unlockScroller();
        this.fCallback.doPending();
        this.fCallback.updateVisibleArea();
        request.ctx.getModel().updateAnnotations(this.fCallback.getSite().getWorkbenchWindow());
    }

    private void insertEmptySpace(Request request, BigInteger startAddress, BigInteger endAddress) {
        if (!request.check()) {
            return;
        }
        try {
            try {
                this.fCallback.lockScroller();
                do {
                    AddressRangePosition p;
                    if ((p = this.fCallback.getPositionOfAddress(startAddress)) == null || p.fValid || !p.containsAddress(startAddress)) continue;
                    this.fCallback.getDocument().insertDisassemblyLine(p, startAddress, 1, "", " ", null, 0);
                } while ((startAddress = startAddress.add(BigInteger.ONE)).compareTo(endAddress) < 0);
            }
            catch (BadLocationException e) {
                DisassemblyUtils.internalError((Throwable)e);
                request.done();
                this.fCallback.unlockScroller();
                this.fCallback.doPending();
                this.fCallback.updateVisibleArea();
            }
        }
        finally {
            request.done();
            this.fCallback.unlockScroller();
            this.fCallback.doPending();
            this.fCallback.updateVisibleArea();
        }
    }

    private FunctionOffset getFunctionOffset(BigInteger address, ISymbols.Symbol[] symbols) {
        if (symbols != null) {
            ISymbols.Symbol[] symbolArray = symbols;
            int n = symbols.length;
            int n2 = 0;
            while (n2 < n) {
                ISymbols.Symbol symbol = symbolArray[n2];
                if (symbol.getAddress() != null) {
                    BigInteger symbolAddress = JSON.toBigInteger((Number)symbol.getAddress());
                    BigInteger offset = address.subtract(symbolAddress);
                    switch (offset.compareTo(BigInteger.ZERO)) {
                        case 0: {
                            return new FunctionOffset(symbol.getName(), BigInteger.ZERO);
                        }
                        case 1: {
                            if (offset.compareTo(BigInteger.valueOf(symbol.getSize())) >= 0) break;
                            return new FunctionOffset(symbol.getName(), offset);
                        }
                    }
                }
                ++n2;
            }
        }
        return FunctionOffset.NONE;
    }

    private ILineNumbers.CodeArea findCodeArea(BigInteger address, ILineNumbers.CodeArea[] codeAreas) {
        if (codeAreas != null) {
            ILineNumbers.CodeArea[] codeAreaArray = codeAreas;
            int n = codeAreas.length;
            int n2 = 0;
            while (n2 < n) {
                ILineNumbers.CodeArea codeArea = codeAreaArray[n2];
                if (address.equals(JSON.toBigInteger((Number)codeArea.start_address))) {
                    return codeArea;
                }
                ++n2;
            }
        }
        return null;
    }

    private String formatInstruction(Map<String, Object>[] instrAttrs) {
        StringBuilder buf = new StringBuilder(20);
        Map<String, Object>[] mapArray = instrAttrs;
        int n = instrAttrs.length;
        int n2 = 0;
        while (n2 < n) {
            Object type;
            Map<String, Object> attrs = mapArray[n2];
            if (buf.length() > 0) {
                buf.append(' ');
            }
            if ("String".equals(type = attrs.get("Type")) || "Register".equals(type)) {
                Object text = attrs.get("Text");
                buf.append(text);
            } else {
                Object value = attrs.get("Value");
                BigInteger bigValue = new BigInteger(value.toString());
                buf.append("0x").append(bigValue.toString(16));
            }
            ++n2;
        }
        return buf.toString();
    }

    public void gotoSymbol(final String symbol) {
        final TCFNodeStackFrame activeFrame = this.fActiveFrame;
        if (activeFrame == null) {
            return;
        }
        Protocol.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (activeFrame != TCFDisassemblyBackend.this.fActiveFrame) {
                    return;
                }
                IChannel channel = activeFrame.getChannel();
                final IExpressions exprSvc = (IExpressions)channel.getRemoteService(IExpressions.class);
                if (exprSvc != null) {
                    TCFNodeStackFrame evalContext = activeFrame.isEmulated() ? activeFrame.getParent() : activeFrame;
                    exprSvc.create(evalContext.getID(), null, symbol, new IExpressions.DoneCreate(){

                        public void doneCreate(IToken token, Exception error, final IExpressions.Expression context) {
                            if (error == null) {
                                exprSvc.evaluate(context.getID(), new IExpressions.DoneEvaluate(){

                                    public void doneEvaluate(IToken token, Exception error, IExpressions.Value value) {
                                        if (error == null && value.getValue() != null) {
                                            final BigInteger address = TCFNumberFormat.toBigInteger((byte[])value.getValue(), (boolean)value.isBigEndian(), (boolean)false);
                                            TCFDisassemblyBackend.this.fCallback.asyncExec(new Runnable(){

                                                @Override
                                                public void run() {
                                                    TCFDisassemblyBackend.this.fCallback.gotoAddress(address);
                                                }
                                            });
                                        } else {
                                            this.handleError(error);
                                        }
                                        exprSvc.dispose(context.getID(), new IExpressions.DoneDispose(){

                                            public void doneDispose(IToken token, Exception error) {
                                            }
                                        });
                                    }
                                });
                            } else {
                                this.handleError(error);
                            }
                        }
                    });
                }
            }

            protected void handleError(final Exception error) {
                TCFDisassemblyBackend.this.fCallback.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Status status = new Status(4, "org.eclipse.tcf.cdt.ui", error.getLocalizedMessage(), (Throwable)error);
                        ErrorDialog.openError((Shell)TCFDisassemblyBackend.this.fCallback.getSite().getShell(), (String)"Error", null, (IStatus)status);
                    }
                });
            }
        });
    }

    public void retrieveDisassembly(String file, int lines, BigInteger endAddress, boolean mixed, boolean showSymbols, boolean showDisassembly) {
        Request request = new Request();
        request.done();
    }

    public String evaluateExpression(final String expression) {
        if (this.fActiveFrame == null) {
            return null;
        }
        String value = (String)new TCFTask<String>(this.fActiveFrame.getChannel()){

            public void run() {
                IChannel channel = TCFDisassemblyBackend.this.fActiveFrame.getChannel();
                final IExpressions exprSvc = (IExpressions)channel.getRemoteService(IExpressions.class);
                if (exprSvc != null) {
                    TCFNodeStackFrame evalContext = TCFDisassemblyBackend.this.fActiveFrame.isEmulated() ? TCFDisassemblyBackend.this.fActiveFrame.getParent() : TCFDisassemblyBackend.this.fActiveFrame;
                    exprSvc.create(evalContext.getID(), null, expression, new IExpressions.DoneCreate(){

                        public void doneCreate(IToken token, Exception error, final IExpressions.Expression context) {
                            if (error == null) {
                                exprSvc.evaluate(context.getID(), new IExpressions.DoneEvaluate(){

                                    public void doneEvaluate(IToken token, Exception error, IExpressions.Value value) {
                                        if (error == null && value.getValue() != null) {
                                            BigInteger address = TCFNumberFormat.toBigInteger((byte[])value.getValue(), (boolean)value.isBigEndian(), (boolean)false);
                                            this.done("0x" + address.toString(16));
                                        } else {
                                            this.done(null);
                                        }
                                        exprSvc.dispose(context.getID(), new IExpressions.DoneDispose(){

                                            public void doneDispose(IToken token, Exception error) {
                                            }
                                        });
                                    }
                                });
                            } else {
                                this.done(null);
                            }
                        }
                    });
                } else {
                    this.done(null);
                }
            }
        }.getE();
        return value;
    }

    public void dispose() {
        this.disposed = true;
    }

    public Object insertSource(Position pos, BigInteger address, String file, int lineNumber) {
        TCFNodeExecContext ctx = this.fMemoryContext;
        if (ctx == null) {
            return null;
        }
        return TCFSourceLookupDirector.lookup((TCFLaunch)ctx.getModel().getLaunch(), (String)ctx.getID(), (Object)file);
    }

    public BigInteger evaluateAddressExpression(String expression, boolean suppressError) {
        block3: {
            String value = this.evaluateExpression(expression);
            if (value != null) {
                try {
                    return DisassemblyUtils.decodeAddress((String)value);
                }
                catch (NumberFormatException e) {
                    if (suppressError) break block3;
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Error", (String)"Expression does not evaluate to an address");
                }
            }
        }
        return null;
    }

    private static class AddressRange {
        BigInteger start;
        BigInteger end;

        private AddressRange() {
        }
    }

    private static class FunctionOffset {
        static final FunctionOffset NONE = new FunctionOffset(null, null);
        String name;
        BigInteger offset;

        FunctionOffset(String name, BigInteger offset) {
            this.name = name;
            this.offset = offset;
        }

        public String toString() {
            if (this.name == null || this.name.length() == 0) {
                return "";
            }
            if (this.isZeroOffset()) {
                return this.name;
            }
            return String.valueOf(this.name) + '+' + this.offset.toString();
        }

        boolean isZeroOffset() {
            return this.offset == null || this.offset.compareTo(BigInteger.ZERO) == 0;
        }
    }

    private class Request {
        final TCFNodeExecContext ctx;
        final TCFNodeExecContext mem;
        final int suspend_cnt;
        final int context_cnt;
        final long doc_mod_cnt;
        boolean done;

        Request() {
            this.ctx = TCFDisassemblyBackend.this.fExecContext;
            this.mem = TCFDisassemblyBackend.this.fMemoryContext;
            this.suspend_cnt = TCFDisassemblyBackend.this.fSuspendCount;
            this.context_cnt = TCFDisassemblyBackend.this.fContextCount;
            this.doc_mod_cnt = TCFDisassemblyBackend.this.getModCount();
            assert (TCFDisassemblyBackend.this.fCallback.getUpdatePending());
        }

        private boolean check() {
            boolean ok;
            boolean bl = ok = !this.done && !TCFDisassemblyBackend.this.disposed && TCFDisassemblyBackend.this.fExecContext != null && TCFDisassemblyBackend.this.fMemoryContext != null && this.ctx == TCFDisassemblyBackend.this.fExecContext && this.mem == TCFDisassemblyBackend.this.fMemoryContext && this.suspend_cnt == TCFDisassemblyBackend.this.fSuspendCount && this.context_cnt == TCFDisassemblyBackend.this.fContextCount;
            if (ok) {
                if (Protocol.isDispatchThread()) {
                    ok = !this.ctx.isDisposed() && !this.mem.isDisposed();
                } else {
                    boolean bl2 = ok = this.doc_mod_cnt == TCFDisassemblyBackend.this.getModCount() && TCFDisassemblyBackend.this.fCallback.hasViewer();
                }
            }
            if (ok) {
                return true;
            }
            this.done();
            return false;
        }

        private void done() {
            if (Protocol.isDispatchThread()) {
                TCFDisassemblyBackend.this.fCallback.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Request.this.done();
                    }
                });
            } else if (!this.done) {
                this.done = true;
                if (!TCFDisassemblyBackend.this.fCallback.getUpdatePending()) {
                    return;
                }
                TCFDisassemblyBackend.this.fCallback.setUpdatePending(false);
            }
        }
    }

    private class TCFChannelListener
    implements IChannel.IChannelListener {
        private TCFChannelListener() {
        }

        public void onChannelOpened() {
        }

        public void onChannelClosed(Throwable error) {
            TCFDisassemblyBackend.this.handleSessionEnded();
        }

        public void congestionLevel(int level) {
        }
    }

    private class TCFLaunchListener
    implements ILaunchesListener {
        private TCFLaunchListener() {
        }

        public void launchesRemoved(ILaunch[] launches) {
        }

        public void launchesAdded(ILaunch[] launches) {
        }

        public void launchesChanged(ILaunch[] launches) {
            if (TCFDisassemblyBackend.this.fExecContext == null) {
                return;
            }
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                if (launch == TCFDisassemblyBackend.this.fExecContext.getModel().getLaunch()) {
                    if (!launch.isTerminated()) break;
                    TCFDisassemblyBackend.this.handleSessionEnded();
                    break;
                }
                ++n2;
            }
        }
    }

    private class TCFMemoryMapListener
    implements IMemoryMap.MemoryMapListener {
        private TCFMemoryMapListener() {
        }

        public void changed(String context_id) {
            if (TCFDisassemblyBackend.this.fMemoryContext == null) {
                return;
            }
            if (!TCFDisassemblyBackend.this.fMemoryContext.getID().equals(context_id)) {
                return;
            }
            if (TCFDisassemblyBackend.this.fCallback == null) {
                return;
            }
            try {
                TCFDisassemblyBackend.this.fCallback.getClass().getMethod("refresh", new Class[0]).invoke((Object)TCFDisassemblyBackend.this.fCallback, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class TCFRunControlListener
    implements IRunControl.RunControlListener {
        private TCFRunControlListener() {
        }

        public void contextAdded(IRunControl.RunControlContext[] contexts) {
        }

        public void contextChanged(IRunControl.RunControlContext[] contexts) {
        }

        public void contextRemoved(String[] context_ids) {
            String id = TCFDisassemblyBackend.this.fExecContext.getID();
            String[] stringArray = context_ids;
            int n = context_ids.length;
            int n2 = 0;
            while (n2 < n) {
                String contextId = stringArray[n2];
                if (id.equals(contextId)) {
                    TCFDisassemblyBackend.this.fCallback.handleTargetEnded();
                    return;
                }
                ++n2;
            }
        }

        public void contextSuspended(String context, String pc, String reason, Map<String, Object> params) {
            if (TCFDisassemblyBackend.this.fExecContext.getID().equals(context)) {
                TCFDisassemblyBackend.this.handleContextSuspended(pc != null ? new BigInteger(pc) : null);
            }
        }

        public void contextResumed(String context) {
            if (TCFDisassemblyBackend.this.fExecContext.getID().equals(context)) {
                TCFDisassemblyBackend.this.handleContextResumed();
            }
        }

        public void containerSuspended(String context, String pc, String reason, Map<String, Object> params, String[] suspended_ids) {
            String id = TCFDisassemblyBackend.this.fExecContext.getID();
            if (id.equals(context)) {
                TCFDisassemblyBackend.this.handleContextSuspended(pc != null ? new BigInteger(pc) : null);
                return;
            }
            String[] stringArray = suspended_ids;
            int n = suspended_ids.length;
            int n2 = 0;
            while (n2 < n) {
                String contextId = stringArray[n2];
                if (id.equals(contextId)) {
                    TCFDisassemblyBackend.this.handleContextSuspended(null);
                    return;
                }
                ++n2;
            }
        }

        public void containerResumed(String[] context_ids) {
            String id = TCFDisassemblyBackend.this.fExecContext.getID();
            String[] stringArray = context_ids;
            int n = context_ids.length;
            int n2 = 0;
            while (n2 < n) {
                String contextId = stringArray[n2];
                if (id.equals(contextId)) {
                    TCFDisassemblyBackend.this.handleContextResumed();
                    return;
                }
                ++n2;
            }
        }

        public void contextException(String context, String msg) {
        }
    }
}

