/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library.string;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.library.AbstractSimpleTernaryOperation;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class StringSubstituteFirstOperation
extends AbstractSimpleTernaryOperation {
    public static final @NonNull StringSubstituteFirstOperation INSTANCE = new StringSubstituteFirstOperation();

    @Override
    public @NonNull String evaluate(@Nullable Object sourceValue, @Nullable Object firstArgumentValue, @Nullable Object secondArgumentValue) {
        String sourceString = StringSubstituteFirstOperation.asString(sourceValue);
        String oldSubstring = StringSubstituteFirstOperation.asString(firstArgumentValue);
        String newSubstring = StringSubstituteFirstOperation.asString(secondArgumentValue);
        int index = sourceString.indexOf(oldSubstring);
        if (index < 0) {
            throw new InvalidValueException(PivotMessages.MissingSubstring, oldSubstring, sourceString);
        }
        return String.valueOf(sourceString.substring(0, index)) + newSubstring + sourceString.substring(index + oldSubstring.length(), sourceString.length());
    }
}

