/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.efacet.ui.internal.widget;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.modisco.facet.util.core.internal.exported.IFilter;

public class ETypedElementSelectionControlContentProvider
implements ITreeContentProvider {
    private final IFilter<EObject> childrenFilter;
    private Object input;

    public ETypedElementSelectionControlContentProvider(IFilter<EObject> childrenFilter) {
        this.childrenFilter = childrenFilter;
    }

    public Object[] getElements(Object inputElement) {
        Collection containers = (Collection)inputElement;
        return containers.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children;
        if (parentElement instanceof EObject) {
            EObject container = (EObject)parentElement;
            List<EObject> filteredChildren = this.computeFilteredChildren(container);
            children = filteredChildren.toArray();
        } else {
            children = new Object[]{};
        }
        return children;
    }

    public Object getParent(Object element) {
        EObject parent = null;
        if (element instanceof EObject) {
            parent = ((EObject)element).eContainer();
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        Collection rootElements = (Collection)this.input;
        boolean result = rootElements.contains(element) ? true : (element instanceof EObject ? this.getChildren(element).length > 0 : false);
        return result;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.input = newInput;
    }

    public void dispose() {
    }

    protected List<EObject> computeFilteredChildren(EObject parentEObject) {
        ArrayList children = new ArrayList();
        EList eContents = parentEObject.eContents();
        children.addAll(eContents);
        ArrayList<EObject> filteredChildren = new ArrayList<EObject>();
        for (EObject eObject : children) {
            if (!this.childrenFilter.filter((Object)eObject)) continue;
            filteredChildren.add(eObject);
        }
        return filteredChildren;
    }
}

