/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.javaee.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EjbRefType implements Enumerator
{
    ENTITY_LITERAL(0, "Entity", "Entity"),
    SESSION_LITERAL(1, "Session", "Session");

    public static final int ENTITY = 0;
    public static final int SESSION = 1;
    private static final EjbRefType[] VALUES_ARRAY;
    public static final List<EjbRefType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EjbRefType[]{ENTITY_LITERAL, SESSION_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EjbRefType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EjbRefType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EjbRefType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EjbRefType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EjbRefType get(int value) {
        switch (value) {
            case 0: {
                return ENTITY_LITERAL;
            }
            case 1: {
                return SESSION_LITERAL;
            }
        }
        return null;
    }

    private EjbRefType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

