/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.zest.fx.parts;

import java.util.Set;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.text.Text;
import org.eclipse.gef.mvc.fx.parts.AbstractFeedbackPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.zest.fx.models.HidingModel;
import org.eclipse.gef.zest.fx.parts.NodePart;

public class HiddenNeighborsFeedbackPart
extends AbstractFeedbackPart<Group> {
    private Circle circle;
    private Text text;

    protected void doAttachToAnchorageVisual(IVisualPart<? extends Node> anchorage, String role) {
        super.doAttachToAnchorageVisual(anchorage, role);
        ((Group)this.getVisual()).visibleProperty().bind((ObservableValue)anchorage.getVisual().visibleProperty());
    }

    protected Group doCreateVisual() {
        Group visual = new Group();
        visual.setAutoSizeChildren(false);
        this.circle = new Circle(10.0);
        this.circle.setFill((Paint)Color.RED);
        this.circle.setStroke((Paint)Color.BLACK);
        this.text = new Text("0");
        visual.getChildren().addAll((Object[])new Node[]{this.circle, this.text});
        return visual;
    }

    protected void doDetachFromAnchorageVisual(IVisualPart<? extends Node> anchorage, String role) {
        super.doDetachFromAnchorageVisual(anchorage, role);
        ((Group)this.getVisual()).visibleProperty().unbind();
    }

    protected void doRefreshVisual(Group visual) {
        Set keySet = this.getAnchoragesUnmodifiable().keySet();
        if (keySet.isEmpty()) {
            return;
        }
        IVisualPart anchorage = (IVisualPart)keySet.iterator().next();
        if (((NodePart)anchorage).getContent() == null) {
            return;
        }
        Bounds anchorageLayoutBoundsInLocal = ((Group)this.getVisual()).sceneToLocal(anchorage.getVisual().localToScene(anchorage.getVisual().getLayoutBounds()));
        double x = anchorageLayoutBoundsInLocal.getMaxX();
        double y = anchorageLayoutBoundsInLocal.getMaxY();
        this.circle.setCenterX(x);
        this.circle.setCenterY(y);
        HidingModel hidingModel = (HidingModel)this.getViewer().getAdapter(HidingModel.class);
        int count = hidingModel.getHiddenNeighbors(((NodePart)anchorage).getContent()).size();
        this.text.setText(Integer.toString(count));
        Bounds textLayoutBounds = this.text.getLayoutBounds();
        double size = textLayoutBounds.getWidth();
        if (textLayoutBounds.getHeight() > size) {
            size = textLayoutBounds.getHeight();
        }
        this.circle.setRadius(size / 2.0);
        this.text.relocate(x - textLayoutBounds.getWidth() / 2.0, y - textLayoutBounds.getHeight() / 2.0);
    }
}

