/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.quickfix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.dot.internal.language.htmllabel.DotHtmlLabelHelper;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlAttr;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlTag;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;

public class DotHtmlLabelQuickfixProvider
extends DefaultQuickfixProvider {
    @Fix(value="html_tag_is_not_properly_closed")
    public void fixInvalidTagName(Issue issue, IssueResolutionAcceptor acceptor) {
        String[] issueData = issue.getData();
        final String openingTagName = issueData[2];
        final String closingTagName = issueData[3];
        String label = "Change the opening tag to '" + closingTagName + "'.";
        String description = "Change the opening tag from '" + openingTagName + "' to '" + closingTagName + "'.";
        acceptor.accept(issue, label, description, null, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                if (element instanceof HtmlTag) {
                    HtmlTag htmlTag = (HtmlTag)element;
                    htmlTag.setName(closingTagName);
                }
            }
        });
        label = "Change the closing tag to '" + openingTagName + "'.";
        description = "Change the closing tag from '" + closingTagName + "' to '" + openingTagName + "'.";
        acceptor.accept(issue, label, description, null, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                if (element instanceof HtmlTag) {
                    HtmlTag htmlTag = (HtmlTag)element;
                    htmlTag.setCloseName(openingTagName);
                }
            }
        });
    }

    @Fix(value="html_attribute_invalid_attribute_name")
    public void fixInvalidAttributeName(Issue issue, IssueResolutionAcceptor acceptor) {
        String[] issueData = issue.getData();
        String tagName = issueData[2];
        String invalidAttribute = issueData[3];
        Set validAttributes = (Set)DotHtmlLabelHelper.getValidAttributes().get(tagName.toUpperCase());
        ArrayList validAttributesSorted = new ArrayList(validAttributes);
        Collections.sort(validAttributesSorted);
        for (final String validAttribute : validAttributesSorted) {
            String label = "Change to '" + validAttribute + "'.";
            String description = "Change '" + invalidAttribute + "' to '" + validAttribute + "'.";
            acceptor.accept(issue, label, description, null, new ISemanticModification(){

                public void apply(EObject element, IModificationContext context) throws Exception {
                    if (element instanceof HtmlAttr) {
                        HtmlAttr htmlAttr = (HtmlAttr)element;
                        htmlAttr.setName(validAttribute);
                    }
                }
            });
        }
    }
}

