/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.common.adapt.inject;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.gef.common.adapt.IAdaptable;
import org.eclipse.gef.common.adapt.inject.AdaptableScope;

public class AdaptableScopes {
    private static final Map<Class<? extends IAdaptable>, AdaptableScope<? extends IAdaptable>> scopes = new HashMap<Class<? extends IAdaptable>, AdaptableScope<? extends IAdaptable>>();
    private static final Stack<IAdaptable> history = new Stack();

    static void enter(IAdaptable adaptable) {
        if (adaptable == null) {
            throw new IllegalArgumentException("The given IAdaptable may not be null.");
        }
        history.push(adaptable);
        AdaptableScopes.processEnter(adaptable);
    }

    static void leave(IAdaptable adaptable) {
        if (adaptable == null) {
            throw new IllegalArgumentException("The given IAdaptable may not be null.");
        }
        if (history.pop() != adaptable) {
            throw new IllegalArgumentException("Only last entered scope may be left");
        }
        AdaptableScopes.processLeave(adaptable);
        if (!history.isEmpty()) {
            AdaptableScopes.processEnter(history.peek());
        }
    }

    private static void process(Class<? extends IAdaptable> adaptableType, IAdaptable adaptableInstance, ScopeProcessor processor) {
        processor.process(adaptableType, adaptableInstance);
        if (adaptableType.getSuperclass() != null && IAdaptable.class.isAssignableFrom(adaptableType.getSuperclass())) {
            AdaptableScopes.process(adaptableType.getSuperclass(), adaptableInstance, processor);
        }
        Class<?>[] classArray = adaptableType.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interfaceType = classArray[n2];
            if (IAdaptable.class.isAssignableFrom(interfaceType)) {
                AdaptableScopes.process(interfaceType, adaptableInstance, processor);
            }
            ++n2;
        }
    }

    private static void processEnter(IAdaptable adaptable) {
        Object boundTo;
        if (adaptable instanceof IAdaptable.Bound && (boundTo = ((IAdaptable.Bound)((Object)adaptable)).getAdaptable()) != null) {
            AdaptableScopes.processEnter(boundTo);
        }
        AdaptableScopes.process(adaptable.getClass(), adaptable, new ScopeProcessor(){

            @Override
            public void process(Class<? extends IAdaptable> adaptableType, IAdaptable adaptableInstance) {
                AdaptableScopes.typed(adaptableType).enter(adaptableInstance);
            }
        });
    }

    private static void processLeave(IAdaptable adaptable) {
        Object boundTo;
        AdaptableScopes.process(adaptable.getClass(), adaptable, new ScopeProcessor(){

            @Override
            public void process(Class<? extends IAdaptable> adaptableType, IAdaptable adaptableInstance) {
                AdaptableScopes.typed(adaptableType).leave(adaptableInstance);
            }
        });
        if (adaptable instanceof IAdaptable.Bound && (boundTo = ((IAdaptable.Bound)((Object)adaptable)).getAdaptable()) != null) {
            AdaptableScopes.processLeave(boundTo);
        }
    }

    public static <A extends IAdaptable> AdaptableScope<A> typed(Class<? extends A> type) {
        AdaptableScope<? extends IAdaptable> scope = scopes.get(type);
        if (scope == null) {
            scope = new AdaptableScope<IAdaptable>(type);
            scopes.put(type, scope);
        }
        return scope;
    }

    private AdaptableScopes() {
    }

    private static interface ScopeProcessor {
        public void process(Class<? extends IAdaptable> var1, IAdaptable var2);
    }
}

