/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.generator;

import com.google.inject.Inject;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xcore.XClass;
import org.eclipse.emf.ecore.xcore.mappings.XcoreMapper;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.compiler.XbaseCompiler;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class XcoreCompiler
extends XbaseCompiler {
    private static final String REASSIGNED_THIS_IN_LAMBDA = "!reassigned_this_for_lambda!";
    @Inject
    XcoreMapper mappings;

    protected void reassignThisInClosure(ITreeAppendable b, JvmType rawClosureType) {
        boolean registerClosureAsThis = rawClosureType instanceof JvmGenericType;
        boolean isAlreadyInALambda = b.hasObject(REASSIGNED_THIS_IN_LAMBDA);
        if (b.hasObject("this") && !isAlreadyInALambda) {
            Object element = b.getObject("this");
            if (element instanceof JvmType) {
                String proposedName = "<%this%>";
                if (!b.hasObject("<%this%>")) {
                    Object superElement;
                    b.declareSyntheticVariable(element, "<%this%>");
                    if (b.hasObject("super") && (superElement = b.getObject("super")) instanceof JvmType) {
                        b.declareSyntheticVariable(superElement, "<%super%>");
                    }
                }
            } else {
                registerClosureAsThis = false;
            }
        }
        if (!isAlreadyInALambda) {
            b.declareSyntheticVariable((Object)REASSIGNED_THIS_IN_LAMBDA, REASSIGNED_THIS_IN_LAMBDA);
        }
        if (registerClosureAsThis) {
            b.declareVariable((Object)rawClosureType, "this");
        }
    }

    protected void serialize(JvmTypeReference type, EObject context, ITreeAppendable appendable, boolean withoutConstraints, boolean paramsToWildcard, boolean paramsToObject, boolean allowPrimitives) {
        JvmTypeReference superType;
        GenClass genClass;
        JvmType referencedType;
        EObject xcoreElement;
        JvmParameterizedTypeReference jvmParameterizedTypeReference;
        if (type instanceof JvmParameterizedTypeReference && (jvmParameterizedTypeReference = (JvmParameterizedTypeReference)type).getArguments().isEmpty() && (xcoreElement = this.mappings.getXcoreElement((EObject)(referencedType = jvmParameterizedTypeReference.getType()))) instanceof XClass && (genClass = (GenClass)this.mappings.getGen((XClass)xcoreElement)) != null && genClass.isExternalInterface() && (superType = (JvmTypeReference)IterableExtensions.head((Iterable)((JvmGenericType)referencedType).getSuperTypes())) != null) {
            this.serialize(superType, context, appendable, withoutConstraints, paramsToWildcard, paramsToObject, allowPrimitives);
            return;
        }
        super.serialize(type, context, appendable, withoutConstraints, paramsToWildcard, paramsToObject, allowPrimitives);
    }
}

