/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.DBStore;
import org.eclipse.emf.cdo.server.internal.db.mapping.CoreTypeMappings;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class UUIDHandler
extends Lifecycle
implements IIDHandler {
    public static final Set<CDOID.ObjectType> OBJECT_ID_TYPES = Collections.singleton(CDOID.ObjectType.UUID);
    private static final char NULL_CHAR = '0';
    private static final String NULL_STRING = Character.toString('0');
    private static final char INTERNAL_CHAR = '@';
    private static final String INTERNAL_STRING = Character.toString('@');
    private DBStore store;

    public UUIDHandler(DBStore store) {
        this.store = store;
    }

    @Override
    public DBStore getStore() {
        return this.store;
    }

    @Override
    public int compare(CDOID id1, CDOID id2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DBType getDBType() {
        return DBType.VARCHAR;
    }

    @Override
    public Set<CDOID.ObjectType> getObjectIDTypes() {
        return OBJECT_ID_TYPES;
    }

    @Override
    public CDOID createCDOID(String val) {
        return UUIDHandler.create(String.valueOf(INTERNAL_STRING) + val);
    }

    @Override
    public synchronized CDOID getLastObjectID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void setLastObjectID(CDOID lastObjectID) {
    }

    @Override
    public void adjustLastObjectID(CDOID maxID) {
    }

    @Override
    public synchronized CDOID getNextLocalObjectID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void setNextLocalObjectID(CDOID nextLocalObjectID) {
    }

    @Override
    public synchronized CDOID getNextCDOID(CDORevision revision) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean isLocalCDOID(CDOID id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ITypeMapping getObjectTypeMapping() {
        return new CoreTypeMappings.TMObject();
    }

    @Override
    public void appendCDOID(StringBuilder builder, CDOID id) {
        builder.append("'");
        builder.append(UUIDHandler.value(id));
        builder.append("'");
    }

    @Override
    public void setCDOIDRaw(PreparedStatement stmt, int column, Object rawID) throws SQLException {
        stmt.setString(column, (String)rawID);
    }

    @Override
    public void setCDOID(PreparedStatement stmt, int column, CDOID id) throws SQLException {
        this.setCDOID(stmt, column, id, -1L);
    }

    @Override
    public void setCDOID(PreparedStatement stmt, int column, CDOID id, long commitTime) throws SQLException {
        stmt.setString(column, UUIDHandler.value(id));
    }

    @Override
    public CDOID getCDOID(ResultSet resultSet, int column) throws SQLException {
        String id = resultSet.getString(column);
        if (resultSet.wasNull()) {
            return null;
        }
        return UUIDHandler.create(id);
    }

    @Override
    public CDOID getCDOID(ResultSet resultSet, String name) throws SQLException {
        String id = resultSet.getString(name);
        if (resultSet.wasNull()) {
            return null;
        }
        return UUIDHandler.create(id);
    }

    @Override
    public CDOID getMinCDOID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CDOID getMaxCDOID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CDOID mapURI(IDBStoreAccessor accessor, String uri, long commitTime) {
        return CDOIDUtil.createExternal((String)uri);
    }

    @Override
    public String unmapURI(IDBStoreAccessor accessor, CDOID id) {
        return CDOIDUtil.getString((CDOID)id);
    }

    @Override
    public void rawExport(Connection connection, CDODataOutput out, long fromCommitTime, long toCommitTime) throws IOException {
    }

    @Override
    public void rawImport(Connection connection, CDODataInput in, long fromCommitTime, long toCommitTime, OMMonitor monitor) throws IOException {
    }

    private static CDOID create(String id) {
        if (id == null) {
            return null;
        }
        int length = id.length();
        if (length == 0) {
            return null;
        }
        char firstChar = id.charAt(0);
        if (length == 1 && firstChar == '0') {
            return null;
        }
        if (firstChar == '@') {
            byte[] bytes = CDOIDUtil.decodeUUID((String)id.substring(1));
            return CDOIDUtil.createUUID((byte[])bytes);
        }
        return CDOIDUtil.createExternal((String)id);
    }

    private static String value(CDOID id) {
        if (CDOIDUtil.isNull((CDOID)id)) {
            return NULL_STRING;
        }
        if (id.isExternal()) {
            return CDOIDUtil.getString((CDOID)id);
        }
        return String.valueOf(INTERNAL_STRING) + id.toURIFragment();
    }
}

