/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation;

import java.util.List;
import org.eclipse.birt.chart.computation.Point;
import org.eclipse.birt.chart.computation.Polygon;

public final class RotatedRectangle
extends Polygon {
    RotatedRectangle(double dX0, double dY0, double dX1, double dY1, double dX2, double dY2, double dX3, double dY3) {
        this.add(dX0, dY0);
        this.add(dX1, dY1);
        this.add(dX2, dY2);
        this.add(dX3, dY3);
    }

    public int[] getSwtPoints() {
        int[] iaXY = new int[8];
        int i = 0;
        while (i < 4) {
            Point lo = this.getPoint(i);
            iaXY[2 * i] = (int)lo.getX();
            iaXY[2 * i + 1] = (int)lo.getY();
            ++i;
        }
        return iaXY;
    }

    public void shiftXVertices(double dOffset) {
        int i = 0;
        while (i < 4) {
            Point lo = this.getPoint(i);
            lo.setX(lo.getX() + dOffset);
            ++i;
        }
    }

    public void shiftYVertices(double dOffset) {
        int i = 0;
        while (i < 4) {
            Point lo = this.getPoint(i);
            lo.setY(lo.getY() + dOffset);
            ++i;
        }
    }

    public void shiftVertices(double dOffset) {
        int i = 0;
        while (i < 4) {
            Point lo = this.getPoint(i);
            lo.translate(dOffset, dOffset);
            ++i;
        }
    }

    public Point[] asPoints() {
        List<Point> pts = this.getPoints();
        return pts.toArray(new Point[pts.size()]);
    }

    private static double getDistance(Point pt0, Point pt1) {
        double dx = pt0.x - pt1.x;
        double dy = pt0.y - pt1.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public Point getRectSize() {
        Point[] pts = this.asPoints();
        double width = RotatedRectangle.getDistance(pts[0], pts[1]);
        double height = RotatedRectangle.getDistance(pts[1], pts[2]);
        return new Point(width, height);
    }
}

