/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.function;

import java.util.Objects;

@FunctionalInterface
public interface QuadPredicate<P0, P1, P2, P3> {
    public boolean test(P0 var1, P1 var2, P2 var3, P3 var4);

    default public QuadPredicate<P0, P1, P2, P3> and(QuadPredicate<? super P0, ? super P1, ? super P2, ? super P3> other) {
        Objects.requireNonNull(other);
        return (p0, p1, p2, p3) -> this.test(p0, p1, p2, p3) && other.test(p0, p1, p2, p3);
    }

    default public QuadPredicate<P0, P1, P2, P3> negate() {
        return (p0, p1, p2, p3) -> !this.test(p0, p1, p2, p3);
    }

    default public QuadPredicate<P0, P1, P2, P3> or(QuadPredicate<? super P0, ? super P1, ? super P2, ? super P3> other) {
        Objects.requireNonNull(other);
        return (p0, p1, p2, p3) -> this.test(p0, p1, p2, p3) || other.test(p0, p1, p2, p3);
    }
}

