/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.project.facet.core.IConstraint;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.IVersionExpr;
import org.eclipse.wst.common.project.facet.core.internal.Constraint;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacet;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacetRef;
import org.eclipse.wst.common.project.facet.ui.internal.DetailsPanel;
import org.eclipse.wst.common.project.facet.ui.internal.FacetsSelectionPanel;
import org.eclipse.wst.common.project.facet.ui.internal.constraints.ConstraintOperator;
import org.eclipse.wst.common.project.facet.ui.internal.constraints.ConstraintUtil;
import org.eclipse.wst.common.project.facet.ui.internal.constraints.GroupingConstraintOperator;
import org.eclipse.wst.common.project.facet.ui.internal.constraints.MultiFacetConstraintOperator;
import org.eclipse.wst.common.project.facet.ui.internal.util.GridLayoutUtil;
import org.eclipse.wst.common.project.facet.ui.internal.util.ImageWithTextComposite;

public final class FacetDetailsPanel
extends Composite {
    private static final Comparator<ProjectFacetRef> FACET_REF_COMPARATOR = new Comparator<ProjectFacetRef>(){

        @Override
        public int compare(ProjectFacetRef x, ProjectFacetRef y) {
            String xLabel = x.getProjectFacet().getLabel();
            String yLabel = y.getProjectFacet().getLabel();
            return xLabel.compareTo(yLabel);
        }
    };
    private final FacetsSelectionPanel facetsSelectionPanel;

    public FacetDetailsPanel(Composite parent, FacetsSelectionPanel facetsSelectionPanel, IProjectFacetVersion facet) {
        super(parent, 0);
        this.facetsSelectionPanel = facetsSelectionPanel;
        this.setLayout((Layout)GridLayoutUtil.glmargins(GridLayoutUtil.gl(1), 0, 0));
        IFacetedProjectWorkingCopy fpjwc = facetsSelectionPanel.getFacetedProjectWorkingCopy();
        ImageWithTextComposite header = new ImageWithTextComposite(this);
        header.setLayoutData(GridLayoutUtil.gdhfill());
        header.setImage(facetsSelectionPanel.getImage(facet.getProjectFacet(), false));
        header.setFont(JFaceResources.getFontRegistry().get(DetailsPanel.HEADER_FONT));
        header.setText(facet.toString());
        Label separator = new Label((Composite)this, 258);
        separator.setLayoutData((Object)GridLayoutUtil.gdhfill());
        ScrolledComposite details = new ScrolledComposite((Composite)this, 768);
        details.setLayoutData((Object)GridLayoutUtil.gdfill());
        details.setMinWidth(300);
        details.setExpandHorizontal(true);
        details.setExpandVertical(true);
        Composite nestedDetailsComposite = new Composite((Composite)details, 0);
        nestedDetailsComposite.setLayout((Layout)GridLayoutUtil.glmargins(GridLayoutUtil.gl(1), 0, 10, 0, 0));
        details.setContent((Control)nestedDetailsComposite);
        Text descTextField = new Text(nestedDetailsComposite, 72);
        descTextField.setLayoutData((Object)GridLayoutUtil.gdhfill());
        descTextField.setText(facet.getProjectFacet().getDescription());
        IConstraint prunedConstraint = Constraint.pruneConstraint((IProjectFacetVersion)facet, (Set)fpjwc.getFixedProjectFacets());
        if (prunedConstraint != null) {
            ConstraintOperator normalizedConstraint = ConstraintUtil.normalize(ConstraintUtil.convert(prunedConstraint));
            List<ConstraintOperator> topLevelOperators = normalizedConstraint.getType() == ConstraintOperator.Type.AND ? ((GroupingConstraintOperator)normalizedConstraint).getChildren() : Collections.singletonList(normalizedConstraint);
            this.renderConstraints(nestedDetailsComposite, topLevelOperators);
        }
        details.setMinHeight(nestedDetailsComposite.computeSize((int)300, (int)-1).y);
    }

    private void renderConstraints(Composite parent, List<ConstraintOperator> constraints) {
        for (ConstraintOperator op : constraints) {
            ConstraintOperator.Type type = op.getType();
            if (op instanceof MultiFacetConstraintOperator) {
                MultiFacetConstraintOperator mfop = (MultiFacetConstraintOperator)op;
                String labelText = type == ConstraintOperator.Type.REQUIRES_ALL ? Resources.requiresAllFacetsLabel : (type == ConstraintOperator.Type.REQUIRES_ONE ? (mfop.getProjectFacetRefs().size() == 1 ? Resources.requiresFacetLabel : Resources.requiresOneOfFacetsLabel) : Resources.conflictingFacetsLabel);
                Text label = new Text(parent, 8);
                label.setLayoutData((Object)GridLayoutUtil.gdvindent(GridLayoutUtil.gdhfill(), 5));
                label.setText(labelText);
                Composite facetsComposite = new Composite(parent, 0);
                facetsComposite.setLayoutData((Object)GridLayoutUtil.gdhindent(GridLayoutUtil.gdvindent(GridLayoutUtil.gdhfill(), 5), 5));
                facetsComposite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glmargins(GridLayoutUtil.gl(1), 0, 0), 0, 3));
                ArrayList<ProjectFacetRef> sortedProjectFacetRefs = new ArrayList<ProjectFacetRef>(mfop.getProjectFacetRefs());
                Collections.sort(sortedProjectFacetRefs, FACET_REF_COMPARATOR);
                for (ProjectFacetRef requirement : sortedProjectFacetRefs) {
                    IProjectFacet f = requirement.getProjectFacet();
                    IVersionExpr vexpr = requirement.getVersionExpr();
                    StringBuilder text = new StringBuilder();
                    text.append(f.getLabel());
                    if (!vexpr.toString().equals("*") && !((ProjectFacet)f).isVersionHidden()) {
                        text.append(' ');
                        text.append(vexpr.toDisplayString());
                    }
                    ImageWithTextComposite fLabel = new ImageWithTextComposite(facetsComposite);
                    fLabel.setLayoutData(GridLayoutUtil.gdhfill());
                    fLabel.setImage(this.facetsSelectionPanel.getImage(f, false));
                    fLabel.setText(text.toString());
                }
                continue;
            }
            Label requiredFacetsLabel = new Label(parent, 0);
            requiredFacetsLabel.setLayoutData((Object)GridLayoutUtil.gdhfill());
            requiredFacetsLabel.setText(op.getType().name());
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)GridLayoutUtil.gdhindent(GridLayoutUtil.gdhfill(), 5));
            composite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glmargins(GridLayoutUtil.gl(1), 0, 0), 0, 3));
            this.renderConstraints(composite, ((GroupingConstraintOperator)op).getChildren());
        }
    }

    private static final class Resources
    extends NLS {
        public static String requiresFacetLabel;
        public static String requiresAllFacetsLabel;
        public static String requiresOneOfFacetsLabel;
        public static String conflictingFacetsLabel;

        static {
            Resources.initializeMessages((String)FacetDetailsPanel.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

