/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.git.ui;

import java.net.URI;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.ptp.internal.rdt.sync.git.ui.messages.Messages;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;
import org.eclipse.ptp.rdt.sync.ui.AbstractSynchronizeParticipant;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizeParticipantDescriptor;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionHostService;
import org.eclipse.remote.core.IRemoteFileService;
import org.eclipse.remote.ui.IRemoteUIConnectionService;
import org.eclipse.remote.ui.IRemoteUIFileService;
import org.eclipse.remote.ui.widgets.RemoteConnectionWidget;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class GitParticipant
extends AbstractSynchronizeParticipant {
    private static final String FILE_SCHEME = "file";
    private static final String EMPTY_STRING = "";
    private IRemoteConnection fSelectedConnection;
    private String fProjectName = "";
    private Button fBrowseButton;
    private Text fLocationText;
    private RemoteConnectionWidget fRemoteConnectionWidget;
    private IWizardContainer container;
    private boolean fRemoteDirSelected;
    private boolean fRemoteDirFocused;
    private final boolean showProviderCombo = false;

    public GitParticipant(ISynchronizeParticipantDescriptor descriptor) {
        super(descriptor);
    }

    private void checkConnection() {
        IRemoteUIConnectionService svc = this.getUIConnectionService();
        if (svc != null) {
            svc.openConnectionWithProgress(this.fRemoteConnectionWidget.getShell(), null, this.fSelectedConnection);
        }
    }

    public void createConfigurationArea(Composite parent, IRunnableContext context) {
        this.container = (IWizardContainer)context;
        Composite configArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        configArea.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        configArea.setLayoutData((Object)gd);
        int flags = 0;
        this.fRemoteConnectionWidget = new RemoteConnectionWidget(configArea, 0, null, flags |= RemoteConnectionWidget.FLAG_NO_LOCAL_SELECTION, context);
        this.fRemoteConnectionWidget.filterConnections(new Class[]{IRemoteConnectionHostService.class, IRemoteFileService.class});
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        this.fRemoteConnectionWidget.setLayoutData((Object)gd);
        this.fRemoteConnectionWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GitParticipant.this.handleConnectionSelected();
            }
        });
        Label locationLabel = new Label(configArea, 16384);
        locationLabel.setText(Messages.GitParticipant_location);
        this.fLocationText = new Text(configArea, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 250;
        this.fLocationText.setLayoutData((Object)gd);
        this.fLocationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GitParticipant.this.update();
                if (GitParticipant.this.fRemoteDirFocused) {
                    GitParticipant.this.fRemoteDirSelected = true;
                }
            }
        });
        this.fLocationText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
                GitParticipant.this.fRemoteDirFocused = false;
            }

            public void focusGained(FocusEvent arg0) {
                GitParticipant.this.fRemoteDirFocused = true;
            }
        });
        this.handleConnectionSelected();
        this.fBrowseButton = new Button(configArea, 8);
        this.fBrowseButton.setText(Messages.GitParticipant_browse);
        this.fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GitParticipant.this.fSelectedConnection != null) {
                    IRemoteUIFileService fileSvc;
                    GitParticipant.this.checkConnection();
                    if (GitParticipant.this.fSelectedConnection.isOpen() && (fileSvc = (IRemoteUIFileService)GitParticipant.this.fSelectedConnection.getConnectionType().getService(IRemoteUIFileService.class)) != null) {
                        fileSvc.setConnection(GitParticipant.this.fSelectedConnection);
                        String correctPath = GitParticipant.this.fLocationText.getText();
                        String selectedPath = fileSvc.browseDirectory(GitParticipant.this.fLocationText.getShell(), "Project Location (" + GitParticipant.this.fSelectedConnection.getName() + ")", correctPath, 0);
                        if (selectedPath != null) {
                            GitParticipant.this.fLocationText.setText(selectedPath);
                            GitParticipant.this.fRemoteDirSelected = true;
                        }
                    }
                }
            }
        });
    }

    private String getDefaultPathDisplayString() {
        IRemoteFileService fileSvc;
        if (this.fSelectedConnection != null && this.fSelectedConnection.isOpen() && (fileSvc = (IRemoteFileService)this.fSelectedConnection.getService(IRemoteFileService.class)) != null) {
            URI defaultURI = fileSvc.toURI(fileSvc.getBaseDirectory());
            if (defaultURI != null && defaultURI.getScheme().equals(FILE_SCHEME)) {
                return Platform.getLocation().append(this.fProjectName).toString();
            }
            if (defaultURI == null) {
                return EMPTY_STRING;
            }
            return new Path(defaultURI.getPath()).append(this.fProjectName).toString();
        }
        return EMPTY_STRING;
    }

    public String getErrorMessage() {
        if (this.fSelectedConnection == null) {
            return Messages.GitParticipant_1;
        }
        if (this.fLocationText.getText().length() == 0) {
            return Messages.GitParticipant_2;
        }
        IRemoteFileService fileSvc = (IRemoteFileService)this.fSelectedConnection.getService(IRemoteFileService.class);
        if (fileSvc != null && fileSvc.toURI(this.fLocationText.getText()) == null) {
            return Messages.GitParticipant_3;
        }
        return null;
    }

    public IRemoteConnection getConnection() {
        return this.fSelectedConnection;
    }

    public String getLocation() {
        return this.fLocationText.getText();
    }

    public String getSyncConfigName() {
        String configName = this.fSelectedConnection.getName();
        if (configName.equals(SyncConfigManager.getLocalConfigName())) {
            configName = String.valueOf(configName) + "-Sync";
        }
        return configName;
    }

    private IRemoteUIConnectionService getUIConnectionService() {
        if (this.fSelectedConnection != null) {
            return (IRemoteUIConnectionService)this.fSelectedConnection.getConnectionType().getService(IRemoteUIConnectionService.class);
        }
        return null;
    }

    private void handleConnectionSelected() {
        this.fSelectedConnection = this.fRemoteConnectionWidget.getConnection();
        this.fLocationText.setText(this.getDefaultPathDisplayString());
        this.update();
    }

    public boolean isConfigComplete() {
        return this.getErrorMessage() == null;
    }

    public void setProjectName(String projectName) {
        this.fProjectName = projectName;
        if (this.fLocationText.getText().equals(EMPTY_STRING)) {
            this.fRemoteDirSelected = false;
        }
        if (!this.fRemoteDirSelected) {
            this.fLocationText.setText(this.getDefaultPathDisplayString());
        }
    }

    private void update() {
        this.container.updateMessage();
        if (this.container.getCurrentPage() == null) {
            return;
        }
        this.container.updateButtons();
    }
}

