/**
 * Copyright (c) 2010-2013, Zoltan Ujhelyi, Istvan Rath and Daniel Varro
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Zoltan Ujhelyi - initial API and implementation
 *   Csaba Debreceni - add exception for deprecated methods
 */
package org.eclipse.viatra.addon.viewers.runtime.notation;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Formattable Element</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.viatra.addon.viewers.runtime.notation.FormattableElement#getLabel <em>Label</em>}</li>
 *   <li>{@link org.eclipse.viatra.addon.viewers.runtime.notation.FormattableElement#getFormat <em>Format</em>}</li>
 *   <li>{@link org.eclipse.viatra.addon.viewers.runtime.notation.FormattableElement#getId <em>Id</em>}</li>
 * </ul>
 *
 * @see org.eclipse.viatra.addon.viewers.runtime.notation.NotationPackage#getFormattableElement()
 * @model interface="true" abstract="true"
 * @generated
 */
public interface FormattableElement extends EObject {
	/**
	 * Returns the value of the '<em><b>Label</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Label</em>' attribute.
	 * @see #setLabel(String)
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.NotationPackage#getFormattableElement_Label()
	 * @model
	 * @generated
	 */
	String getLabel();

	/**
	 * Sets the value of the '{@link org.eclipse.viatra.addon.viewers.runtime.notation.FormattableElement#getLabel <em>Label</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Label</em>' attribute.
	 * @see #getLabel()
	 * @generated
	 */
	void setLabel(String value);

	/**
	 * Returns the value of the '<em><b>Format</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Format</em>' containment reference.
	 * @see #setFormat(FormatSpecification)
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.NotationPackage#getFormattableElement_Format()
	 * @model containment="true"
	 * @generated
	 */
	FormatSpecification getFormat();

	/**
	 * Sets the value of the '{@link org.eclipse.viatra.addon.viewers.runtime.notation.FormattableElement#getFormat <em>Format</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Format</em>' containment reference.
	 * @see #getFormat()
	 * @generated
	 */
	void setFormat(FormatSpecification value);

	/**
	 * Returns the value of the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Id</em>' attribute.
	 * @see #setId(String)
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.NotationPackage#getFormattableElement_Id()
	 * @model
	 * @generated
	 */
	String getId();

	/**
	 * Sets the value of the '{@link org.eclipse.viatra.addon.viewers.runtime.notation.FormattableElement#getId <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Id</em>' attribute.
	 * @see #getId()
	 * @generated
	 */
	void setId(String value);

} // FormattableElement
