/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.events;

import java.util.StringTokenizer;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.mi.service.command.events.MIBreakpointHitEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIStoppedEvent;
import org.eclipse.cdt.dsf.mi.service.command.output.MIFrame;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIStreamRecord;

public class MICatchpointHitEvent
extends MIBreakpointHitEvent {
    private String fReason;

    protected MICatchpointHitEvent(IRunControl.IExecutionDMContext ctx, int token, MIResult[] results, MIFrame frame, String bkptno, String reason) {
        super(ctx, token, results, frame, bkptno);
        this.fReason = reason;
    }

    public String getReason() {
        return this.fReason;
    }

    public static MIBreakpointHitEvent parse(IRunControl.IExecutionDMContext dmc, int token, MIResult[] results, MIStreamRecord streamRecord) {
        StringTokenizer tokenizer = new StringTokenizer(streamRecord.getString());
        tokenizer.nextToken();
        try {
            String bkptNumber = tokenizer.nextToken();
            StringBuilder reason = new StringBuilder();
            boolean first = true;
            while (tokenizer.hasMoreElements()) {
                if (!first) {
                    reason.append(" ");
                }
                reason.append(tokenizer.nextElement());
                first = false;
            }
            if (reason.charAt(0) == '(') {
                reason.deleteCharAt(0);
            }
            if (reason.charAt(reason.length() - 1) == ')') {
                reason.deleteCharAt(reason.length() - 1);
            }
            MIStoppedEvent stoppedEvent = MIStoppedEvent.parse(dmc, token, results);
            return new MICatchpointHitEvent((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), token, results, stoppedEvent.getFrame(), bkptNumber, reason.toString());
        }
        catch (NumberFormatException exc) {
            assert (false) : "unexpected catchpoint stream record format: " + streamRecord.getString();
            return null;
        }
    }

    public static MICatchpointHitEvent parse(IRunControl.IExecutionDMContext dmc, int token, MIResult[] results, String bkptNumber, String gdbKeyword) {
        MIStoppedEvent stoppedEvent = MIStoppedEvent.parse(dmc, token, results);
        return new MICatchpointHitEvent((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), token, results, stoppedEvent.getFrame(), bkptNumber, gdbKeyword);
    }
}

