/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.preferences;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class ConfiguratorEnabler {
    private String label;
    private String description;
    private String id;
    private Set<String> projectConfiguratorIds = new LinkedHashSet<String>();
    IEclipsePreferences preferenceStore = new InstanceScope().getNode("org.eclipse.m2e.wtp");

    public ConfiguratorEnabler(String enablerId, String label, String[] configuratorIds, String description) {
        this.id = enablerId;
        this.label = label;
        this.description = description;
        if (configuratorIds != null) {
            String[] stringArray = configuratorIds;
            int n = configuratorIds.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                this.projectConfiguratorIds.add(id);
                ++n2;
            }
        }
    }

    public String getConfiguratorLabel() {
        return this.label == null ? this.id : this.label;
    }

    public String getDescription() {
        return this.description == null ? this.getConfiguratorLabel() : this.description;
    }

    public String getId() {
        return this.id;
    }

    public boolean isEnabled() {
        return this.preferenceStore.getBoolean(this.getPreferenceKey(), true);
    }

    public void setEnabled(boolean enabled) {
        this.preferenceStore.putBoolean(this.getPreferenceKey(), enabled);
        try {
            this.preferenceStore.flush();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }

    private String getPreferenceKey() {
        return this.getId() + ".enabled";
    }

    public boolean appliesTo(String configuratorId) {
        return this.projectConfiguratorIds.contains(configuratorId);
    }

    public String toString() {
        return this.getId() + " : " + this.getConfiguratorLabel();
    }
}

