/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.api.query;

import java.util.Objects;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.table.business.api.query.DColumnQuery;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DCellStyle;
import org.eclipse.sirius.table.metamodel.table.DTableElementStyle;
import org.eclipse.sirius.table.metamodel.table.TableFactory;
import org.eclipse.sirius.table.metamodel.table.TablePackage;
import org.eclipse.sirius.table.metamodel.table.description.BackgroundStyleDescription;
import org.eclipse.sirius.table.metamodel.table.description.CellUpdater;
import org.eclipse.sirius.table.metamodel.table.description.ColumnMapping;
import org.eclipse.sirius.table.metamodel.table.description.FeatureColumnMapping;
import org.eclipse.sirius.table.metamodel.table.description.ForegroundStyleDescription;
import org.eclipse.sirius.table.metamodel.table.description.IntersectionMapping;
import org.eclipse.sirius.table.tools.internal.Messages;
import org.eclipse.sirius.tools.api.SiriusPlugin;

public class DCellQuery {
    public static final DTableElementStyle DEFAULT_STYLE = TableFactory.eINSTANCE.createDTableElementStyle();
    private final DCell cell;

    public DCellQuery(DCell cell) {
        this.cell = Objects.requireNonNull(cell);
    }

    public Option<DTableElementStyle> getForegroundStyleToApply() {
        Object styleToApply = null;
        DCellStyle currentCellStyle = this.cell.getCurrentStyle();
        boolean cellStyleWithDefaultValue = false;
        if (!(currentCellStyle == null || currentCellStyle.eIsSet((EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_ForegroundColor()) || currentCellStyle.eIsSet((EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_LabelFormat()) || currentCellStyle.eIsSet((EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_LabelSize()))) {
            cellStyleWithDefaultValue = true;
            currentCellStyle = null;
        }
        DTableElementStyle currentLineStyle = null;
        if (!(this.cell.getLine() == null || (currentLineStyle = this.cell.getLine().getCurrentStyle()) == null || currentLineStyle.eIsSet((EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_ForegroundColor()) || currentLineStyle.eIsSet((EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_LabelFormat()) || currentLineStyle.eIsSet((EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_LabelSize()))) {
            currentLineStyle = null;
        }
        DTableElementStyle currentColumnStyle = null;
        if (!(this.cell.getColumn() == null || (currentColumnStyle = this.cell.getColumn().getCurrentStyle()) == null || currentColumnStyle.eIsSet((EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_ForegroundColor()) || currentColumnStyle.eIsSet((EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_LabelFormat()) || currentColumnStyle.eIsSet((EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_LabelSize()))) {
            currentColumnStyle = null;
        }
        if (currentCellStyle != null) {
            if (!currentCellStyle.isDefaultForegroundStyle()) {
                styleToApply = currentCellStyle.getForegroundStyleOrigin() instanceof IntersectionMapping ? currentCellStyle : (currentLineStyle != null && !currentLineStyle.isDefaultForegroundStyle() ? currentLineStyle : currentCellStyle);
            } else if (currentLineStyle != null && !currentLineStyle.isDefaultForegroundStyle()) {
                styleToApply = currentLineStyle;
            } else if (currentCellStyle.getForegroundStyleOrigin() instanceof IntersectionMapping) {
                styleToApply = currentCellStyle;
            } else if (currentLineStyle != null && currentLineStyle.isDefaultForegroundStyle()) {
                styleToApply = currentLineStyle;
            } else if (currentCellStyle.getForegroundStyleOrigin() instanceof ColumnMapping) {
                styleToApply = currentCellStyle;
            } else if (currentColumnStyle != null && currentColumnStyle.isDefaultForegroundStyle()) {
                styleToApply = currentColumnStyle;
            }
        } else if (currentLineStyle != null) {
            styleToApply = currentLineStyle;
        } else if (currentColumnStyle != null) {
            styleToApply = currentColumnStyle;
        }
        return this.getStyleToApply((DTableElementStyle)styleToApply, cellStyleWithDefaultValue);
    }

    private Option<DTableElementStyle> getStyleToApply(DTableElementStyle styleToApply, boolean cellStyleWithDefaultValue) {
        Option result = styleToApply == null ? (cellStyleWithDefaultValue ? Options.newSome((Object)this.cell.getCurrentStyle()) : Options.newSome((Object)DEFAULT_STYLE)) : Options.newSome((Object)styleToApply);
        return result;
    }

    public Option<DTableElementStyle> getBackgroundStyleToApply() {
        Object styleToApply = null;
        DCellStyle currentCellStyle = this.cell.getCurrentStyle();
        boolean cellStyleWithDefaultValue = false;
        if (currentCellStyle != null && !currentCellStyle.eIsSet((EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_BackgroundColor())) {
            cellStyleWithDefaultValue = true;
            currentCellStyle = null;
        }
        DTableElementStyle currentLineStyle = null;
        if (this.cell.getLine() != null && (currentLineStyle = this.cell.getLine().getCurrentStyle()) != null && !currentLineStyle.eIsSet((EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_BackgroundColor())) {
            currentLineStyle = null;
        }
        DTableElementStyle currentColumnStyle = null;
        if (this.cell.getColumn() != null && (currentColumnStyle = this.cell.getColumn().getCurrentStyle()) != null && !currentColumnStyle.eIsSet((EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_BackgroundColor())) {
            currentColumnStyle = null;
        }
        if (currentCellStyle != null) {
            if (!currentCellStyle.isDefaultBackgroundStyle()) {
                styleToApply = currentCellStyle.getBackgroundStyleOrigin() instanceof IntersectionMapping ? currentCellStyle : (currentLineStyle != null && !currentLineStyle.isDefaultBackgroundStyle() ? currentLineStyle : currentCellStyle);
            } else if (currentLineStyle != null && !currentLineStyle.isDefaultBackgroundStyle()) {
                styleToApply = currentLineStyle;
            } else if (currentCellStyle.getBackgroundStyleOrigin() instanceof IntersectionMapping) {
                styleToApply = currentCellStyle;
            } else if (currentLineStyle != null && currentLineStyle.isDefaultBackgroundStyle()) {
                styleToApply = currentLineStyle;
            } else if (currentCellStyle.getBackgroundStyleOrigin() instanceof ColumnMapping) {
                styleToApply = currentCellStyle;
            } else if (currentColumnStyle != null && currentColumnStyle.isDefaultBackgroundStyle()) {
                styleToApply = currentColumnStyle;
            }
        } else if (currentLineStyle != null) {
            styleToApply = currentLineStyle;
        } else if (currentColumnStyle != null) {
            styleToApply = currentColumnStyle;
        }
        return this.getStyleToApply((DTableElementStyle)styleToApply, cellStyleWithDefaultValue);
    }

    public boolean isStyleDescriptionInIntersectionMapping(EObject style) {
        EObject styleContainer;
        if (!(style instanceof ForegroundStyleDescription) && !(style instanceof BackgroundStyleDescription)) {
            throw new IllegalArgumentException(Messages.Table_WrongStyleAttribute);
        }
        IntersectionMapping intersectionMapping = this.cell.getIntersectionMapping();
        return intersectionMapping != null && (intersectionMapping.equals(styleContainer = style.eContainer()) || styleContainer != null && intersectionMapping.equals(styleContainer.eContainer()));
    }

    public int getColumnIndex() {
        return new DColumnQuery(this.cell.getColumn()).getColumnIndex();
    }

    public String getExportableLabel() {
        String featureName;
        String label = this.cell.getLabel();
        CellUpdater updater = this.cell.getUpdater();
        if (updater instanceof FeatureColumnMapping && this.cell.getTarget() != null && !StringUtil.isEmpty((String)(featureName = ((FeatureColumnMapping)updater).getFeatureName())) && StringUtil.isEmpty((String)updater.getLabelComputationExpression())) {
            ModelAccessor modelAccessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)this.cell);
            EObject target = this.cell.getTarget();
            EStructuralFeature eStructuralFeature = null;
            Object value = null;
            try {
                value = modelAccessor.eGet(this.cell.getTarget(), featureName);
                eStructuralFeature = target.eClass().getEStructuralFeature(featureName);
            }
            catch (FeatureNotFoundException featureNotFoundException) {}
            if (value instanceof String) {
                label = (String)value;
            } else if (eStructuralFeature instanceof EAttribute && !(value instanceof Boolean) && !(value instanceof EEnum)) {
                EDataType eDataType = ((EAttribute)eStructuralFeature).getEAttributeType();
                label = EcoreUtil.convertToString((EDataType)eDataType, (Object)value);
            }
        }
        return label;
    }
}

