/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.conflict;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ComparisonCanceledException;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.EMFCompareMessages;
import org.eclipse.emf.compare.Equivalence;
import org.eclipse.emf.compare.FeatureMapChange;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.conflict.IConflictDetector;
import org.eclipse.emf.compare.diff.FeatureFilter;
import org.eclipse.emf.compare.internal.FeatureFilterAdapter;
import org.eclipse.emf.compare.internal.ThreeWayTextDiff;
import org.eclipse.emf.compare.internal.conflict.DiffTreeIterator;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.utils.EMFCompareJavaPredicates;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;

public class DefaultConflictDetector
implements IConflictDetector {
    @Override
    public void detect(Comparison comparison, Monitor monitor) {
        EList<Diff> differences = comparison.getDifferences();
        int diffCount = differences.size();
        int i = 0;
        while (i < diffCount) {
            if (i % 100 == 0) {
                monitor.subTask(EMFCompareMessages.getString("DefaultConflictDetector.monitor.detect", i + 1, diffCount));
            }
            if (monitor.isCanceled()) {
                throw new ComparisonCanceledException();
            }
            Diff diff = (Diff)differences.get(i);
            Stream<Diff> conflictCandidates = differences.stream().filter(EMFCompareJavaPredicates.possiblyConflictingWith(diff));
            this.checkConflict(comparison, diff, conflictCandidates::iterator);
            ++i;
        }
    }

    protected void checkConflict(Comparison comparison, Diff diff, Iterable<Diff> candidates) {
        if (diff instanceof ReferenceChange && ((ReferenceChange)diff).getReference().isContainment()) {
            Stream<ReferenceChange> conflictCandidates = StreamSupport.stream(candidates.spliterator(), false).filter(ReferenceChange.class::isInstance).map(ReferenceChange.class::cast);
            this.checkContainmentConflict(comparison, (ReferenceChange)diff, conflictCandidates::iterator);
        } else if (diff instanceof ResourceAttachmentChange) {
            this.checkResourceAttachmentConflict(comparison, (ResourceAttachmentChange)diff, candidates);
        } else if (ComparisonUtil.isFeatureMapContainment(diff)) {
            Stream<FeatureMapChange> conflictCandidates = StreamSupport.stream(candidates.spliterator(), false).filter(FeatureMapChange.class::isInstance).map(FeatureMapChange.class::cast);
            this.checkContainmentFeatureMapConflict(comparison, (FeatureMapChange)diff, conflictCandidates::iterator);
        } else {
            switch (diff.getKind()) {
                case DELETE: {
                    this.checkFeatureDeleteConflict(comparison, diff, candidates);
                    break;
                }
                case CHANGE: {
                    this.checkFeatureChangeConflict(comparison, diff, candidates);
                    break;
                }
                case MOVE: {
                    this.checkFeatureMoveConflict(comparison, diff, candidates);
                    break;
                }
                case ADD: {
                    this.checkFeatureAddConflict(comparison, diff, candidates);
                    break;
                }
            }
        }
    }

    protected void checkContainmentConflict(Comparison comparison, ReferenceChange diff, Iterable<ReferenceChange> candidates) {
        for (ReferenceChange candidate : candidates) {
            if (this.isMatchingValues(comparison, diff, candidate)) {
                this.checkContainmentConflict(comparison, diff, candidate);
                continue;
            }
            if (!this.isConflictingAdditionToSingleValuedReference(diff, candidate)) continue;
            if (comparison.getEqualityHelper().matchingValues(candidate.getValue(), diff.getValue())) {
                this.conflictOn(comparison, diff, candidate, ConflictKind.PSEUDO);
                continue;
            }
            this.conflictOn(comparison, diff, candidate, ConflictKind.REAL);
        }
        if (diff.getKind() == DifferenceKind.DELETE) {
            DiffTreeIterator diffIterator = new DiffTreeIterator(comparison.getMatch(diff.getValue()));
            diffIterator.setFilter(EMFCompareJavaPredicates.possiblyConflictingWith(diff));
            diffIterator.setPruningFilter(this.isContainmentDelete());
            while (diffIterator.hasNext()) {
                Diff extendedCandidate = diffIterator.next();
                if (ComparisonUtil.isDeleteOrUnsetDiff(extendedCandidate)) continue;
                this.conflictOn(comparison, diff, extendedCandidate, ConflictKind.REAL);
            }
        }
    }

    private boolean isConflictingAdditionToSingleValuedReference(ReferenceChange diff, ReferenceChange candidate) {
        if (diff.getMatch() == candidate.getMatch() && diff.getReference() == candidate.getReference() && !diff.getReference().isMany()) {
            return ComparisonUtil.isAddOrSetDiff(diff) && ComparisonUtil.isAddOrSetDiff(candidate);
        }
        return false;
    }

    private boolean isMatchingValues(Comparison comparison, ReferenceChange diff, ReferenceChange candidate) {
        Match valueMatch = comparison.getMatch(diff.getValue());
        EObject candidateValue = candidate.getValue();
        return valueMatch.getLeft() == candidateValue || valueMatch.getRight() == candidateValue || valueMatch.getOrigin() == candidateValue;
    }

    private Predicate<? super Match> isContainmentDelete() {
        return new Predicate<Match>(){

            @Override
            public boolean test(Match input) {
                return input.getOrigin() != null && (input.getLeft() == null || input.getRight() == null);
            }
        };
    }

    protected void checkContainmentConflict(Comparison comparison, ReferenceChange diff, ReferenceChange candidate) {
        boolean candidateIsDelete = ComparisonUtil.isDeleteOrUnsetDiff(candidate);
        if (candidate.getReference().isContainment()) {
            ConflictKind kind = ConflictKind.REAL;
            boolean diffIsDelete = ComparisonUtil.isDeleteOrUnsetDiff(diff);
            if (diffIsDelete && candidateIsDelete) {
                kind = ConflictKind.PSEUDO;
            } else if (diff.getMatch() == candidate.getMatch() && diff.getReference() == candidate.getReference() && !diffIsDelete && !candidateIsDelete) {
                FeatureFilter featureFilter = this.getFeatureFilter(comparison);
                if (featureFilter == null || featureFilter.checkForOrderingChanges((EStructuralFeature)diff.getReference())) {
                    if (MatchUtil.matchingIndices(diff.getMatch(), (EStructuralFeature)diff.getReference(), diff.getValue(), candidate.getValue())) {
                        kind = ConflictKind.PSEUDO;
                    }
                } else {
                    kind = ConflictKind.PSEUDO;
                }
            }
            this.conflictOn(comparison, diff, candidate, kind);
        } else if (diff.getKind() == DifferenceKind.DELETE && !candidateIsDelete) {
            this.conflictOn(comparison, diff, candidate, ConflictKind.REAL);
        }
    }

    private FeatureFilter getFeatureFilter(Comparison comparison) {
        Adapter adapter = EcoreUtil.getExistingAdapter((Notifier)comparison, FeatureFilterAdapter.class);
        if (adapter instanceof FeatureFilterAdapter) {
            return ((FeatureFilterAdapter)adapter).getFeatureFilter();
        }
        return null;
    }

    protected void checkContainmentFeatureMapConflict(Comparison comparison, FeatureMapChange diff, Iterable<FeatureMapChange> candidates) {
        FeatureMap.Entry entry = (FeatureMap.Entry)diff.getValue();
        Object value = entry.getValue();
        Match valueMatch = value instanceof EObject ? comparison.getMatch((EObject)value) : diff.getMatch();
        for (FeatureMapChange candidate : candidates) {
            FeatureMap.Entry candidateEntry = (FeatureMap.Entry)candidate.getValue();
            Object candidateValue = candidateEntry.getValue();
            if (valueMatch.getLeft() != candidateValue && valueMatch.getRight() != candidateValue && valueMatch.getOrigin() != candidateValue) continue;
            this.checkContainmentFeatureMapConflict(comparison, diff, candidate);
        }
        if (diff.getKind() == DifferenceKind.DELETE) {
            DiffTreeIterator diffIterator = new DiffTreeIterator(valueMatch);
            diffIterator.setFilter(EMFCompareJavaPredicates.possiblyConflictingWith(diff));
            diffIterator.setPruningFilter(this.isContainmentDelete());
            while (diffIterator.hasNext()) {
                Diff extendedCandidate = diffIterator.next();
                if (ComparisonUtil.isDeleteOrUnsetDiff(extendedCandidate)) continue;
                this.conflictOn(comparison, diff, extendedCandidate, ConflictKind.REAL);
            }
        }
    }

    protected void checkContainmentFeatureMapConflict(Comparison comparison, FeatureMapChange diff, FeatureMapChange candidate) {
        boolean candidateIsDelete = ComparisonUtil.isDeleteOrUnsetDiff(candidate);
        if (ComparisonUtil.isFeatureMapContainment(candidate)) {
            ConflictKind kind = ConflictKind.REAL;
            boolean diffIsDelete = ComparisonUtil.isDeleteOrUnsetDiff(diff);
            if (diffIsDelete && candidateIsDelete) {
                kind = ConflictKind.PSEUDO;
            } else if (diff.getMatch() == candidate.getMatch() && diff.getAttribute() == candidate.getAttribute() && !diffIsDelete && !candidateIsDelete && MatchUtil.matchingIndices(diff.getMatch(), (EStructuralFeature)diff.getAttribute(), diff.getValue(), candidate.getValue()) && this.haveSameKey(diff, candidate)) {
                kind = ConflictKind.PSEUDO;
            }
            this.conflictOn(comparison, diff, candidate, kind);
        } else if (diff.getKind() == DifferenceKind.DELETE && !candidateIsDelete) {
            this.conflictOn(comparison, diff, candidate, ConflictKind.REAL);
        }
    }

    private boolean haveSameKey(FeatureMapChange left, FeatureMapChange right) {
        FeatureMap.Entry leftEntry = (FeatureMap.Entry)left.getValue();
        FeatureMap.Entry rightEntry = (FeatureMap.Entry)right.getValue();
        return leftEntry.getEStructuralFeature().equals(rightEntry.getEStructuralFeature());
    }

    protected void checkFeatureChangeConflict(Comparison comparison, Diff diff, Iterable<Diff> candidates) {
        EReference feature;
        Object changedValue;
        if (diff instanceof ReferenceChange) {
            changedValue = ((ReferenceChange)diff).getValue();
            feature = ((ReferenceChange)diff).getReference();
        } else if (diff instanceof AttributeChange) {
            changedValue = ((AttributeChange)diff).getValue();
            feature = ((AttributeChange)diff).getAttribute();
        } else if (diff instanceof FeatureMapChange) {
            changedValue = ((FeatureMap.Entry)((FeatureMapChange)diff).getValue()).getValue();
            feature = ((FeatureMapChange)diff).getAttribute();
        } else {
            return;
        }
        Iterable refinedCandidates = StreamSupport.stream(candidates.spliterator(), false).filter(new Predicate<Diff>((EStructuralFeature)feature){
            private final /* synthetic */ EStructuralFeature val$feature;
            {
                this.val$feature = eStructuralFeature;
            }

            @Override
            public boolean test(Diff input) {
                boolean apply = false;
                if (input != null && input.getKind() == DifferenceKind.CHANGE) {
                    if (input instanceof ReferenceChange) {
                        apply = ((ReferenceChange)input).getReference() == this.val$feature;
                    } else if (input instanceof AttributeChange) {
                        apply = ((AttributeChange)input).getAttribute() == this.val$feature;
                    } else if (input instanceof FeatureMapChange) {
                        apply = ((FeatureMapChange)input).getAttribute() == this.val$feature;
                    }
                }
                return apply;
            }
        })::iterator;
        IEqualityHelper equalityHelper = comparison.getEqualityHelper();
        for (Diff candidate : refinedCandidates) {
            Object candidateValue = DefaultConflictDetector.getDiffValue(candidate);
            if (diff.getMatch() != candidate.getMatch()) continue;
            if (equalityHelper.matchingValues(changedValue, candidateValue)) {
                this.conflictOn(comparison, diff, candidate, ConflictKind.PSEUDO);
                continue;
            }
            if (this.isFeatureMapChangeOrMergeableStringAttributeChange(diff, candidate)) continue;
            this.conflictOn(comparison, diff, candidate, ConflictKind.REAL);
        }
    }

    private boolean isFeatureMapChangeOrMergeableStringAttributeChange(Diff diff1, Diff diff2) {
        return this.isFeatureMapChange(diff1) || this.areMergeableStringAttributeChanges(diff1, diff2);
    }

    private boolean isFeatureMapChange(Diff diff) {
        return diff instanceof FeatureMapChange;
    }

    private boolean areMergeableStringAttributeChanges(Diff diff1, Diff diff2) {
        boolean mergeableStringAttributeChange;
        if (this.isStringAttributeChange(diff1)) {
            AttributeChange attributeChange1 = (AttributeChange)diff1;
            AttributeChange attributeChange2 = (AttributeChange)diff2;
            mergeableStringAttributeChange = this.isMergeable(attributeChange1, attributeChange2);
        } else {
            mergeableStringAttributeChange = false;
        }
        return mergeableStringAttributeChange;
    }

    private boolean isStringAttributeChange(Diff diff) {
        return diff instanceof AttributeChange && ((AttributeChange)diff).getAttribute().getEAttributeType().getInstanceClass() == String.class;
    }

    private boolean isMergeable(AttributeChange diff1, AttributeChange diff2) {
        String changedValue1 = this.getChangedValue(diff1);
        String changedValue2 = this.getChangedValue(diff2);
        EObject originalContainer = diff1.getMatch().getOrigin();
        EAttribute changedAttribute = diff1.getAttribute();
        String originalValue = (String)ReferenceUtil.safeEGet(originalContainer, (EStructuralFeature)changedAttribute);
        return this.isMergeableText(changedValue1, changedValue2, originalValue);
    }

    protected boolean isMergeableText(String left, String right, String origin) {
        ThreeWayTextDiff textDiff = new ThreeWayTextDiff(origin, left, right);
        return !textDiff.isConflicting();
    }

    private String getChangedValue(AttributeChange diff) {
        Match match = diff.getMatch();
        String changedValue = DifferenceSource.LEFT.equals((Object)diff.getSource()) ? (String)ReferenceUtil.safeEGet(match.getLeft(), (EStructuralFeature)diff.getAttribute()) : (DifferenceSource.RIGHT.equals((Object)diff.getSource()) ? (String)ReferenceUtil.safeEGet(match.getRight(), (EStructuralFeature)diff.getAttribute()) : (String)diff.getValue());
        return changedValue;
    }

    protected void checkFeatureMoveConflict(Comparison comparison, Diff diff, Iterable<Diff> candidates) {
        EReference feature;
        Object changedValue;
        if (diff instanceof ReferenceChange) {
            changedValue = ((ReferenceChange)diff).getValue();
            feature = ((ReferenceChange)diff).getReference();
        } else if (diff instanceof AttributeChange) {
            changedValue = ((AttributeChange)diff).getValue();
            feature = ((AttributeChange)diff).getAttribute();
        } else if (diff instanceof FeatureMapChange) {
            changedValue = ((FeatureMap.Entry)((FeatureMapChange)diff).getValue()).getValue();
            feature = ((FeatureMapChange)diff).getAttribute();
        } else {
            return;
        }
        Iterable refinedCandidates = StreamSupport.stream(candidates.spliterator(), false).filter(new Predicate<Diff>((EStructuralFeature)feature){
            private final /* synthetic */ EStructuralFeature val$feature;
            {
                this.val$feature = eStructuralFeature;
            }

            @Override
            public boolean test(Diff input) {
                boolean apply = false;
                if (input != null && input.getKind() == DifferenceKind.MOVE) {
                    if (input instanceof ReferenceChange) {
                        apply = ((ReferenceChange)input).getReference() == this.val$feature;
                    } else if (input instanceof AttributeChange) {
                        apply = ((AttributeChange)input).getAttribute() == this.val$feature;
                    } else if (input instanceof FeatureMapChange) {
                        apply = ((FeatureMapChange)input).getAttribute() == this.val$feature;
                    }
                }
                return apply;
            }
        })::iterator;
        for (Diff candidate : refinedCandidates) {
            Object candidateValue = DefaultConflictDetector.getDiffValue(candidate);
            if (diff.getMatch() != candidate.getMatch() || !comparison.getEqualityHelper().matchingValues(changedValue, candidateValue)) continue;
            if (MatchUtil.matchingIndices(diff.getMatch(), (EStructuralFeature)feature, changedValue, candidateValue)) {
                this.conflictOn(comparison, diff, candidate, ConflictKind.PSEUDO);
                continue;
            }
            this.conflictOn(comparison, diff, candidate, ConflictKind.REAL);
        }
    }

    protected void checkFeatureDeleteConflict(Comparison comparison, Diff diff, Iterable<Diff> candidates) {
        EReference feature;
        Object deletedValue;
        if (diff instanceof ReferenceChange) {
            deletedValue = ((ReferenceChange)diff).getValue();
            feature = ((ReferenceChange)diff).getReference();
        } else if (diff instanceof AttributeChange) {
            deletedValue = ((AttributeChange)diff).getValue();
            feature = ((AttributeChange)diff).getAttribute();
        } else if (diff instanceof FeatureMapChange) {
            deletedValue = ((FeatureMap.Entry)((FeatureMapChange)diff).getValue()).getValue();
            feature = ((FeatureMapChange)diff).getAttribute();
        } else {
            return;
        }
        Iterable refinedCandidates = StreamSupport.stream(candidates.spliterator(), false).filter(new Predicate<Diff>((EStructuralFeature)feature){
            private final /* synthetic */ EStructuralFeature val$feature;
            {
                this.val$feature = eStructuralFeature;
            }

            @Override
            public boolean test(Diff input) {
                boolean apply = false;
                if (input != null && (input.getKind() == DifferenceKind.MOVE || input.getKind() == DifferenceKind.DELETE)) {
                    if (input instanceof ReferenceChange) {
                        apply = ((ReferenceChange)input).getReference() == this.val$feature;
                    } else if (input instanceof AttributeChange) {
                        apply = ((AttributeChange)input).getAttribute() == this.val$feature;
                    } else if (input instanceof FeatureMapChange) {
                        apply = ((FeatureMapChange)input).getAttribute() == this.val$feature;
                    }
                }
                return apply;
            }
        })::iterator;
        for (Diff candidate : refinedCandidates) {
            Object movedValue = DefaultConflictDetector.getDiffValue(candidate);
            if (!comparison.getEqualityHelper().matchingValues(deletedValue, movedValue)) continue;
            if (candidate.getKind() == DifferenceKind.MOVE) {
                this.conflictOn(comparison, diff, candidate, ConflictKind.REAL);
                continue;
            }
            if (diff.getMatch() != candidate.getMatch()) continue;
            this.conflictOn(comparison, diff, candidate, ConflictKind.PSEUDO);
        }
    }

    protected void checkFeatureAddConflict(Comparison comparison, final Diff diff, Iterable<Diff> candidates) {
        EReference feature;
        Object addedValue;
        if (diff instanceof ReferenceChange) {
            addedValue = ((ReferenceChange)diff).getValue();
            feature = ((ReferenceChange)diff).getReference();
        } else if (diff instanceof AttributeChange) {
            addedValue = ((AttributeChange)diff).getValue();
            feature = ((AttributeChange)diff).getAttribute();
        } else if (diff instanceof FeatureMapChange) {
            addedValue = ((FeatureMap.Entry)((FeatureMapChange)diff).getValue()).getValue();
            feature = ((FeatureMapChange)diff).getAttribute();
        } else {
            return;
        }
        Iterable refinedCandidates = StreamSupport.stream(candidates.spliterator(), false).filter(new Predicate<Diff>((EStructuralFeature)feature){
            private final /* synthetic */ EStructuralFeature val$feature;
            {
                this.val$feature = eStructuralFeature;
            }

            @Override
            public boolean test(Diff input) {
                boolean apply = false;
                if (input != null && input.getKind() == DifferenceKind.ADD && diff.getMatch() == input.getMatch()) {
                    if (input instanceof ReferenceChange) {
                        apply = ((ReferenceChange)input).getReference() == this.val$feature;
                    } else if (input instanceof AttributeChange) {
                        apply = ((AttributeChange)input).getAttribute() == this.val$feature;
                    } else if (input instanceof FeatureMapChange) {
                        apply = ((FeatureMapChange)input).getAttribute() == this.val$feature;
                    }
                }
                return apply;
            }
        })::iterator;
        for (Diff candidate : refinedCandidates) {
            Object candidateValue = DefaultConflictDetector.getDiffValue(candidate);
            if (feature.isUnique() && comparison.getEqualityHelper().matchingValues(addedValue, candidateValue)) {
                if (diff instanceof FeatureMapChange) {
                    EStructuralFeature key2;
                    EStructuralFeature key1 = ((FeatureMap.Entry)((FeatureMapChange)diff).getValue()).getEStructuralFeature();
                    if (key1.equals(key2 = ((FeatureMap.Entry)((FeatureMapChange)candidate).getValue()).getEStructuralFeature())) {
                        this.conflictOn(comparison, diff, candidate, ConflictKind.PSEUDO);
                        continue;
                    }
                    if (!ComparisonUtil.isFeatureMapContainment(diff)) continue;
                    this.conflictOn(comparison, diff, candidate, ConflictKind.REAL);
                    continue;
                }
                FeatureFilter featureFilter = this.getFeatureFilter(comparison);
                if (featureFilter == null || featureFilter.checkForOrderingChanges((EStructuralFeature)feature)) {
                    if (MatchUtil.matchingIndices(diff.getMatch(), (EStructuralFeature)feature, addedValue, candidateValue)) {
                        this.conflictOn(comparison, diff, candidate, ConflictKind.PSEUDO);
                        continue;
                    }
                    this.conflictOn(comparison, diff, candidate, ConflictKind.REAL);
                    continue;
                }
                this.conflictOn(comparison, diff, candidate, ConflictKind.PSEUDO);
                continue;
            }
            if (feature.isUnique() || !comparison.getEqualityHelper().matchingValues(addedValue, candidateValue) || candidate.getConflict() != null && candidate.getConflict().getKind() == ConflictKind.PSEUDO && candidate.getConflict().getDifferences().stream().anyMatch(conflictingWith -> DefaultConflictDetector.matchingConflictingDiff(comparison, diff, conflictingWith))) continue;
            this.conflictOn(comparison, diff, candidate, ConflictKind.PSEUDO);
        }
    }

    private static boolean matchingConflictingDiff(Comparison comparison, Diff reference, Diff candidate) {
        if (reference == candidate) {
            return true;
        }
        if (reference.getMatch() == candidate.getMatch() && reference.getKind() == candidate.getKind()) {
            Object referenceValue = DefaultConflictDetector.getDiffValue(reference);
            Object candidateValue = DefaultConflictDetector.getDiffValue(candidate);
            return comparison.getEqualityHelper().matchingValues(referenceValue, candidateValue);
        }
        return false;
    }

    private static Object getDiffValue(Diff diff) {
        Object value = diff instanceof ReferenceChange ? ((ReferenceChange)diff).getValue() : (diff instanceof AttributeChange ? ((AttributeChange)diff).getValue() : (diff instanceof FeatureMapChange ? ((FeatureMap.Entry)((FeatureMapChange)diff).getValue()).getValue() : null));
        return value;
    }

    protected void checkResourceAttachmentConflict(Comparison comparison, ResourceAttachmentChange diff, Iterable<Diff> candidates) {
        EObject o;
        Match match = diff.getMatch();
        EObject leftVal = match.getLeft();
        EObject rightVal = match.getRight();
        EObject originVal = match.getOrigin();
        for (Diff candidate : candidates) {
            String rhsURI;
            String lhsURI;
            if (candidate instanceof ReferenceChange) {
                if (diff.getKind() == DifferenceKind.DELETE && match == candidate.getMatch() && this.getRelatedModelElement(diff) == null) {
                    if (candidate.getKind() == DifferenceKind.DELETE || ComparisonUtil.isDeleteOrUnsetDiff(candidate)) continue;
                    this.conflictOn(comparison, diff, candidate, ConflictKind.REAL);
                    continue;
                }
                EObject candidateValue = ((ReferenceChange)candidate).getValue();
                if (candidateValue != leftVal && candidateValue != rightVal && candidateValue != originVal) continue;
                this.checkResourceAttachmentConflict(comparison, diff, (ReferenceChange)candidate);
                continue;
            }
            if (candidate instanceof AttributeChange) {
                if (diff.getKind() != DifferenceKind.DELETE || match != candidate.getMatch() || this.getRelatedModelElement(diff) != null) continue;
                if (ComparisonUtil.isDeleteOrUnsetDiff(candidate)) {
                    this.conflictOn(comparison, diff, candidate, ConflictKind.PSEUDO);
                    continue;
                }
                this.conflictOn(comparison, diff, candidate, ConflictKind.REAL);
                continue;
            }
            if (candidate instanceof FeatureMapChange) {
                if (diff.getKind() != DifferenceKind.DELETE || match != candidate.getMatch() || this.getRelatedModelElement(diff) != null) continue;
                if (ComparisonUtil.isDeleteOrUnsetDiff(candidate)) {
                    this.conflictOn(comparison, diff, candidate, ConflictKind.PSEUDO);
                    continue;
                }
                this.conflictOn(comparison, diff, candidate, ConflictKind.REAL);
                continue;
            }
            if (!(candidate instanceof ResourceAttachmentChange) || match != candidate.getMatch()) continue;
            ConflictKind kind = ConflictKind.REAL;
            if (candidate.getKind() == DifferenceKind.DELETE && diff.getKind() == DifferenceKind.DELETE) {
                kind = ConflictKind.PSEUDO;
            } else if (candidate.getKind() == DifferenceKind.ADD && diff.getKind() == DifferenceKind.ADD) {
                Resource candidateRes;
                Resource diffRes;
                if (diff.getSource() == DifferenceSource.LEFT) {
                    diffRes = match.getLeft().eResource();
                    candidateRes = match.getRight().eResource();
                } else {
                    diffRes = match.getRight().eResource();
                    candidateRes = match.getLeft().eResource();
                }
                if (this.getMatchResource(comparison, diffRes) == this.getMatchResource(comparison, candidateRes)) {
                    kind = ConflictKind.PSEUDO;
                }
            } else if (candidate.getKind() == DifferenceKind.MOVE && diff.getKind() == DifferenceKind.MOVE && (lhsURI = diff.getResourceURI()).equals(rhsURI = ((ResourceAttachmentChange)candidate).getResourceURI())) {
                kind = ConflictKind.PSEUDO;
            }
            this.conflictOn(comparison, diff, candidate, kind);
        }
        if (diff.getKind() == DifferenceKind.DELETE && (o = this.getRelatedModelElement(diff)) != null && o.eContainer() == null) {
            Iterable extendedCandidates = StreamSupport.stream(match.getAllDifferences().spliterator(), false).filter(EMFCompareJavaPredicates.possiblyConflictingWith(diff))::iterator;
            for (Diff extendedCandidate : extendedCandidates) {
                if (ComparisonUtil.isDeleteOrUnsetDiff(extendedCandidate)) continue;
                this.conflictOn(comparison, diff, extendedCandidate, ConflictKind.REAL);
            }
        }
    }

    private EObject getRelatedModelElement(ResourceAttachmentChange diff) {
        EObject o;
        Match m = diff.getMatch();
        switch (diff.getSource()) {
            case LEFT: {
                o = m.getLeft();
                break;
            }
            case RIGHT: {
                o = m.getRight();
                break;
            }
            default: {
                o = null;
            }
        }
        return o;
    }

    protected MatchResource getMatchResource(Comparison comparison, Resource resource) {
        EList<MatchResource> matchedResources = comparison.getMatchedResources();
        int size = matchedResources.size();
        MatchResource soughtMatch = null;
        int i = 0;
        while (i < size && soughtMatch == null) {
            MatchResource matchRes = (MatchResource)matchedResources.get(i);
            if (matchRes.getRight() == resource || matchRes.getLeft() == resource || matchRes.getOrigin() == resource) {
                soughtMatch = matchRes;
            }
            ++i;
        }
        if (soughtMatch == null) {
            throw new RuntimeException(EMFCompareMessages.getString("ResourceAttachmentChangeSpec.MissingMatch", resource.getURI().lastSegment()));
        }
        return soughtMatch;
    }

    protected void checkResourceAttachmentConflict(Comparison comparison, ResourceAttachmentChange diff, ReferenceChange candidate) {
        EObject o;
        if (candidate.getReference().isContainment()) {
            this.conflictOn(comparison, diff, candidate, ConflictKind.REAL);
        } else if (diff.getKind() == DifferenceKind.DELETE && (o = this.getRelatedModelElement(diff)) != null && o.eContainer() == null && candidate.getKind() != DifferenceKind.DELETE) {
            this.conflictOn(comparison, diff, candidate, ConflictKind.REAL);
        }
    }

    protected void conflictOn(Comparison comparison, Diff diff1, Diff diff2, ConflictKind kind) {
        Equivalence equivalence;
        Conflict conflict = null;
        Conflict toBeMerged = null;
        if (diff1.getConflict() != null) {
            conflict = diff1.getConflict();
            if (conflict.getKind() == ConflictKind.PSEUDO && conflict.getKind() != kind) {
                conflict.setKind(kind);
            }
            if (diff2.getConflict() != null) {
                toBeMerged = diff2.getConflict();
            }
        } else if (diff2.getConflict() != null) {
            conflict = diff2.getConflict();
            if (conflict.getKind() == ConflictKind.PSEUDO && conflict.getKind() != kind) {
                conflict.setKind(kind);
            }
        } else if (diff1.getEquivalence() != null) {
            equivalence = diff1.getEquivalence();
            for (Diff equ : equivalence.getDifferences()) {
                if (equ.getConflict() == null) continue;
                conflict = equ.getConflict();
                if (conflict.getKind() == ConflictKind.PSEUDO && conflict.getKind() != kind) {
                    conflict.setKind(kind);
                }
                if (diff2.getConflict() == null) break;
                toBeMerged = diff2.getConflict();
                break;
            }
        } else if (diff2.getEquivalence() != null) {
            equivalence = diff2.getEquivalence();
            for (Diff equ : equivalence.getDifferences()) {
                if (equ.getConflict() == null) continue;
                conflict = equ.getConflict();
                if (conflict.getKind() != ConflictKind.PSEUDO || conflict.getKind() == kind) break;
                conflict.setKind(kind);
                break;
            }
        }
        if (conflict == null) {
            conflict = CompareFactory.eINSTANCE.createConflict();
            conflict.setKind(kind);
            comparison.getConflicts().add((Object)conflict);
        }
        EList<Diff> conflictDiffs = conflict.getDifferences();
        if (toBeMerged != null) {
            for (Diff aDiff : new ArrayList<Diff>((Collection<Diff>)toBeMerged.getDifferences())) {
                if (conflictDiffs.contains(aDiff)) continue;
                conflictDiffs.add(aDiff);
            }
            if (toBeMerged.getKind() == ConflictKind.REAL && conflict.getKind() != ConflictKind.REAL) {
                conflict.setKind(ConflictKind.REAL);
            }
            EcoreUtil.remove((EObject)toBeMerged);
            toBeMerged.getDifferences().clear();
        }
        if (!conflict.getDifferences().contains((Object)diff1)) {
            conflict.getDifferences().add((Object)diff1);
        }
        if (!conflict.getDifferences().contains((Object)diff2)) {
            conflict.getDifferences().add((Object)diff2);
        }
    }
}

