/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.security.internal.ui.editor;

import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.RedoAction;
import org.eclipse.emf.edit.ui.action.UndoAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.EditorActionBarContributor;

public class CDOSecurityFormActionBarContributor
extends EditorActionBarContributor
implements IPropertyListener {
    private IEditorPart activeEditor;
    private UndoAction undoAction;
    private RedoAction redoAction;

    public void init(IActionBars actionBars) {
        super.init(actionBars);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.undoAction = new UndoAction();
        this.undoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        this.redoAction = new RedoAction();
        this.redoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        if (this.activeEditor != null) {
            this.deactivate();
        }
        this.activeEditor = targetEditor;
        if (this.activeEditor instanceof IEditingDomainProvider) {
            this.activate();
        }
    }

    protected void activate() {
        this.activeEditor.addPropertyListener((IPropertyListener)this);
        if (this.undoAction != null) {
            this.undoAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        }
        if (this.redoAction != null) {
            this.redoAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        }
        this.update();
    }

    protected void deactivate() {
        this.activeEditor.removePropertyListener((IPropertyListener)this);
        if (this.undoAction != null) {
            this.undoAction.setActiveWorkbenchPart(null);
        }
        if (this.redoAction != null) {
            this.redoAction.setActiveWorkbenchPart(null);
        }
        this.update();
    }

    protected void update() {
        if (this.undoAction != null) {
            this.undoAction.update();
        }
        if (this.redoAction != null) {
            this.redoAction.update();
        }
    }

    public void propertyChanged(Object source, int propId) {
        this.update();
    }
}

