/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.markers;

import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.pde.api.tools.ui.internal.markers.MarkerMessages;
import org.eclipse.pde.api.tools.ui.internal.preferences.ApiErrorsWarningsConfigurationBlock;
import org.eclipse.pde.internal.ui.correction.OptionalMessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class PDEConfigureProblemSeverityAction
extends Action {
    private static final String CONFIGURE_PROBLEM_SEVERITY_DIALOG_ID = "configure_problem_severity_dialog_id";
    private final IJavaProject fProject;
    private final String fOptionId;
    private int tab;

    public PDEConfigureProblemSeverityAction(IJavaProject project, String optionId, int t) {
        this.fProject = project;
        this.fOptionId = optionId;
        this.tab = t;
    }

    public void run() {
        String pageId;
        boolean showPropertyPage;
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (!this.hasProjectSpecificOptions()) {
            String[] buttons;
            String message = MessageFormat.format(MarkerMessages.PDEConfigureProblemSeverityAction_0, JavaElementLabels.getElementLabel((IJavaElement)this.fProject, (long)0x200009L));
            int result = OptionalMessageDialog.open((String)CONFIGURE_PROBLEM_SEVERITY_DIALOG_ID, (Shell)shell, (String)MarkerMessages.PDEConfigureProblemSeverityAction_3, null, (String)message, (int)3, (String[])(buttons = new String[]{MarkerMessages.PDEConfigureProblemSeverityAction_1, MarkerMessages.PDEConfigureProblemSeverityAction_2, IDialogConstants.CANCEL_LABEL}), (int)0, (String)MarkerMessages.PDEConfigureProblemSeverityAction_4);
            if (result == 1025) {
                showPropertyPage = false;
            } else {
                if (result == 2 || result == -1) {
                    return;
                }
                showPropertyPage = result == 0;
            }
        } else {
            showPropertyPage = true;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (showPropertyPage) {
            pageId = "org.eclipse.pde.api.tools.ui.apitools.warningspage";
            data.put("use_project_specific_key", Boolean.TRUE);
        } else {
            pageId = "org.eclipse.pde.api.tools.ui.apitools.errorwarnings.prefpage";
        }
        data.put("select_option_key", this.fOptionId);
        data.put("select_option_qualifier", "org.eclipse.pde.api.tools");
        data.put("PropertyAndPreferencePage.initialTab", this.tab);
        if (showPropertyPage) {
            PreferencesUtil.createPropertyDialogOn((Shell)shell, (IAdaptable)this.fProject, (String)pageId, null, data).open();
        } else {
            PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)pageId, null, data).open();
        }
    }

    private boolean hasProjectSpecificOptions() {
        ApiErrorsWarningsConfigurationBlock.Key[] keys = ApiErrorsWarningsConfigurationBlock.getAllKeys();
        if (this.fProject.getProject() != null) {
            ProjectScope projectContext = new ProjectScope(this.fProject.getProject());
            ApiErrorsWarningsConfigurationBlock.Key[] keyArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                ApiErrorsWarningsConfigurationBlock.Key key = keyArray[n2];
                if (key.getStoredValue((IScopeContext)projectContext, null) != null) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

