/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.policy.snapping;

import java.util.List;
import org.eclipse.draw2d.geometry.Interval;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.gef.policy.snapping.ComponentSnapPoint;
import org.eclipse.wb.internal.core.gef.policy.snapping.IFeedbackProxy;
import org.eclipse.wb.internal.core.gef.policy.snapping.IVisualDataProvider;
import org.eclipse.wb.internal.core.gef.policy.snapping.PlacementUtils;

public final class BaselineComponentSnapPoint
extends ComponentSnapPoint {
    private int m_baseline;
    private int m_anchorBaseline;

    public BaselineComponentSnapPoint(IVisualDataProvider visualDataProvider, IAbstractComponentInfo anchorComponent) {
        super(visualDataProvider, anchorComponent, 8, 0);
    }

    @Override
    protected void calculateSnapPoint(List<? extends IAbstractComponentInfo> beingSnappedList) {
        this.m_anchorChildBounds = PlacementUtils.getTranslatedBounds(this.m_visualDataProvider, this.m_anchorComponent);
        this.m_snapPoint = this.m_anchorChildBounds.y + this.m_anchorBaseline - this.m_baseline;
    }

    @Override
    protected Interval getYSnapInterval() {
        return new Interval(this.m_anchorChildBounds.y, this.m_anchorChildBounds.height);
    }

    @Override
    protected boolean checkDirection() {
        return false;
    }

    @Override
    protected boolean snapAllowed(List<? extends IAbstractComponentInfo> beingSnappedList) {
        if (super.snapAllowed(beingSnappedList) && !this.m_isResizing) {
            if (beingSnappedList.size() > 1) {
                return false;
            }
            IAbstractComponentInfo beingSnapped = beingSnappedList.get(0);
            this.m_baseline = this.m_visualDataProvider.getBaseline(beingSnapped);
            if (this.m_baseline == -1) {
                return false;
            }
            this.m_anchorBaseline = this.m_visualDataProvider.getBaseline(this.m_anchorComponent);
            return this.m_anchorBaseline != -1;
        }
        return false;
    }

    @Override
    public void addFeedback(Rectangle snappedBounds, IFeedbackProxy feedbackProxy, List<Figure> feedbacks) {
        Rectangle anchorChildBounds = PlacementUtils.getTranslatedBounds(this.m_visualDataProvider, this.m_anchorComponent);
        Rectangle unionBounds = snappedBounds.getUnion(anchorChildBounds);
        unionBounds.expand(8, 0);
        feedbacks.add(feedbackProxy.addHorizontalFeedbackLine(snappedBounds.y + this.m_baseline, unionBounds.x, unionBounds.width));
    }
}

