/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.core.gist;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.github.core.Gist;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.service.GistService;
import org.eclipse.mylyn.internal.github.core.GitHub;
import org.eclipse.mylyn.internal.github.core.RepositoryConnector;
import org.eclipse.mylyn.internal.github.core.gist.GistAttachmentHandler;
import org.eclipse.mylyn.internal.github.core.gist.GistTaskDataHandler;
import org.eclipse.mylyn.internal.github.core.gist.Messages;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentHandler;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.core.sync.ISynchronizationSession;

public class GistConnector
extends RepositoryConnector {
    public static final String KIND = "githubGists";
    private GistTaskDataHandler dataHandler = new GistTaskDataHandler();
    private GistAttachmentHandler attachmentHandler = new GistAttachmentHandler();

    public static GitHubClient createClient(TaskRepository repository) {
        GitHubClient client = GitHubClient.createClient((String)repository.getRepositoryUrl());
        return GistConnector.configureClient(client, repository);
    }

    public static GitHubClient configureClient(GitHubClient client, TaskRepository repository) {
        GitHub.addCredentials(client, repository);
        return GitHub.configureClient(client);
    }

    public AbstractTaskDataHandler getTaskDataHandler() {
        return this.dataHandler;
    }

    public AbstractTaskAttachmentHandler getTaskAttachmentHandler() {
        return this.attachmentHandler;
    }

    @Override
    public boolean canCreateNewTask(TaskRepository repository) {
        return false;
    }

    public String getConnectorKind() {
        return KIND;
    }

    public String getLabel() {
        return Messages.GistConnector_LabelConnector;
    }

    public String getRepositoryUrlFromTaskUrl(String taskFullUrl) {
        int lastSlash = taskFullUrl.lastIndexOf(47);
        return lastSlash >= 0 ? taskFullUrl.substring(0, lastSlash) : null;
    }

    public TaskData getTaskData(TaskRepository repository, String taskId, IProgressMonitor monitor) throws CoreException {
        GistService service = new GistService(GistConnector.createClient(repository));
        try {
            TaskAttributeMapper mapper = this.dataHandler.getAttributeMapper(repository);
            Gist gist = service.getGist(taskId);
            TaskData data = new TaskData(mapper, this.getConnectorKind(), repository.getUrl(), gist.getId());
            data.setPartial(false);
            this.dataHandler.fillTaskData(repository, data, gist);
            if (gist.getComments() > 0) {
                this.dataHandler.fillComments(repository, data, service.getComments(gist.getId()));
            }
            return data;
        }
        catch (IOException e) {
            throw new CoreException(GitHub.createWrappedStatus(e));
        }
    }

    public IStatus performQuery(TaskRepository repository, IRepositoryQuery query, TaskDataCollector collector, ISynchronizationSession session, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        GistService service = new GistService(GistConnector.createClient(repository));
        String user = query.getAttribute("user");
        try {
            TaskAttributeMapper mapper = this.dataHandler.getAttributeMapper(repository);
            for (Gist gist : service.getGists(user)) {
                TaskData data = new TaskData(mapper, this.getConnectorKind(), repository.getUrl(), gist.getId());
                data.setPartial(true);
                this.dataHandler.fillTaskData(repository, data, gist);
                collector.accept(data);
            }
        }
        catch (IOException e) {
            status = GitHub.createWrappedStatus(e);
        }
        return status;
    }
}

