/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfhtml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jst.pagedesigner.converter.AbstractTagConverter;
import org.eclipse.jst.pagedesigner.converter.JSFConverterUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CommandButtonTagConverter
extends AbstractTagConverter {
    private List _nonVisualChildren = Collections.EMPTY_LIST;

    public CommandButtonTagConverter(Element host) {
        super(host);
    }

    protected Element doConvertRefresh() {
        String type;
        Element hostEle = this.getHostElement();
        Element inputEle = this.createElement("input");
        JSFConverterUtil.copyAllAttributes((Element)hostEle, (Element)inputEle, null);
        JSFConverterUtil.copyAttribute((Element)hostEle, (String)"styleClass", (Element)inputEle, (String)"class");
        inputEle.removeAttribute("styleClass");
        String imageAttr = hostEle.getAttribute("image");
        if (imageAttr == null || imageAttr.length() == 0) {
            type = hostEle.getAttribute("type");
            if (type == null || type.length() == 0) {
                type = "submit";
            }
        } else {
            type = "image";
            String src = this.mapURL(imageAttr);
            inputEle.setAttribute("src", src);
        }
        inputEle.setAttribute("type", type);
        String value = hostEle.getAttribute("value");
        if (value != null && value.length() > 0) {
            value = this.mapValue(value);
            inputEle.setAttribute("value", value);
        }
        if (hostEle.hasChildNodes()) {
            this._nonVisualChildren = new ArrayList();
            NodeList list = hostEle.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                if (node.getNodeType() == 1) {
                    this._nonVisualChildren.add(node);
                }
                ++i;
            }
        }
        return inputEle;
    }

    public boolean isMultiLevel() {
        return true;
    }

    public boolean isWidget() {
        return true;
    }

    public List getNonVisualChildren() {
        return this._nonVisualChildren;
    }
}

