/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.model.business.internal.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.EdgeMappingImport;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.model.business.internal.description.spec.EdgeMappingImportWrapper;

public final class ContentLayerHelper {
    private ContentLayerHelper() {
    }

    public static EList<EdgeMapping> getAllEdgeMappings(Layer layer) {
        ArrayList<EdgeMapping> result = new ArrayList<EdgeMapping>();
        result.addAll((Collection<EdgeMapping>)layer.getEdgeMappings());
        Iterator iterMappingImport = layer.getEdgeMappingImports().iterator();
        while (iterMappingImport.hasNext()) {
            result.add(EdgeMappingImportWrapper.getWrapper((EdgeMappingImport)iterMappingImport.next()));
        }
        for (DiagramElementMapping eObj : ContentLayerHelper.getReuseMappings(layer)) {
            if (!(eObj instanceof EdgeMapping)) continue;
            result.add((EdgeMapping)eObj);
        }
        return new BasicEList(result);
    }

    public static Collection<DiagramElementMapping> getReuseMappings(Layer layer) {
        LinkedHashSet<DiagramElementMapping> mappings = new LinkedHashSet<DiagramElementMapping>(layer.getReusedMappings().size());
        mappings.addAll((Collection<DiagramElementMapping>)layer.getReusedMappings());
        mappings.removeAll((Collection<?>)layer.getContainerMappings());
        mappings.removeAll((Collection<?>)layer.getNodeMappings());
        mappings.removeAll((Collection<?>)layer.getEdgeMappings());
        Iterator iterMappingImport = layer.getEdgeMappingImports().iterator();
        while (iterMappingImport.hasNext()) {
            mappings.remove(EdgeMappingImportWrapper.getWrapper((EdgeMappingImport)iterMappingImport.next()));
        }
        return mappings;
    }
}

