/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.diagnostics;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.internal.diagnostics.DiagnosticsExecutionWizardPage;
import org.eclipse.mat.ui.internal.diagnostics.DiagnosticsSelectionWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;

public class DiagnosticsWizardAction
extends Action
implements IWorkbenchWindowActionDelegate {
    public void run() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        DiagnosticsWizard wizard = new DiagnosticsWizard();
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.setHelpAvailable(true);
        dialog.addPageChangedListener((IPageChangedListener)wizard);
        dialog.open();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public static class DiagnosticsWizard
    extends Wizard
    implements IWorkbenchWizard,
    IPageChangedListener {
        private DiagnosticsSelectionWizardPage selectionPage;
        private DiagnosticsExecutionWizardPage executionPage;
        private boolean executionSucceeded;

        public DiagnosticsWizard() {
            this.setWindowTitle(Messages.DiagnosticsWizard_DialogName);
            this.setNeedsProgressMonitor(true);
        }

        public void addPages() {
            this.selectionPage = new DiagnosticsSelectionWizardPage();
            this.executionPage = new DiagnosticsExecutionWizardPage();
            this.addPage((IWizardPage)this.selectionPage);
            this.addPage((IWizardPage)this.executionPage);
        }

        public boolean performFinish() {
            if (this.executionSucceeded) {
                return true;
            }
            if (!this.getContainer().getCurrentPage().equals(this.executionPage)) {
                this.getContainer().showPage((IWizardPage)this.executionPage);
            }
            if (this.executionPage.performFinish(this.selectionPage.getSelectedAction())) {
                this.executionSucceeded = true;
            }
            return false;
        }

        public boolean canFinish() {
            return this.selectionPage.isPageComplete() && this.executionPage.isPageComplete();
        }

        public IWizardPage getStartingPage() {
            return this.selectionPage;
        }

        public void init(IWorkbench workbench, IStructuredSelection selection) {
        }

        public void pageChanged(PageChangedEvent event) {
            if (event.getSelectedPage().equals((Object)this.selectionPage)) {
                this.executionSucceeded = false;
                this.executionPage.clearText();
            } else if (event.getSelectedPage().equals(this.executionPage)) {
                this.executionPage.reset();
            }
        }
    }

    public static class Handler
    extends AbstractHandler {
        public Object execute(ExecutionEvent executionEvent) {
            new DiagnosticsWizardAction().run();
            return null;
        }
    }
}

