/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.apt.internal.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.util.filter.DependencyFilterUtils;
import org.eclipse.aether.util.graph.transformer.ChainedDependencyGraphTransformer;
import org.eclipse.aether.util.graph.transformer.ConflictResolver;
import org.eclipse.aether.util.graph.transformer.JavaDependencyContextRefiner;
import org.eclipse.aether.util.graph.transformer.JavaScopeDeriver;
import org.eclipse.aether.util.graph.transformer.JavaScopeSelector;
import org.eclipse.aether.util.graph.transformer.NearestVersionSelector;
import org.eclipse.aether.util.graph.transformer.SimpleOptionalitySelector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginDependencyResolver {
    private static final Logger log = LoggerFactory.getLogger(PluginDependencyResolver.class);

    public synchronized List<File> getResolvedPluginDependencies(MavenSession mavenSession, MavenProject mavenProject, Plugin plugin, IProgressMonitor monitor) throws CoreException {
        monitor.setTaskName("Resolve plugin dependency");
        IMaven maven = MavenPlugin.getMaven();
        DefaultRepositorySystemSession session = new DefaultRepositorySystemSession(mavenSession.getRepositorySession());
        ConflictResolver transformer = new ConflictResolver((ConflictResolver.VersionSelector)new NearestVersionSelector(), (ConflictResolver.ScopeSelector)new JavaScopeSelector(), (ConflictResolver.OptionalitySelector)new SimpleOptionalitySelector(), (ConflictResolver.ScopeDeriver)new JavaScopeDeriver());
        session.setDependencyGraphTransformer((DependencyGraphTransformer)new ChainedDependencyGraphTransformer(new DependencyGraphTransformer[]{transformer, new JavaDependencyContextRefiner()}));
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<File> files = new ArrayList<File>();
        try {
            Thread.currentThread().setContextClassLoader(maven.getProjectRealm(mavenProject));
            ArtifactTypeRegistry stereotypes = session.getArtifactTypeRegistry();
            CollectRequest request = new CollectRequest();
            request.setRequestContext("plugin");
            request.setRepositories(mavenProject.getRemoteProjectRepositories());
            Collection<Dependency> dependencies = this.getDependencies(plugin);
            for (Dependency dependency : dependencies) {
                request.addDependency(RepositoryUtils.toDependency((Dependency)dependency, (ArtifactTypeRegistry)stereotypes));
            }
            DependencyFilter classpathFilter = DependencyFilterUtils.classpathFilter((String[])new String[]{"compile", "runtime"});
            DependencyRequest dependencyRequest = new DependencyRequest(request, classpathFilter);
            try {
                RepositorySystem system = MavenPluginActivator.getDefault().getRepositorySystem();
                List artifactResults = system.resolveDependencies((RepositorySystemSession)session, dependencyRequest).getArtifactResults();
                for (ArtifactResult artifactResult : artifactResults) {
                    files.add(artifactResult.getArtifact().getFile());
                }
            }
            catch (DependencyResolutionException e) {
                String msg = "Unable to collect dependencies for plugin";
                log.error(msg, (Throwable)e);
                throw new CoreException(Status.error((String)msg, (Throwable)e));
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return files;
    }

    protected Collection<Dependency> getDependencies(Plugin plugin) {
        return plugin.getDependencies();
    }
}

