/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.jeview.views;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.jeview.views.JEAttribute;

public class JEMarker
extends JEAttribute {
    private JEAttribute fParent;
    private String fName;
    private IMarker fMarker;

    JEMarker(JEAttribute parent, String name, IMarker marker) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)name);
        Assert.isNotNull((Object)marker);
        this.fParent = parent;
        this.fName = name;
        this.fMarker = marker;
    }

    @Override
    public JEAttribute getParent() {
        return this.fParent;
    }

    @Override
    public JEAttribute[] getChildren() {
        return EMPTY;
    }

    @Override
    public String getLabel() {
        return String.valueOf(this.fName) + ": (" + this.getMarkerAttribute("severity") + ") " + this.getMarkerAttribute("message");
    }

    public Object getMarkerAttribute(String attributeName) {
        try {
            return this.fMarker.getAttribute(attributeName);
        }
        catch (CoreException e) {
            return ((Object)((Object)e)).getClass().getSimpleName();
        }
    }

    public IMarker getMarker() {
        return this.fMarker;
    }

    @Override
    public Object getWrappedObject() {
        return this.fMarker;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        JEMarker other = (JEMarker)obj;
        if (!this.fParent.equals(other.fParent)) {
            return false;
        }
        if (!this.fName.equals(other.fName)) {
            return false;
        }
        return this.fMarker.equals((Object)other.fMarker);
    }

    @Override
    public int hashCode() {
        return this.fParent.hashCode() + this.fName.hashCode() + this.fMarker.hashCode();
    }
}

