/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.reference;

import java.text.MessageFormat;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.databinding.property.value.SimpleValueProperty;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.spi.swt.table.ECPCellEditor;
import org.eclipse.emf.ecp.edit.spi.util.ECPModelElementChangeListener;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;

public class LinkCellEditor
extends CellEditor
implements ECPCellEditor {
    private Link link;
    private AdapterFactoryItemDelegator adapterFactoryItemDelegator;
    private ComposedAdapterFactory composedAdapterFactory;
    private ECPModelElementChangeListener modelElementChangeListener;

    public LinkCellEditor(Composite parent) {
        super(parent);
    }

    public LinkCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    public IValueProperty getValueProperty() {
        return new SimpleValueProperty(){

            public Object getValueType() {
                return String.class;
            }

            protected Object doGetValue(Object source) {
                return LinkCellEditor.this.doGetValue();
            }

            protected void doSetValue(Object source, Object value) {
                LinkCellEditor.this.doSetValue(value);
            }

            public IObservableValue observe(Object source) {
                if (source instanceof LinkCellEditor) {
                    return this.observe(LinkCellEditor.this.link);
                }
                return super.observe(source);
            }

            public INativePropertyListener adaptListener(ISimplePropertyListener listener) {
                return null;
            }
        };
    }

    @Override
    public void instantiate(EStructuralFeature eStructuralFeature, ViewModelContext viewModelContext) {
    }

    protected Control createControl(Composite parent) {
        this.composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        this.adapterFactoryItemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)this.composedAdapterFactory);
        this.link = new Link(parent, 0);
        this.link.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_edit_cellEditor_reference");
        this.link.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetDefaultSelected(SelectionEvent e) {
                super.widgetDefaultSelected(e);
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
            }
        });
        return this.link;
    }

    protected Object doGetValue() {
        return this.link.getText();
    }

    public void dispose() {
        this.composedAdapterFactory.dispose();
        if (this.modelElementChangeListener != null) {
            this.modelElementChangeListener.remove();
        }
        super.dispose();
    }

    protected void doSetFocus() {
        this.link.setFocus();
    }

    protected void doSetValue(Object value) {
        String linkName = this.adapterFactoryItemDelegator.getText(value);
        this.link.setText("<a>" + linkName + "</a>");
    }

    protected void focusLost() {
        if (this.isActivated()) {
            this.applyEditorValueAndDeactivate();
        }
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        super.keyReleaseOccured(keyEvent);
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\t') {
            this.applyEditorValueAndDeactivate();
        }
    }

    void applyEditorValueAndDeactivate() {
        Object newValue = this.doGetValue();
        this.markDirty();
        boolean isValid = this.isCorrect(newValue);
        this.setValueValid(isValid);
        if (!isValid) {
            MessageFormat.format(this.getErrorMessage(), newValue);
        }
        this.fireApplyEditorValue();
        this.deactivate();
    }

    @Override
    public String getFormatedString(Object value) {
        return this.adapterFactoryItemDelegator.getText(value);
    }

    @Override
    public int getColumnWidthWeight() {
        return 100;
    }

    @Override
    public UpdateValueStrategy getTargetToModelStrategy(DataBindingContext databindingContext) {
        return null;
    }

    @Override
    public UpdateValueStrategy getModelToTargetStrategy(DataBindingContext databindingContext) {
        return null;
    }

    @Override
    public void setEditable(boolean editable) {
        if (this.link != null) {
            this.link.setEnabled(editable);
        }
    }

    @Override
    public Image getImage(Object value) {
        return null;
    }

    @Override
    public int getMinWidth() {
        return 0;
    }
}

