/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.aggregation;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.query.runtime.rete.aggregation.GroupedSet;

public class GroupedMap<GroupedKeyType, ValueType>
implements Map<Tuple, ValueType> {
    protected final Tuple group;
    private final int groupSize;
    protected final Map<GroupedKeyType, ValueType> mappings;
    protected final IQueryRuntimeContext runtimeContext;

    public GroupedMap(Tuple group, Map<GroupedKeyType, ValueType> mappings, IQueryRuntimeContext runtimeContext) {
        this.group = group;
        this.groupSize = group.getSize();
        this.mappings = mappings;
        this.runtimeContext = runtimeContext;
    }

    @Override
    public int size() {
        return this.mappings.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mappings.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.mappings.containsValue(value);
    }

    @Override
    public ValueType get(Object key) {
        if (key instanceof Tuple) {
            Object value = ((Tuple)key).get(this.groupSize);
            Object unwrappedValue = this.runtimeContext.unwrapElement(value);
            return this.mappings.get(unwrappedValue);
        }
        return null;
    }

    @Override
    public ValueType put(Tuple key, ValueType value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ValueType remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends Tuple, ? extends ValueType> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Tuple> keySet() {
        return new GroupedSet<Tuple, Object, Tuple>(this.group, this.mappings.keySet(), (g, v) -> Tuples.staticArityLeftInheritanceTupleOf((Tuple)g, (Object)this.runtimeContext.wrapElement(v)));
    }

    @Override
    public Collection<ValueType> values() {
        return this.mappings.values();
    }

    @Override
    public Set<Map.Entry<Tuple, ValueType>> entrySet() {
        return new GroupedSet<Tuple, Object, Map.Entry>(this.group, this.mappings.keySet(), (g, v) -> {
            Tuple key = Tuples.staticArityLeftInheritanceTupleOf((Tuple)g, (Object)this.runtimeContext.wrapElement(v));
            ValueType value = this.mappings.get(v);
            return new AbstractMap.SimpleEntry<Tuple, ValueType>(key, value);
        });
    }
}

