/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.search;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.tcf.te.ui.interfaces.ISearchMatcher;
import org.eclipse.tcf.te.ui.interfaces.ISearchable;
import org.eclipse.tcf.te.ui.search.AbstractSearcher;

public class DepthFirstSearcher
extends AbstractSearcher {
    private static final int START_INDEX = -1;
    private static final int END_INDEX = -2;
    private final LinkedList<StackElement> fSearchStack = new LinkedList();
    private boolean fForeward;

    public DepthFirstSearcher(TreeViewer viewer, ISearchable searchable) {
        super(viewer, searchable);
    }

    @Override
    public void setStartPath(TreePath path) {
        this.fSearchStack.clear();
        if (path == null) {
            Object obj = this.fViewer.getInput();
            path = new TreePath(new Object[]{obj});
        }
        this.initSearchContext(path);
    }

    public void setForeward(boolean foreward) {
        this.fForeward = foreward;
    }

    private void initSearchContext(TreePath start) {
        int count = start.getSegmentCount();
        int i = 0;
        while (i < count) {
            Object element = start.getSegment(i);
            this.fSearchStack.addLast(new StackElement(element, -1));
            if (i > 0) {
                NullProgressMonitor monitor = new NullProgressMonitor();
                Object parent = start.getSegment(i - 1);
                Object[] children = this.getUpdatedChildren(parent, (IProgressMonitor)monitor);
                int j = 0;
                while (j < children.length) {
                    if (children[j] == element) {
                        StackElement parentStack = this.fSearchStack.get(i - 1);
                        parentStack.index = j;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    @Override
    public TreePath searchNext(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        TreePath result = null;
        ISearchMatcher matcher = this.fSearchable.getMatcher();
        while (!this.fSearchStack.isEmpty() && result == null && !monitor.isCanceled()) {
            StackElement top = this.fSearchStack.getLast();
            if (!this.fForeward && top.index == -2 || this.fForeward && top.index == -1) {
                String elementText = this.fSearchable.getElementText(top.node);
                monitor.subTask(elementText);
                TreePath treePath = result = matcher.match(top.node) ? this.createContextPath() : null;
            }
            if (top.index == -2) {
                this.fSearchStack.removeLast();
                continue;
            }
            Object[] children = this.getUpdatedChildren(top.node, monitor);
            if (children != null && children.length > 0) {
                if (this.fForeward && top.index == children.length - 1 || !this.fForeward && top.index == 0) {
                    top.index = -2;
                    continue;
                }
                top.index = top.index == -1 ? (this.fForeward ? 0 : children.length - 1) : (this.fForeward ? top.index + 1 : top.index - 1);
                this.fSearchStack.addLast(new StackElement(children[top.index], -1));
                continue;
            }
            top.index = -2;
        }
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        return result;
    }

    private TreePath createContextPath() {
        StackElement[] contexts = new StackElement[this.fSearchStack.size()];
        this.fSearchStack.toArray(contexts);
        Object[] elements = new Object[contexts.length];
        int i = 0;
        while (i < contexts.length) {
            elements[i] = contexts[i].node;
            ++i;
        }
        return new TreePath(elements);
    }

    private class StackElement {
        Object node;
        int index;

        public StackElement(Object node, int index) {
            this.node = node;
            this.index = index;
        }
    }
}

