/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.jdt.ui.javaeditor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.eclipse.jdt.ui.javaeditor.JavaEditorHandler;
import org.eclipse.reddeer.eclipse.jdt.ui.javaeditor.NumberOfBreakpoints;
import org.eclipse.reddeer.workbench.impl.editor.TextEditor;
import org.hamcrest.Matcher;

public class JavaEditor
extends TextEditor {
    public JavaEditor() {
    }

    public JavaEditor(String title) {
        super(title);
    }

    public JavaEditor(Matcher<String> titleMatcher) {
        super(titleMatcher);
    }

    public void toggleBreakpoint(int lineNumber) {
        JavaEditorHandler.getInstance().toggleBreakpoint(this.getEditorPart(), lineNumber);
    }

    public void addBreakpoint(int lineNumber) {
        if (this.getBreakpoint(lineNumber) == null) {
            int currentNumberOfBreakpoints = this.getBreakpoints().size();
            this.toggleBreakpoint(lineNumber);
            new WaitUntil((WaitCondition)new NumberOfBreakpoints(currentNumberOfBreakpoints + 1));
        }
    }

    public void removeBreakpoint(int lineNumber) {
        if (this.getBreakpoint(lineNumber) != null) {
            int currentNumberOfBreakpoints = this.getBreakpoints().size();
            this.toggleBreakpoint(lineNumber);
            new WaitUntil((WaitCondition)new NumberOfBreakpoints(currentNumberOfBreakpoints - 1));
        }
    }

    public String getBreakpoint(int lineNumber) {
        IBreakpoint breakpoint = JavaEditorHandler.getInstance().getBreakpoint(this.getEditorPart(), lineNumber);
        if (breakpoint == null) {
            return null;
        }
        return JavaEditor.getBreakpointLabel(breakpoint);
    }

    public List<String> getBreakpoints() {
        ArrayList<String> breakpoints = new ArrayList<String>();
        for (IBreakpoint breakpoint : JavaEditorHandler.getInstance().getBreakpoints(this.getEditorPart())) {
            breakpoints.add(JavaEditor.getBreakpointLabel(breakpoint));
        }
        return breakpoints;
    }

    private static String getBreakpointLabel(IBreakpoint breakpoint) {
        try {
            String message = breakpoint.getMarker().getAttribute("message").toString();
            if (message != null && message.contains(":")) {
                return message.split(":", 2)[1];
            }
            throw new RedDeerException("Cannot parse breakpoint's message '" + message + "'.");
        }
        catch (CoreException coreException) {
            throw new RedDeerException("Cannot get breakpoint's attribute 'message'.");
        }
    }
}

