/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.ui.preferences;

import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.Preferences;
import org.eclipse.ptp.debug.core.IPDebugConstants;
import org.eclipse.ptp.internal.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.internal.debug.ui.PreferencesAdapter;
import org.eclipse.ptp.internal.debug.ui.messages.Messages;
import org.eclipse.ptp.internal.ui.preferences.AbstractPreferencePage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;

public class PDebugPreferencePage
extends AbstractPreferencePage {
    private Button fPathsButton = null;
    private Button fRegisteredProcessButton = null;
    private IntegerFieldEditor commandTimeoutField = null;
    private Button updateVariableOnSuspendButton = null;
    private Button updateVariableOnChangeButton = null;
    protected WidgetListener listener = new WidgetListener();

    public PDebugPreferencePage() {
        this.setDescription(Messages.PDebugPreferencePage_0);
        this.setPreferenceStore(new PreferencesAdapter(PTPDebugCorePlugin.getUniqueIdentifier()));
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.createSpacer(composite, 1);
        this.createViewSettingPreferences(composite);
        this.createSpacer(composite, 1);
        this.createCommunicationPreferences(composite);
        this.createSpacer(composite, 1);
        this.createVariablesPreferences(composite);
        this.setValues();
        return composite;
    }

    protected void createOtherDebugSetting(Composite parent) {
    }

    protected void createViewSettingPreferences(Composite parent) {
        Composite comp = this.createGroupComposite(parent, 1, false, Messages.PDebugPreferencePage_1);
        this.fPathsButton = this.createCheckButton(comp, Messages.PDebugPreferencePage_2);
        this.fRegisteredProcessButton = this.createCheckButton(comp, Messages.PDebugPreferencePage_3);
        this.fRegisteredProcessButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean isChecked = PDebugPreferencePage.this.fRegisteredProcessButton.getSelection();
                if (!isChecked) {
                    MessageDialog.openWarning((Shell)PDebugPreferencePage.this.getShell(), (String)Messages.PDebugPreferencePage_4, (String)Messages.PDebugPreferencePage_5);
                }
            }
        });
    }

    protected void createCommunicationPreferences(Composite parent) {
        Composite comp = this.createGroupComposite(parent, 1, false, Messages.PDebugPreferencePage_6);
        Composite spacingComposite = new Composite(comp, 0);
        spacingComposite.setLayout((Layout)new GridLayout());
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        spacingComposite.setLayoutData((Object)data);
        this.commandTimeoutField = new IntegerFieldEditor(IPDebugConstants.PREF_DEBUG_COMM_TIMEOUT, Messages.PDebugPreferencePage_7, spacingComposite);
        this.commandTimeoutField.setPreferenceStore(this.getPreferenceStore());
        this.commandTimeoutField.setValidateStrategy(0);
        this.commandTimeoutField.setValidRange(10000, Integer.MAX_VALUE);
        String minValue = Integer.toString(10000);
        String maxValue = Integer.toString(Integer.MAX_VALUE);
        this.commandTimeoutField.setErrorMessage(NLS.bind((String)Messages.PDebugPreferencePage_8, (Object[])new Object[]{minValue, maxValue}));
        this.commandTimeoutField.setEmptyStringAllowed(false);
        this.commandTimeoutField.setPropertyChangeListener((IPropertyChangeListener)this.listener);
        this.commandTimeoutField.load();
    }

    protected void createVariablesPreferences(Composite parent) {
        Composite comp = this.createGroupComposite(parent, 1, false, Messages.PDebugPreferencePage_9);
        this.updateVariableOnSuspendButton = this.createCheckButton(comp, Messages.PDebugPreferencePage_10);
        this.updateVariableOnChangeButton = this.createCheckButton(comp, Messages.PDebugPreferencePage_11);
    }

    public void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.fPathsButton.setSelection(store.getDefaultBoolean(IPDebugConstants.PREF_SHOW_FULL_PATHS));
        this.fRegisteredProcessButton.setSelection(store.getDefaultBoolean(IPDebugConstants.PREF_DEBUG_REGISTER_PROC_0));
        this.commandTimeoutField.setStringValue(String.valueOf(store.getDefaultInt(IPDebugConstants.PREF_DEBUG_COMM_TIMEOUT)));
        this.updateVariableOnSuspendButton.setSelection(store.getDefaultBoolean(IPDebugConstants.PREF_UPDATE_VARIABLES_ON_SUSPEND));
        this.updateVariableOnChangeButton.setSelection(store.getDefaultBoolean(IPDebugConstants.PREF_UPDATE_VARIABLES_ON_CHANGE));
        this.commandTimeoutField.loadDefault();
        super.performDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        Preferences.savePreferences((String)PTPDebugCorePlugin.getUniqueIdentifier());
        this.refreshView();
        return true;
    }

    protected void setValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.fPathsButton.setSelection(store.getBoolean(IPDebugConstants.PREF_SHOW_FULL_PATHS));
        this.fRegisteredProcessButton.setSelection(store.getBoolean(IPDebugConstants.PREF_DEBUG_REGISTER_PROC_0));
        this.commandTimeoutField.setStringValue(String.valueOf(store.getInt(IPDebugConstants.PREF_DEBUG_COMM_TIMEOUT)));
        this.updateVariableOnSuspendButton.setSelection(store.getBoolean(IPDebugConstants.PREF_UPDATE_VARIABLES_ON_SUSPEND));
        this.updateVariableOnChangeButton.setSelection(store.getBoolean(IPDebugConstants.PREF_UPDATE_VARIABLES_ON_CHANGE));
    }

    public void dispose() {
        this.commandTimeoutField.dispose();
        this.fPathsButton.dispose();
        this.fRegisteredProcessButton.dispose();
        this.updateVariableOnSuspendButton.dispose();
        this.updateVariableOnChangeButton.dispose();
        super.dispose();
    }

    protected void storeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue(IPDebugConstants.PREF_SHOW_FULL_PATHS, this.fPathsButton.getSelection());
        store.setValue(IPDebugConstants.PREF_DEBUG_REGISTER_PROC_0, this.fRegisteredProcessButton.getSelection());
        store.setValue(IPDebugConstants.PREF_DEBUG_COMM_TIMEOUT, this.commandTimeoutField.getIntValue());
        store.setValue(IPDebugConstants.PREF_UPDATE_VARIABLES_ON_SUSPEND, this.updateVariableOnSuspendButton.getSelection());
        store.setValue(IPDebugConstants.PREF_UPDATE_VARIABLES_ON_CHANGE, this.updateVariableOnChangeButton.getSelection());
        this.commandTimeoutField.store();
    }

    public boolean isValid() {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (!this.commandTimeoutField.isValid()) {
            this.setErrorMessage(this.commandTimeoutField.getErrorMessage());
            return false;
        }
        return true;
    }

    protected void refreshView() {
        IWorkbenchPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            IDebugView adapter;
            IViewPart part = pages[i].findView("org.eclipse.debug.ui.BreakpointView");
            if (part != null && (adapter = (IDebugView)part.getAdapter(IDebugView.class)) != null) {
                Viewer viewer = adapter.getViewer();
                IDebugModelPresentation pres = adapter.getPresentation(PTPDebugCorePlugin.getUniqueIdentifier());
                if (pres != null) {
                    pres.setAttribute("DISPLAY_FULL_PATHS", (Object)(this.fPathsButton.getSelection() ? Boolean.TRUE : Boolean.FALSE));
                }
                if (viewer instanceof StructuredViewer) {
                    final StructuredViewer structViewer = (StructuredViewer)viewer;
                    BusyIndicator.showWhile((Display)structViewer.getControl().getDisplay(), (Runnable)new Runnable(){

                        public void run() {
                            structViewer.refresh();
                        }
                    });
                }
            }
            ++i;
        }
    }

    protected class WidgetListener
    implements IPropertyChangeListener {
        protected WidgetListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            PDebugPreferencePage.this.setValid(PDebugPreferencePage.this.isValid());
        }
    }
}

