/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.ui.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ptp.internal.debug.core.PDebugModel;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public abstract class AbstractBreakpointRulerAction
extends Action
implements IUpdate {
    private IVerticalRulerInfo info;
    private IWorkbenchPart targetPart;
    private IBreakpoint breakpoint;

    protected IBreakpoint determineBreakpoint() {
        IBreakpoint[] breakpoints;
        IBreakpoint[] iBreakpointArray = breakpoints = PDebugModel.getBreakpoints();
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            ILineBreakpoint lineBreakpoint;
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (breakpoint instanceof ILineBreakpoint && this.breakpointAtRulerLine(lineBreakpoint = (ILineBreakpoint)breakpoint)) {
                return lineBreakpoint;
            }
            ++n2;
        }
        return null;
    }

    protected IVerticalRulerInfo getInfo() {
        return this.info;
    }

    protected void setInfo(IVerticalRulerInfo info) {
        this.info = info;
    }

    protected IWorkbenchPart getTargetPart() {
        return this.targetPart;
    }

    protected void setTargetPart(IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    protected IBreakpoint getBreakpoint() {
        return this.breakpoint;
    }

    protected void setBreakpoint(IBreakpoint breakpoint) {
        this.breakpoint = breakpoint;
    }

    protected boolean breakpointAtRulerLine(ILineBreakpoint pBreakpoint) {
        int lineNumber = this.getBreakpointLine(pBreakpoint);
        int rulerLine = this.getInfo().getLineOfLastMouseButtonActivity();
        return rulerLine == lineNumber;
    }

    private int getBreakpointLine(ILineBreakpoint breakpoint) {
        if (this.getTargetPart() instanceof ISaveablePart && ((ISaveablePart)this.getTargetPart()).isDirty()) {
            try {
                return breakpoint.getLineNumber();
            }
            catch (CoreException e) {
                DebugPlugin.log((Throwable)e);
            }
        } else {
            IDocument doc;
            Position position = this.getBreakpointPosition(breakpoint);
            if (position != null && (doc = this.getDocument()) != null) {
                try {
                    return doc.getLineOfOffset(position.getOffset());
                }
                catch (BadLocationException x) {
                    DebugPlugin.log((Throwable)x);
                }
            }
        }
        return -1;
    }

    private Position getBreakpointPosition(ILineBreakpoint breakpoint) {
        IAnnotationModel model = this.getAnnotationModel();
        if (model != null) {
            Iterator it = model.getAnnotationIterator();
            while (it.hasNext()) {
                Annotation ann = (Annotation)it.next();
                if (!(ann instanceof MarkerAnnotation) || !((MarkerAnnotation)ann).getMarker().equals((Object)breakpoint.getMarker())) continue;
                return model.getPosition(ann);
            }
        }
        return null;
    }

    private IDocument getDocument() {
        ITextEditor textEditor;
        IDocumentProvider provider;
        IWorkbenchPart targetPart = this.getTargetPart();
        if (targetPart instanceof ITextEditor && (provider = (textEditor = (ITextEditor)targetPart).getDocumentProvider()) != null) {
            return provider.getDocument((Object)textEditor.getEditorInput());
        }
        return null;
    }

    private IAnnotationModel getAnnotationModel() {
        ITextEditor textEditor;
        IDocumentProvider provider;
        IWorkbenchPart targetPart = this.getTargetPart();
        if (targetPart instanceof ITextEditor && (provider = (textEditor = (ITextEditor)targetPart).getDocumentProvider()) != null) {
            return provider.getAnnotationModel((Object)textEditor.getEditorInput());
        }
        return null;
    }
}

