/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.target;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.eclipse.m2e.pde.target.MavenTargetLocation;

public class BNDInstructions {
    private static final String BND_DEFAULT_PROPERTIES_PATH = "bnd-default.properties";
    public static final BNDInstructions EMPTY = new BNDInstructions("", null);
    private final String key;
    private final String instructions;

    public BNDInstructions(String key, String instructions) {
        this.key = key;
        this.instructions = instructions == null ? null : instructions.strip();
    }

    public String getKey() {
        return this.key;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public static BNDInstructions getDefaultInstructions() {
        try {
            Throwable throwable = null;
            Object var1_3 = null;
            try (InputStreamReader reader = BNDInstructions.getDefaultInstructionsReader();){
                return new BNDInstructions("", IOUtils.toString((Reader)reader));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("load default properties failed", e);
        }
    }

    public Properties asProperties() {
        Reader reader = this.instructions == null || this.instructions.isBlank() ? BNDInstructions.getDefaultInstructionsReader() : new StringReader(this.instructions);
        Properties properties = new Properties();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                try {
                    properties.load(reader);
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("conversion to properties failed", e);
        }
        return properties;
    }

    private static InputStreamReader getDefaultInstructionsReader() {
        return new InputStreamReader(MavenTargetLocation.class.getResourceAsStream(BND_DEFAULT_PROPERTIES_PATH), StandardCharsets.ISO_8859_1);
    }

    public boolean isEmpty() {
        return this.instructions == null || this.instructions.isBlank();
    }
}

