/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.ui.celleditor;

import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class ExtendedTreeEditor
extends TreeEditor
implements SelectionListener,
MouseListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    protected Tree tree;
    protected TreeItem selectedTreeItem;
    protected TreeItem editTreeItem;

    public ExtendedTreeEditor(Tree tree) {
        super(tree);
        this.tree = tree;
        tree.addKeyListener((KeyListener)this);
        tree.addMouseListener((MouseListener)this);
        tree.addSelectionListener((SelectionListener)this);
    }

    public void mouseDoubleClick(MouseEvent event) {
    }

    public void mouseDown(MouseEvent event) {
        if (event.button == 1) {
            TreeItem treeItem = this.tree.getItem(new Point(event.x, event.y));
            this.editTreeItem = treeItem == this.selectedTreeItem ? treeItem : null;
        }
    }

    public void mouseUp(MouseEvent event) {
        TreeItem treeItem;
        if (event.button == 1 && this.editTreeItem == (treeItem = this.tree.getItem(new Point(event.x, event.y))) && this.editTreeItem != null) {
            this.editTreeItem = null;
            this.editItem(treeItem);
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    public void widgetSelected(SelectionEvent event) {
        TreeItem[] selection;
        Control control = this.getEditor();
        if (control != null && !control.isDisposed()) {
            this.setEditor(null);
            control.dispose();
        }
        this.selectedTreeItem = (selection = this.tree.getSelection()).length == 1 ? selection[0] : null;
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
        if (event.character == ' ' && this.selectedTreeItem != null) {
            this.editItem(this.selectedTreeItem);
        }
    }

    protected abstract void editItem(TreeItem var1);
}

