/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.NameGenerator;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.Rule2MiddleType;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.Rule2TraceGroup;
import org.eclipse.qvtd.compiler.internal.usage.DomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;

public abstract class Transformation2TracePackage {
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull NameGenerator nameGenerator;
    protected final @NonNull Transformation transformation;
    private final @NonNull Package tracePackage;
    protected final @NonNull Map<@NonNull String, @NonNull Nameable> name2rule2middleType = new HashMap<String, Nameable>();
    protected final @NonNull Map<@NonNull Rule, @NonNull Rule2TraceGroup> rule2rule2traceGroup = new HashMap<Rule, Rule2TraceGroup>();
    private @NonNull Map<@NonNull Type, @NonNull Rule2MiddleType> middleClass2rule2middleType = new HashMap<Type, Rule2MiddleType>();
    private boolean frozen = false;

    protected Transformation2TracePackage(@NonNull ScheduleManager scheduleManager, @NonNull Transformation transformation) {
        this.scheduleManager = scheduleManager;
        this.nameGenerator = scheduleManager.getNameGenerator();
        this.transformation = transformation;
        this.tracePackage = this.createTracePackage();
        assert (scheduleManager.getMultipleScheduleManager() == scheduleManager);
        this.getTransformationTraceClass();
    }

    public void addDirectedRule(@NonNull Rule rule, @NonNull Rule2TraceGroup relation2traceGroup) {
        Rule2TraceGroup oldrelation2traceGroup = this.rule2rule2traceGroup.put(rule, relation2traceGroup);
        assert (oldrelation2traceGroup == null);
    }

    public @Nullable Property basicGetTraceProperty(@NonNull Type aClass, @NonNull VariableDeclaration rVariable) {
        Rule2MiddleType relation2TraceClass = this.middleClass2rule2middleType.get(aClass);
        if (relation2TraceClass == null) {
            return null;
        }
        return relation2TraceClass.basicGetTraceProperty(rVariable);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Class createClass(@NonNull Transformation transformation, @NonNull String className) {
        @NonNull List traceClasses = QVTbaseUtil.Internal.getOwnedClassesList((Package)this.tracePackage);
        String uniqueName = NameGenerator.getUniqueName(this.name2rule2middleType, className, transformation);
        Class traceClass = PivotUtil.createClass((String)uniqueName);
        traceClasses.add(traceClass);
        this.name2rule2middleType.put(uniqueName, (Nameable)transformation);
        return traceClass;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Class createClass(@NonNull Rule2MiddleType rule2middleType, @NonNull String className) {
        @NonNull List traceClasses = QVTbaseUtil.Internal.getOwnedClassesList((Package)this.tracePackage);
        String uniqueName = NameGenerator.getUniqueName(this.name2rule2middleType, className, rule2middleType);
        Class traceClass = PivotUtil.createClass((String)uniqueName);
        traceClasses.add(traceClass);
        this.middleClass2rule2middleType.put((Type)traceClass, rule2middleType);
        this.name2rule2middleType.put(uniqueName, rule2middleType);
        return traceClass;
    }

    protected @NonNull Package createTracePackage() {
        Package rPackage = this.transformation.getOwningPackage();
        String txName = this.transformation.getName();
        String traceTxName = "trace_" + txName;
        String traceTxNsPrefix = "P" + txName;
        StringBuilder s = new StringBuilder();
        this.getURI(rPackage, s);
        s.append("/" + txName);
        return PivotUtil.createPackage((String)traceTxName, (String)traceTxNsPrefix, (String)s.toString(), null);
    }

    public void freeze() {
        this.frozen = true;
    }

    public @NonNull Class getBagType(@NonNull Class traceClass) {
        return this.scheduleManager.getEnvironmentFactory().getCompleteEnvironment().getBagType((Type)traceClass, true, null, null);
    }

    public @NonNull Class getBooleanType() {
        return this.scheduleManager.getStandardLibrary().getBooleanType();
    }

    public @NonNull DomainUsageAnalysis getDomainUsageAnalysis() {
        return this.scheduleManager.getDomainUsageAnalysis();
    }

    public @NonNull NameGenerator getNameGenerator() {
        return this.nameGenerator;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull Iterable<@NonNull Rule2TraceGroup> getOrderedRule2TraceGroups() {
        @NonNull ArrayList relation2traceGroups = Lists.newArrayList(this.rule2rule2traceGroup.values());
        Collections.sort(relation2traceGroups, OverrideDepthComparator.INSTANCE);
        return relation2traceGroups;
    }

    protected @NonNull Property getProperty(Type aClass, String name) throws CompilerChainException {
        assert (aClass != null && name != null);
        CompleteClass completeClass = this.scheduleManager.getEnvironmentFactory().getCompleteModel().getCompleteClass(aClass);
        Property p = completeClass.getProperty(name);
        if (p != null) {
            return p;
        }
        throw new CompilerChainException("No property '" + name + "' in '" + aClass + "::" + "'", new Object[0]);
    }

    public @NonNull Rule2TraceGroup getRule2TraceGroup(@NonNull Rule rule) {
        Rule2TraceGroup rule2TraceGroup = this.rule2rule2traceGroup.get(rule);
        if (rule2TraceGroup == null) {
            rule2TraceGroup = this.scheduleManager.createRule2TraceGroup(this, rule);
            this.rule2rule2traceGroup.put(rule, rule2TraceGroup);
        }
        return rule2TraceGroup;
    }

    public @NonNull ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }

    public @NonNull Property getSignatureProperty(@NonNull Rule invokedRule, @NonNull VariableDeclaration variable) {
        throw new UnsupportedOperationException();
    }

    public @NonNull Class getTraceClass(@NonNull Rule rule) {
        return this.getRule2TraceGroup(rule).getTraceClass();
    }

    public @NonNull Package getTracePackage() {
        return this.tracePackage;
    }

    public @NonNull Property getTraceProperty(@NonNull Type aClass, @NonNull VariableDeclaration rVariable) throws CompilerChainException {
        Property property = this.basicGetTraceProperty(aClass, rVariable);
        if (property != null) {
            return property;
        }
        property = this.getProperty(aClass, rVariable.getName());
        if (rVariable instanceof Property) assert (rVariable == property);
        return property;
    }

    public abstract @Nullable Class getTransformationTraceClass();

    private void getURI(Package rPackage, @NonNull StringBuilder s) {
        if (rPackage == null) {
            s.append(this.scheduleManager.getTraceBaseURI());
        } else if (rPackage.getURI() != null) {
            s.append(rPackage.getURI());
        } else {
            this.getURI(rPackage.getOwningPackage(), s);
            String name = rPackage.getName();
            if (name.length() > 0) {
                s.append("/");
                s.append(name);
            }
        }
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public @NonNull String toString() {
        return String.valueOf(this.transformation);
    }

    static class OverrideDepthComparator
    implements Comparator<Rule2TraceGroup> {
        public static final @NonNull OverrideDepthComparator INSTANCE = new OverrideDepthComparator();

        OverrideDepthComparator() {
        }

        @Override
        public int compare(@NonNull Rule2TraceGroup o1, @NonNull Rule2TraceGroup o2) {
            int d2;
            int d1 = this.getDepth(o1);
            if (d1 != (d2 = this.getDepth(o2))) {
                return d1 - d2;
            }
            String n1 = o1.getName();
            String n2 = o2.getName();
            return n1.compareTo(n2);
        }

        private int getDepth(@NonNull Rule2TraceGroup rule2traceGroup) {
            int depth = 0;
            Rule aRule = rule2traceGroup.getRule();
            while ((aRule = aRule.getOverridden()) != null) {
                ++depth;
            }
            return depth;
        }
    }
}

