/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.internal.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.ptp.internal.ui.widgets.ComboGroup;
import org.eclipse.ptp.internal.ui.widgets.ComboMold;
import org.eclipse.ptp.internal.ui.widgets.ControlsRelationshipHandler;
import org.eclipse.ptp.internal.ui.widgets.Frame;
import org.eclipse.ptp.internal.ui.widgets.FrameMold;
import org.eclipse.ptp.internal.ui.widgets.GenericControlMold;
import org.eclipse.ptp.internal.ui.widgets.TextGroup;
import org.eclipse.ptp.internal.ui.widgets.TextMold;
import org.eclipse.ptp.launch.internal.messages.Messages;
import org.eclipse.ptp.launch.internal.rulesengine.UploadRule;
import org.eclipse.ptp.launch.rulesengine.ISynchronizationRule;
import org.eclipse.ptp.launch.ui.IRuleDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;

public class UploadRuleDialog
extends TitleAreaDialog
implements IRuleDialog {
    Composite content;
    Button defaultRemoteDirectoryButton;
    ControlsRelationshipHandler remoteDirectoryRelationshipHandler;
    TextGroup remoteDirectoryText;
    Button asReadOnlyButton;
    Button asExecutableButton;
    Button downloadBackButton;
    Button preserveTimeStampButton;
    ComboGroup overwritePolicyCombo;
    Button removeFilesButton;
    Button addFilesFromFilesystemButton;
    Button addDirectoriesFromFilesystemButton;
    Button addFilesFromWorkspaceButton;
    List fileList;
    UploadRule uploadRule;
    IPath lastSelectedDirectory = ResourcesPlugin.getWorkspace().getRoot().getLocation();
    private int listenersEnabled = 0;
    ResourceSelectionDialog resourceDialog = null;

    public UploadRuleDialog(Shell parentShell, UploadRule rule) {
        super(parentShell);
        this.uploadRule = rule;
    }

    protected Control createDialogArea(Composite parent) {
        this.content = new Composite(parent, 2048);
        GridLayout layout = new GridLayout();
        this.content.setLayout((Layout)layout);
        this.content.setLayoutData((Object)new GridData(1808));
        this.setTitle(Messages.UploadRuleDialog_Title);
        this.setMessage(Messages.UploadRuleDialog_Message);
        this.createRemoteDirectoryComposite(this.content);
        this.createFilesComposite(this.content);
        this.createOptionsComposite(this.content);
        this.putFieldContents();
        return this.content;
    }

    private void putFieldContents() {
        this.disableListeners();
        this.defaultRemoteDirectoryButton.setSelection(this.uploadRule.isDefaultRemoteDirectory());
        this.remoteDirectoryRelationshipHandler.manageDependentControls(this.defaultRemoteDirectoryButton);
        if (this.uploadRule.getRemoteDirectory() != null) {
            this.remoteDirectoryText.setString(this.uploadRule.getRemoteDirectory());
        } else {
            this.remoteDirectoryText.setString("");
        }
        this.asReadOnlyButton.setSelection(this.uploadRule.isAsReadOnly());
        this.asExecutableButton.setSelection(this.uploadRule.isAsExecutable());
        this.downloadBackButton.setSelection(this.uploadRule.isDownloadBack());
        this.preserveTimeStampButton.setSelection(this.uploadRule.isPreserveTimeStamp());
        this.overwritePolicyCombo.selectIndexUsingID(Integer.toString(this.uploadRule.getOverwritePolicy()));
        Object[] items = this.uploadRule.getLocalFilesAsStringArray();
        Arrays.sort(items);
        this.fileList.setItems((String[])items);
        this.enableListeners();
    }

    private void enableListeners() {
        ++this.listenersEnabled;
    }

    private void disableListeners() {
        --this.listenersEnabled;
    }

    private void fetchFieldContents() {
        this.disableListeners();
        this.uploadRule.setDefaultRemoteDirectory(this.defaultRemoteDirectoryButton.getSelection());
        this.uploadRule.setRemoteDirectory(this.remoteDirectoryText.getString());
        this.uploadRule.setAsExecutable(this.asExecutableButton.getSelection());
        this.uploadRule.setAsReadOnly(this.asReadOnlyButton.getSelection());
        this.uploadRule.setDownloadBack(this.downloadBackButton.getSelection());
        this.uploadRule.setPreserveTimeStamp(this.preserveTimeStampButton.getSelection());
        this.uploadRule.setOverwritePolicy(Integer.parseInt(this.overwritePolicyCombo.getSelectionId()));
        this.uploadRule.setLocalFiles(this.fileList.getItems());
        String path = this.remoteDirectoryText.getString().trim();
        if (path.length() > 0) {
            this.uploadRule.setRemoteDirectory(path);
        } else {
            this.uploadRule.setRemoteDirectory(null);
        }
        this.enableListeners();
    }

    protected void okPressed() {
        this.fetchFieldContents();
        super.okPressed();
    }

    private Composite createRemoteDirectoryComposite(Composite parent) {
        Frame frame = new Frame(parent, Messages.UploadRuleDialog_RemoteDirectoryFrame_Title);
        Composite contents = frame.getComposite();
        this.defaultRemoteDirectoryButton = new Button(contents, 32);
        this.defaultRemoteDirectoryButton.setText(Messages.UploadRuleDialog_RemoteDirectoryFrame_LabelDefaultButton);
        this.defaultRemoteDirectoryButton.setLayoutData((Object)new GridData(768));
        TextMold mold = new TextMold(TextMold.GRID_DATA_GRAB_EXCESS_SPACE | TextMold.GRID_DATA_ALIGNMENT_FILL, Messages.UploadRuleDialog_RemoteDirectoryFrame_LabelDirectory);
        this.remoteDirectoryText = new TextGroup(contents, mold);
        this.remoteDirectoryRelationshipHandler = new ControlsRelationshipHandler(this.defaultRemoteDirectoryButton, new Control[]{this.remoteDirectoryText}, false);
        return this.remoteDirectoryText;
    }

    private Composite createFilesComposite(Composite parent) {
        FrameMold frameMold = new FrameMold();
        frameMold.setColumns(2);
        frameMold.setTitle(Messages.UploadRuleDialog_FileButtonsFrame_Title);
        Frame frame = new Frame(parent, frameMold);
        frame.setLayoutData((Object)new GridData(768));
        Frame filesFrame = new Frame(frame.getComposite());
        this.fileList = new List((Composite)filesFrame, 514);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 200;
        this.fileList.setLayoutData((Object)gridData);
        this.fileList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UploadRuleDialog.this.listenersEnabled < 0) {
                    return;
                }
                UploadRuleDialog.this.removeFilesButton.setEnabled(UploadRuleDialog.this.fileList.getSelectionCount() != 0);
            }
        });
        this.fileList.deselectAll();
        Frame buttonFrame = new Frame(frame.getComposite());
        Label label = new Label((Composite)buttonFrame, 0);
        label.setText(Messages.UploadRuleDialog_FileButtonsFrame_Description);
        label.setLayoutData((Object)new GridData(768));
        this.addFilesFromFilesystemButton = new Button((Composite)buttonFrame, 8);
        this.addFilesFromFilesystemButton.setText(Messages.UploadRuleDialog_FileButtonsFrame_AddFilesButton);
        this.addFilesFromFilesystemButton.setLayoutData((Object)new GridData(768));
        this.addFilesFromFilesystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UploadRuleDialog.this.listenersEnabled < 0) {
                    return;
                }
                UploadRuleDialog.this.handleFilesFromFilesystemButtonEvent();
            }
        });
        this.addDirectoriesFromFilesystemButton = new Button((Composite)buttonFrame, 8);
        this.addDirectoriesFromFilesystemButton.setText(Messages.UploadRuleDialog_FileButtonsFrame_AddDirectoryButton);
        this.addDirectoriesFromFilesystemButton.setLayoutData((Object)new GridData(768));
        this.addDirectoriesFromFilesystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UploadRuleDialog.this.listenersEnabled < 0) {
                    return;
                }
                UploadRuleDialog.this.handleDirectoryFromFilesystemButtonEvent();
            }
        });
        this.addFilesFromWorkspaceButton = new Button((Composite)buttonFrame, 8);
        this.addFilesFromWorkspaceButton.setText(Messages.UploadRuleDialog_FileButtonsFrame_AddWorkspaceButton);
        this.addFilesFromWorkspaceButton.setLayoutData((Object)new GridData(768));
        this.addFilesFromWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UploadRuleDialog.this.listenersEnabled < 0) {
                    return;
                }
                UploadRuleDialog.this.handleFilesFromWorkspaceButtonEvent();
            }
        });
        label = new Label((Composite)buttonFrame, 0);
        label.setText(Messages.UploadRuleDialog_FileButtonsFrame_RemoveFilesLabel);
        label.setLayoutData((Object)new GridData(768));
        this.removeFilesButton = new Button((Composite)buttonFrame, 8);
        this.removeFilesButton.setText(Messages.UploadRuleDialog_FileButtonsFrame_RemoveButton);
        this.removeFilesButton.setEnabled(false);
        this.removeFilesButton.setLayoutData((Object)new GridData(768));
        this.removeFilesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UploadRuleDialog.this.listenersEnabled < 0) {
                    return;
                }
                UploadRuleDialog.this.handleRemoveFilesButtonEvent();
            }
        });
        GridData gridData2 = new GridData();
        gridData2.grabExcessVerticalSpace = true;
        gridData2.verticalAlignment = 128;
        buttonFrame.setLayoutData((Object)gridData2);
        return frame;
    }

    private Composite createOptionsComposite(Composite parent) {
        FrameMold frameMold = new FrameMold();
        frameMold.setColumns(2);
        frameMold.addOption(FrameMold.COLUMNS_EQUAL_WIDTH);
        frameMold.setTitle(Messages.UploadRuleDialog_OptionsFrame_Title);
        Frame frame = new Frame(parent, frameMold);
        frame.setLayoutData((Object)new GridData(768));
        Composite contents = frame.getComposite();
        this.asReadOnlyButton = new Button(contents, 32);
        this.asReadOnlyButton.setText(Messages.UploadRuleDialog_OptionsFrame_ReadonlyCheck);
        this.asExecutableButton = new Button(contents, 32);
        this.asExecutableButton.setText(Messages.UploadRuleDialog_OptionsFrame_ExecutableCheck);
        this.downloadBackButton = new Button(contents, 32);
        this.downloadBackButton.setText(Messages.UploadRuleDialog_OptionsFrame_DownloadBackCheck);
        this.preserveTimeStampButton = new Button(contents, 32);
        this.preserveTimeStampButton.setText(Messages.UploadRuleDialog_OptionsFrame_PreserveTimeStampCheck);
        ComboMold mold = new ComboMold(ComboMold.GRID_DATA_SPAN);
        mold.setLabel(Messages.UploadRuleDialog_OptionsFrame_OverwriteLabel);
        mold.setTextFieldWidth(40);
        mold.addItem(Integer.toString(1), Messages.UploadRuleDialog_OptionsFrame_OverwriteCombo_SkipOption);
        mold.addItem(Integer.toString(2), Messages.UploadRuleDialog_OptionsFrame_OverwriteCombo_OverwriteOption);
        mold.addItem(Integer.toString(3), Messages.UploadRuleDialog_OptionsFrame_OverwriteCombo_OverwriteIfNewerOption);
        this.overwritePolicyCombo = new ComboGroup(contents, (GenericControlMold)mold);
        this.overwritePolicyCombo.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UploadRuleDialog.this.listenersEnabled < 0) {
                    return;
                }
                UploadRuleDialog.this.disableListeners();
                if (UploadRuleDialog.this.overwritePolicyCombo.getSelectionId().equals(Integer.toString(3))) {
                    UploadRuleDialog.this.preserveTimeStampButton.setEnabled(false);
                    UploadRuleDialog.this.preserveTimeStampButton.setSelection(true);
                } else {
                    UploadRuleDialog.this.preserveTimeStampButton.setEnabled(true);
                }
                UploadRuleDialog.this.enableListeners();
            }
        });
        return frame;
    }

    private void handleFilesFromFilesystemButtonEvent() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 4098);
        fileDialog.setFilterPath(this.lastSelectedDirectory.toOSString());
        fileDialog.setText(Messages.UploadRuleDialog_OptionsFrame_AddFileDialog_Title);
        String result = fileDialog.open();
        if (result != null) {
            this.lastSelectedDirectory = new Path(fileDialog.getFilterPath());
            IPath workspace = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            Path fileRoot = new Path(fileDialog.getFilterPath());
            HashSet<String> fileSet = new HashSet<String>(Arrays.asList(this.fileList.getItems()));
            for (IPath path : new PathIterable(fileDialog.getFileNames())) {
                String fullPath;
                if (!path.isAbsolute()) {
                    path = fileRoot.append(path);
                }
                if (workspace.isPrefixOf(path)) {
                    path = path.removeFirstSegments(workspace.segmentCount());
                    path = path.makeRelative();
                }
                if (fileSet.contains(fullPath = path.toOSString())) continue;
                fileSet.add(fullPath);
            }
            Object[] items = new String[fileSet.size()];
            items = fileSet.toArray(items);
            Arrays.sort(items);
            this.fileList.setItems((String[])items);
        }
    }

    private void handleDirectoryFromFilesystemButtonEvent() {
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell(), 4096);
        directoryDialog.setFilterPath(this.lastSelectedDirectory.toOSString());
        directoryDialog.setText(Messages.UploadRuleDialog_OptionsFrame_AddDirectoryDialog_Title);
        directoryDialog.setMessage(Messages.UploadRuleDialog_OptionsFrame_AddFileDialog_Description);
        String newPath = directoryDialog.open();
        if (newPath != null) {
            String fullPath;
            Path path;
            HashSet<String> fileSet = new HashSet<String>(Arrays.asList(this.fileList.getItems()));
            IPath workspace = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            if (workspace.isPrefixOf((IPath)(path = new Path(newPath)))) {
                path = path.removeFirstSegments(workspace.segmentCount());
                path = path.makeRelative();
            }
            if (!fileSet.contains(fullPath = path.toOSString())) {
                fileSet.add(fullPath);
                Object[] items = new String[fileSet.size()];
                items = fileSet.toArray(items);
                Arrays.sort(items);
                this.fileList.setItems((String[])items);
            }
            this.lastSelectedDirectory = new Path(newPath);
            this.lastSelectedDirectory = this.lastSelectedDirectory.removeLastSegments(1).removeTrailingSeparator();
        }
    }

    private void handleFilesFromWorkspaceButtonEvent() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        ArrayList<IResource> resourceList = new ArrayList<IResource>();
        for (IPath path : new PathIterable(this.fileList.getItems())) {
            IResource resource;
            if (path.isAbsolute() || (resource = root.findMember(path)) == null) continue;
            resourceList.add(resource);
        }
        Object[] initialSelection = resourceList.toArray();
        if (this.resourceDialog == null) {
            this.resourceDialog = new ResourceSelectionDialog(this.getShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), null);
        }
        this.resourceDialog.setInitialSelections(initialSelection);
        this.resourceDialog.setBlockOnOpen(true);
        this.resourceDialog.setMessage(Messages.UploadRuleDialog_OptionsFrame_AddWorkspaceDialog_Description);
        this.resourceDialog.setTitle(Messages.UploadRuleDialog_OptionsFrame_AddWorkspaceDialog_Title);
        this.resourceDialog.open();
        Object[] results = this.resourceDialog.getResult();
        if (results != null) {
            HashSet<String> newFileList = new HashSet<String>();
            for (IPath path : new PathIterable(this.fileList.getItems())) {
                if (!path.isAbsolute()) continue;
                newFileList.add(path.toOSString());
            }
            Object[] objectArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                Object result = objectArray[n2];
                IResource resource = (IResource)result;
                String entry = resource.getFullPath().makeRelative().toOSString();
                newFileList.add(entry);
                ++n2;
            }
            Object[] items = new String[newFileList.size()];
            items = newFileList.toArray(items);
            Arrays.sort(items);
            this.fileList.setItems((String[])items);
        }
    }

    private void handleRemoveFilesButtonEvent() {
        String[] selection = this.fileList.getSelection();
        if (selection.length == 0) {
            return;
        }
        HashSet<String> fileSet = new HashSet<String>(Arrays.asList(this.fileList.getItems()));
        String[] stringArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            fileSet.remove(string);
            ++n2;
        }
        Object[] items = new String[fileSet.size()];
        items = fileSet.toArray(items);
        Arrays.sort(items);
        this.fileList.setItems((String[])items);
    }

    @Override
    public ISynchronizationRule getRuleWorkingCopy() {
        return this.uploadRule;
    }

    private class PathIterable
    implements Iterable<IPath> {
        private final PathIterator iterator;

        public PathIterable(String[] array) {
            this.iterator = new PathIterator(array);
        }

        @Override
        public Iterator<IPath> iterator() {
            return this.iterator;
        }

        private class PathIterator
        implements Iterator<IPath> {
            private final Iterator<String> internalIterator;

            public PathIterator(String[] array) {
                this.internalIterator = Arrays.asList(array).iterator();
            }

            @Override
            public boolean hasNext() {
                return this.internalIterator.hasNext();
            }

            @Override
            public IPath next() {
                return new Path(this.internalIterator.next());
            }

            @Override
            public void remove() {
                this.internalIterator.remove();
            }
        }
    }
}

